/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.remote;

import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgentController;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;

public class RecorderCommandHandler
implements CustomCommandHandler {
    private RecorderAgentController parent;

    public RecorderCommandHandler(RecorderAgentController recorderAgentController) {
        this.parent = recorderAgentController;
    }

    public void handleCommand(CustomCommand customCommand) {
        try {
            if (customCommand.getData().equals("START")) {
                this.handleStartCommand();
            } else if (customCommand.getData().startsWith("StartRecording")) {
                this.handleStartRecordingCommand();
            } else if (customCommand.getData().startsWith("Init")) {
                this.handleInitCommand(customCommand);
            } else if (customCommand.getData().startsWith("Stop")) {
                this.handleStopCommand(customCommand);
            } else {
                this.parent.sendDebugMessageToDataProcessor("un-interpreted command: " + customCommand.getData());
            }
        }
        catch (Exception exception) {
            this.parent.reportException("error processing command " + customCommand.getData(), exception);
        }
    }

    private void handleStopCommand(CustomCommand customCommand) {
        this.parent.stopRecording();
    }

    private String stripFlag(CustomCommand customCommand) {
        String string = customCommand.getData();
        string = string.substring(string.indexOf(" "), string.length());
        return string.trim();
    }

    private void handleStartCommand() {
        this.parent.setOKToStart(true);
    }

    private void handleInitCommand(CustomCommand customCommand) {
        this.parent.initAgent(this.stripFlag(customCommand));
    }

    private void handleStartRecordingCommand() {
        this.parent.startRecording();
    }
}

