/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.w3c.dom.Element;

public class Component
implements IComponent {
    protected AdapterSensor logger = null;
    private short loggingLevel = (short)76;
    private String name = null;
    private String role = null;
    private String executableClassName = null;
    private String description = null;
    private String uniqueID = null;
    private String roleVersion = null;
    private String implVersion = null;
    private String roleVersionDescription = null;
    private String implVersionDescription = null;
    private String roleCreationDate = null;
    private String implCreationDate = null;
    private IComponent[] components = null;
    private ISimpleEventFactory eventFactory = null;
    private IComponentIdentification sourceComponentId = null;
    protected boolean stopping = false;
    private Element configuration = null;
    private Element contextConfiguration = null;
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();

    public Component() {
        this.sourceComponentId = this.getEventFactory().createComponentIdentification();
        this.sourceComponentId.setComponent(this.getName());
        this.sourceComponentId.setSubComponent(this.getUniqueID());
        this.sourceComponentId.setComponentIdType(this.getRole());
        this.sourceComponentId.setLocation("Test Source Component Location");
        this.sourceComponentId.setLocationType("Test Source Component Location Type");
    }

    public boolean init() {
        IComponent[] iComponentArray;
        Element element = this.getContextConfiguration();
        if (element.hasAttribute(Messages.getString("HyadesGADescriptionAttributeName"))) {
            this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleAttributeName"))) {
            this.setRole(element.getAttribute(Messages.getString("HyadesGARoleAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"))) {
            this.setLoggingLevel(Short.valueOf(element.getAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionAttributeName"))) {
            this.setRoleVersion(element.getAttribute(Messages.getString("HyadesGARoleVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"))) {
            this.setRoleCreationDate(element.getAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName"))) {
            this.setRoleVersionDescription(element.getAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"))) {
            this.setImplementationVersion(element.getAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"))) {
            this.setImplemenationCreationDate(element.getAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"))) {
            this.setImplementationVersionDescription(element.getAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName")));
        }
        if ((iComponentArray = this.getComponents()) != null) {
            int n = 0;
            while (n < iComponentArray.length) {
                iComponentArray[n].init();
                ++n;
            }
        }
        this.sourceComponentId.setComponent(this.getName());
        this.sourceComponentId.setSubComponent(this.getUniqueID());
        this.sourceComponentId.setComponentIdType(this.getRole());
        this.sourceComponentId.setLocation("Test Source Component Location");
        this.sourceComponentId.setLocationType("Test Source Component Location Type");
        return true;
    }

    public void start() {
    }

    public void stop(int n) {
    }

    public void stop() {
        this.stopping = true;
    }

    public void update(Element element) throws AdapterInvalidConfig {
        this.setConfiguration(element);
        this.update();
    }

    public void update() throws AdapterInvalidConfig {
        Element element = this.getConfiguration();
        this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        this.setUniqueID(element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")));
        IComponent[] iComponentArray = this.getComponents();
        if (iComponentArray != null) {
            int n = 0;
            while (n < iComponentArray.length) {
                iComponentArray[n].update();
                ++n;
            }
        }
    }

    public Element getContextConfiguration() {
        return this.contextConfiguration;
    }

    public void setContextConfiguration(Element element) {
        this.contextConfiguration = element;
    }

    public Element getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Element element) {
        this.configuration = element;
    }

    public AdapterSensor getLogger() {
        if (this.logger == null) {
            this.logger = AdapterSensor.getInstance();
        }
        return this.logger;
    }

    public ISimpleEventFactory getEventFactory() {
        if (this.eventFactory == null) {
            this.eventFactory = SimpleEventFactoryImpl.getInstance();
        }
        return this.eventFactory;
    }

    public short getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(short s) {
        this.loggingLevel = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String string) {
        this.uniqueID = string;
    }

    public String getExecutableClassName() {
        return this.executableClassName;
    }

    public void setExecutableClassName(String string) {
        this.executableClassName = string;
    }

    public String getRoleVersion() {
        return this.roleVersion;
    }

    public void setRoleVersion(String string) {
        this.roleVersion = string;
    }

    public String getRoleCreationDate() {
        return this.roleCreationDate;
    }

    public void setRoleCreationDate(String string) {
        this.roleCreationDate = string;
    }

    public String getRoleVersionDescription() {
        return this.roleVersionDescription;
    }

    public void setRoleVersionDescription(String string) {
        this.roleVersionDescription = string;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public void setImplementationVersion(String string) {
        this.implVersion = string;
    }

    public String getImplementationCreationDate() {
        return this.implCreationDate;
    }

    public void setImplemenationCreationDate(String string) {
        this.implCreationDate = string;
    }

    public String getImplementationVersionDescription() {
        return this.implVersionDescription;
    }

    public void setImplementationVersionDescription(String string) {
        this.implVersionDescription = string;
    }

    public IComponent[] getComponents() {
        return this.components;
    }

    public void setComponents(IComponent[] iComponentArray) {
        this.components = iComponentArray;
    }

    public void clean() {
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = null;
            ++n;
        }
        this.components = null;
    }

    public void log(String string, short s) {
        if (s <= this.loggingLevel) {
            ICommonBaseEvent iCommonBaseEvent = this.getEventFactory().createCommonBaseEvent();
            iCommonBaseEvent.setSourceComponentId(this.sourceComponentId);
            iCommonBaseEvent.setCreationTime(System.currentTimeMillis());
            iCommonBaseEvent.setSeverity(s);
            iCommonBaseEvent.setMsg(string);
            this.getLogger().addEvent(iCommonBaseEvent);
        }
    }
}

