/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.impl.AdapterContext;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.ComponentFactory;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ContextFactory;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.AdapterUtilities;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Controller
implements Runnable {
    private boolean singleFileInputMode = false;
    private AdapterSensor logger = null;
    private short loggingLevel = (short)76;
    private ISimpleEventFactory eventFactory = null;
    private IComponentIdentification sourceComponentId = null;
    private IContext[] contexts;
    private Thread[] contextThreads;
    String contextConfigurationFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
    String componentConfigurationFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private InputStream inContextParams = null;
    private InputStream inAppParams = null;
    boolean running = false;
    long sleepTime = 500L;

    public Controller() {
        if (this.eventFactory == null) {
            this.eventFactory = SimpleEventFactoryImpl.getInstance();
        }
        this.sourceComponentId = this.eventFactory.createComponentIdentification();
        this.sourceComponentId.setComponent("Controller");
        this.sourceComponentId.setSubComponent("1");
        this.sourceComponentId.setComponentIdType("controller");
        this.sourceComponentId.setLocation("Test Source Component Location");
        this.sourceComponentId.setLocationType("Test Source Component Location Type");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.contextThreads = new Thread[this.contexts.length];
        int n = 0;
        while (n < this.contextThreads.length) {
            if (this.contexts[n] != null) {
                this.contextThreads[n] = new Thread(this.contexts[n]);
                this.contextThreads[n].setName(this.contexts[n].getName() + Messages.getString("HyadesGA") + this.contexts[n].getUniqueID());
                this.contextThreads[n].setDaemon(true);
                this.contextThreads[n].start();
            }
            ++n;
        }
        this.running = true;
    }

    public void stop() {
        if (this.contexts != null) {
            int n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null) {
                    this.contexts[n].stop();
                }
                ++n;
            }
        }
        this.running = false;
    }

    public void hardStop() {
        if (this.contexts != null) {
            int n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null) {
                    ((Context)this.contexts[n]).setHardStop();
                    this.contexts[n].stop();
                }
                ++n;
            }
        }
        this.running = false;
    }

    public IContext[] getContexts() {
        return this.contexts;
    }

    public void setContextConfigPath(String string) {
        this.contextConfigurationFile = string;
    }

    public void setComponentConfigPath(String string) {
        this.componentConfigurationFile = string;
    }

    /*
     * Loose catch block
     */
    public void prepareAdapter() throws AdapterException {
        block22: {
            this.inContextParams = new FileInputStream(this.contextConfigurationFile);
            this.contexts = this.createContextsAndComponents(this.inContextParams);
            this.inAppParams = this.singleFileInputMode ? new FileInputStream(this.contextConfigurationFile) : new FileInputStream(this.componentConfigurationFile);
            this.setComponentConfigurations(this.inAppParams);
            try {
                List list = AdapterPlugin.getContextListeners();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IContextListener iContextListener = (IContextListener)iterator.next();
                        String[] stringArray = iContextListener.getTargetContextUniqueIds();
                        int n = 0;
                        while (n < stringArray.length) {
                            int n2 = 0;
                            while (n2 < this.contexts.length) {
                                if (this.contexts[n2].getUniqueID().equals(stringArray[n])) {
                                    this.contexts[n2].setContextListener(iContextListener);
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null) {
                    this.contexts[n].init();
                    try {
                        this.contexts[n].update();
                    }
                    catch (AdapterException adapterException) {
                        this.contexts[n] = null;
                        this.log(Messages.getString("HyadesGAContextFatalError") + " " + adapterException.getMessage(), (short)60);
                    }
                }
                ++n;
            }
            Object var8_11 = null;
            try {
                if (this.inAppParams != null) {
                    this.inAppParams.close();
                }
                if (this.inContextParams != null) {
                    this.inContextParams.close();
                }
                break block22;
            }
            catch (IOException iOException) {
                this.log(iOException.toString(), (short)30);
            }
            break block22;
            {
                catch (Exception exception) {
                    this.log(exception.getMessage(), (short)60);
                    this.log(Messages.getString("HyadesGAAdapterFatalError"), (short)60);
                    throw new AdapterException(exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (this.inAppParams != null) {
                        this.inAppParams.close();
                    }
                    if (this.inContextParams != null) {
                        this.inContextParams.close();
                    }
                }
                catch (IOException iOException) {
                    this.log(iOException.toString(), (short)30);
                }
                throw throwable;
            }
        }
    }

    public void update(Element element) {
    }

    Context[] createContextsAndComponents(InputStream inputStream) {
        Document document = null;
        Context[] contextArray = null;
        try {
            Object object;
            document = this.docFactory.newDocumentBuilder().parse(inputStream);
            Element element = document.createElement(Messages.getString("HyadesGAContextElementTagName"));
            element.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            element.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.impl.AdapterContext");
            element.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "60");
            element.setAttribute(Messages.getString("HyadesGANameAttributeName"), "AdaptorContext");
            element.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "context");
            element.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            Element element2 = document.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            element2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging sensor");
            element2.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor");
            element2.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element2.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "0");
            element2.setAttribute(Messages.getString("HyadesGANameAttributeName"), "AdapterSensor");
            element2.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "sensor");
            element2.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            element.appendChild(element2);
            Element element3 = document.createElement(Messages.getString("HyadesGAComponentElementTagName"));
            element3.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Adapter logging outputter");
            element3.setAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element3.setAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"), "");
            element3.setAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"), "");
            element3.setAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"), "30");
            element3.setAttribute(Messages.getString("HyadesGARoleAttributeName"), "outputter");
            element3.setAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"), "Fri Jan 09 15:27:17 EST 2004");
            element3.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
            if (AdapterUtilities.isWorkbench()) {
                element3.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.outputters.CBEEclipseErrorDialogOutputter");
                element3.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEEclipseErrorDialogOutputter");
            } else {
                element3.setAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"), "org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter");
                element3.setAttribute(Messages.getString("HyadesGANameAttributeName"), "CBEFileOutputter");
            }
            element.appendChild(element3);
            NodeList nodeList = document.getElementsByTagName(Messages.getString("HyadesGAContextsElementTagName"));
            if (nodeList.getLength() == 0) {
                object = document.createElement(Messages.getString("HyadesGAContextsElementTagName"));
                object.appendChild(element);
                document.getDocumentElement().appendChild((Node)object);
            } else {
                object = nodeList.item(0);
                object.appendChild(element);
                document.getDocumentElement().appendChild((Node)object);
            }
            try {
                object = document.getElementsByTagName(Messages.getString("HyadesGAContextElementTagName"));
                NodeList nodeList2 = document.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                this.singleFileInputMode = nodeList2.getLength() > 0;
                int n = object.getLength();
                contextArray = new Context[n];
                int n2 = 0;
                Element element4 = null;
                Context context = null;
                Component component = null;
                int n3 = 0;
                while (n3 < n) {
                    element4 = (Element)object.item(n3);
                    context = ContextFactory.buildContext(element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element4.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                    context.setContextConfiguration(element4);
                    NodeList nodeList3 = element4.getElementsByTagName(Messages.getString("HyadesGAComponentElementTagName"));
                    IComponent[] iComponentArray = null;
                    int n4 = nodeList3.getLength();
                    iComponentArray = new IComponent[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < n4) {
                        element4 = (Element)nodeList3.item(n5);
                        String string = element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName"));
                        String string2 = element4.getAttribute(Messages.getString("HyadesGANameAttributeName"));
                        component = ComponentFactory.buildComponent(element4.getAttribute(Messages.getString("HyadesGAExecutableClassAttributeName")), element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")), element4.getAttribute(Messages.getString("HyadesGANameAttributeName")));
                        component.setContextConfiguration(element4);
                        iComponentArray[n6++] = component;
                        ++n5;
                    }
                    context.setComponents(iComponentArray);
                    contextArray[n2++] = context;
                    ++n3;
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
                return null;
            }
        }
        catch (SAXException sAXException) {
            this.log(sAXException.toString(), (short)30);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException.toString(), (short)30);
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), (short)30);
        }
        return contextArray;
    }

    private void setComponentConfigurations(InputStream inputStream) throws AdapterInvalidConfig {
        Document document = null;
        try {
            Object object;
            Object object2;
            document = this.docFactory.newDocumentBuilder().parse(inputStream);
            Element element = document.createElement(Messages.getString("HyadesGASensorTagName"));
            element.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "An adapter CBE sensor");
            element.setAttribute(Messages.getString("HyadesGAmaximumBlockingAttributeName"), "5");
            element.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NF991E0004FF11D8930381B6A308BEB5");
            Element element2 = document.createElement(Messages.getString("HyadesGAContextInstanceElementTagName"));
            element2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Context instance for the current component");
            element2.setAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"), "true");
            element2.setAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"), "600000");
            element2.setAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"), "10");
            element2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "NB1F4ED002DA11D8A519FBE7C98C2F53");
            element2.appendChild(element);
            if (AdapterUtilities.isWorkbench()) {
                object2 = document.createElement(Messages.getString("HyadesGAOutputterTagName"));
                object2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Eclipse error dialog outputter");
                object2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                element2.appendChild((Node)object2);
            } else {
                object2 = document.createElement(Messages.getString("HyadesGAOutputterTagName"));
                object2.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "Single file outputter");
                object2.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N5F286A002DA11D8BC799C6AF4352915");
                object = document.createElement(Messages.getString("HyadesGAPropertyTagName"));
                object.setAttribute(Messages.getString("HyadesGAPropertyValueTag"), ".");
                object.setAttribute(Messages.getString("HyadesGAPropertyNameTag"), Messages.getString("HyadesGAdirectoryAttributeName"));
                object2.appendChild((Node)object);
                object = document.createElement(Messages.getString("HyadesGAPropertyTagName"));
                object.setAttribute(Messages.getString("HyadesGAPropertyValueTag"), "hgla.log");
                object.setAttribute(Messages.getString("HyadesGAPropertyNameTag"), Messages.getString("HyadesGAfileNameAttributeName"));
                object2.appendChild((Node)object);
                element2.appendChild((Node)object2);
            }
            object2 = document.getElementsByTagName(Messages.getString("HyadesGAConfigurationTagName"));
            if (object2.getLength() == 0) {
                object = document.createElement(Messages.getString("HyadesGAConfigurationTagName"));
                object.setAttribute(Messages.getString("HyadesGADescriptionAttributeName"), "The component level configurations for this adapter");
                object.setAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"), "N06FBD3004FF11D8BCF4CFA9EA8F31E7");
                object.appendChild(element2);
                document.getDocumentElement().appendChild((Node)object);
            } else {
                object = object2.item(0);
                object.appendChild(element2);
                document.getDocumentElement().appendChild((Node)object);
            }
            try {
                object = document.getElementsByTagName(Messages.getString("HyadesGAContextInstanceElementTagName"));
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    try {
                        Element element3 = (Element)object.item(n2);
                        String string = element3.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                        int n3 = this.contexts.length;
                        if (n != n3) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextConfigurationErrorContextCountMismatchFatalError"));
                        }
                        boolean bl = false;
                        int n4 = 0;
                        while (n4 < n3) {
                            if (this.contexts[n4].getUniqueID().equals(string)) {
                                this.contexts[n4].setConfiguration(element3);
                                bl = true;
                                NodeList nodeList = element3.getChildNodes();
                                int n5 = nodeList.getLength();
                                IComponent[] iComponentArray = this.contexts[n4].getComponents();
                                int n6 = iComponentArray.length;
                                int n7 = 0;
                                int n8 = 0;
                                while (n8 < n5) {
                                    if (nodeList.item(n8).getNodeType() == 1) {
                                        Element element4 = (Element)nodeList.item(n8);
                                        String string2 = element4.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName"));
                                        boolean bl2 = false;
                                        ++n7;
                                        int n9 = 0;
                                        while (n9 < n6) {
                                            if (iComponentArray[n9].getUniqueID().equals(string2)) {
                                                iComponentArray[n9].setConfiguration(element4);
                                                bl2 = true;
                                                break;
                                            }
                                            ++n9;
                                        }
                                        if (!bl2) {
                                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentIdNotFoundFatalError", string2, this.contexts[n4].getUniqueID()));
                                        }
                                    }
                                    ++n8;
                                }
                                if (n7 == n6) break;
                                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentMismatchFatalError", this.contexts[n4].getUniqueID()));
                            }
                            ++n4;
                        }
                        if (!bl) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorContextIdNotFoundFatalError", string));
                        }
                    }
                    catch (AdapterInvalidConfig adapterInvalidConfig) {
                        throw adapterInvalidConfig;
                    }
                    catch (Exception exception) {
                        this.log(exception.toString(), (short)30);
                    }
                    ++n2;
                }
            }
            catch (AdapterInvalidConfig adapterInvalidConfig) {
                throw adapterInvalidConfig;
            }
            catch (Exception exception) {
                this.log(exception.toString(), (short)30);
                return;
            }
        }
        catch (SAXException sAXException) {
            this.log(sAXException.toString(), (short)30);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException.toString(), (short)30);
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), (short)30);
        }
    }

    public void run() {
        this.start();
        while (this.isRunning()) {
            Controller controller = this;
            synchronized (controller) {
                try {
                    this.wait(this.sleepTime);
                }
                catch (Exception exception) {
                    this.log(exception.toString(), (short)30);
                }
                if (this.areContextsDone()) {
                    this.stop();
                }
            }
        }
    }

    private boolean areContextsDone() {
        if (this.contextThreads != null) {
            int n = 0;
            while (n < this.contextThreads.length) {
                if (this.contextThreads[n] != null && this.contextThreads[n].isAlive() && !(this.contexts[n] instanceof AdapterContext)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void clean() {
        if (this.contexts != null) {
            int n = 0;
            while (n < this.contexts.length) {
                this.contexts[n] = null;
                ++n;
            }
        }
        this.contexts = null;
    }

    public AdapterSensor getLogger() {
        if (this.logger == null) {
            this.logger = AdapterSensor.getInstance();
        }
        return this.logger;
    }

    public ISimpleEventFactory getEventFactory() {
        if (this.eventFactory == null) {
            this.eventFactory = SimpleEventFactoryImpl.getInstance();
        }
        return this.eventFactory;
    }

    public void log(String string, short s) {
        if (s <= this.loggingLevel) {
            ICommonBaseEvent iCommonBaseEvent = this.getEventFactory().createCommonBaseEvent();
            iCommonBaseEvent.setSourceComponentId(this.sourceComponentId);
            iCommonBaseEvent.setCreationTime(System.currentTimeMillis());
            iCommonBaseEvent.setSeverity(s);
            iCommonBaseEvent.setMsg(string);
            this.getLogger().addEvent(iCommonBaseEvent);
        }
    }
}

