/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;

public class CBELogOutputter
extends Outputter
implements IOutputter {
    private LoggingAgent cbelogger = null;
    private static String defaultAgentName = "GenericAdapterCBELogger";
    private String agentName = null;
    private long waitTime = 0L;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return this.processCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        if (iCommonBaseEventArray.length > 0 && !this.cbelogger.isLogging() && this.getWaitTime() > 0L) {
            this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info", this.getUniqueID(), this.getAgentName()), (short)10);
            while (!this.cbelogger.waitUntilLogging(this.getWaitTime())) {
                this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info", this.getUniqueID(), this.getAgentName()), (short)10);
            }
        }
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                try {
                    this.cbelogger.write(iCommonBaseEventArray[n].toString());
                }
                catch (Exception exception) {
                    this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Write_Error", this.getUniqueID(), this.getAgentName()), (short)60);
                }
            }
            ++n;
        }
        return iCommonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof ICommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
        }
        return this.testProcessCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        return iCommonBaseEventArray;
    }

    public void update() throws AdapterInvalidConfig {
        Object object;
        super.update();
        Element element = this.getConfiguration();
        Element element2 = null;
        String string = null;
        Object var5_4 = null;
        Hashtable hashtable = this.getProperties();
        if (hashtable != null && !hashtable.isEmpty()) {
            string = (String)hashtable.get(Messages.getString("HyadesGAwaitTimeAttributeName"));
            if (string != null && string.length() > 0) {
                this.setWaitTime(Long.valueOf(string));
            }
            this.setAgentName((String)hashtable.get(Messages.getString("HyadesGAagentNameAttributeName")));
        } else {
            object = element.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                Element element3;
                if (object.item(n).getNodeType() == 1 && (element3 = (Element)object.item(n)).getTagName().equals(Messages.getString("HyadesGALogOutputterTypeTagName"))) {
                    String string2;
                    element2 = element3;
                    if (element2.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName")) && (string2 = element2.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) != null && !string2.equals("")) {
                        this.setWaitTime(Long.valueOf(string2));
                    }
                    if (element2.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName"))) {
                        this.setAgentName(element2.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));
                    }
                }
                ++n;
            }
        }
        if (this.cbelogger == null) {
            object = this.getAgentName() == null ? defaultAgentName : this.getAgentName();
            this.cbelogger = new LoggingAgent((String)object);
        }
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setWaitTime(long l) {
        this.waitTime = l;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void stop() {
        this.cbelogger.deregister();
    }
}

