/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StaticParserWrapper
extends Parser {
    private Adapter adapter;
    private String parserName;
    private String agentName;
    private String key = String.valueOf(System.currentTimeMillis());
    private String originalConfigFile = null;
    protected String newDirectory = null;
    protected String newFileName = null;
    protected String currentPlugin = "org.eclipse.hyades.logging.adapter.config";
    private static Hashtable activeWrappers = new Hashtable();

    public StaticParserWrapper() {
        this.adapter = new Adapter();
        this.parserName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
        this.agentName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
    }

    public static Log getLogInstance(String string) {
        return (Log)activeWrappers.remove(string);
    }

    public void parse(Log log) throws LogParserException {
        try {
            activeWrappers.put(this.key, log);
            this.adapter.start(false, false);
        }
        catch (AdapterException adapterException) {
            // empty catch block
        }
    }

    public void setUserInput(Hashtable hashtable) throws LogParserException {
        hashtable.put("loggerKey", this.key);
        String string = this.getNewConfigFile(hashtable);
        this.adapter.setContextConfigPath(string);
        this.adapter.setComponentConfigPath(string);
    }

    public String getName() {
        return this.agentName;
    }

    public ICommonBaseEvent[] parseNext() throws LogParserException {
        return null;
    }

    public String getVersion() {
        return null;
    }

    private InputStream getConfigInputStream(String string, Hashtable hashtable) throws LogParserException {
        String string2 = System.getProperty("file.separator");
        try {
            if (string.indexOf(47) != -1 && string2 != "/") {
                string = string.replace('/', string2.charAt(0));
            }
            if (string.startsWith("." + string2)) {
                string = string.substring(2);
            }
            return new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = (String)hashtable.get(Messages.getString((String)"HyadesGAConfigFileRootAttributeName")) + string2 + string;
            try {
                this.originalConfigFile = string3;
                return new FileInputStream(string3);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_Error", (String)string));
            }
            catch (SecurityException securityException) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_Error", (String)string));
            }
        }
        catch (SecurityException securityException) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_Error", (String)string));
        }
    }

    private String getNewConfigFile(Hashtable hashtable) throws LogParserException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Serializable serializable;
        Object object7;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        String string = (String)hashtable.get(Messages.getString((String)"HyadesGALogVersionTagName"));
        String string2 = null;
        if (string == null) {
            string = Messages.getString((String)"HyadesGADefaultLogVersionTagName");
        }
        if ((string2 = (String)hashtable.get(string)) == null && (string2 = (String)hashtable.get(Messages.getString((String)"HyadesGADefaultLogVersionTagName"))) == null) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_Error"));
        }
        InputStream inputStream = null;
        String string3 = null;
        this.originalConfigFile = string2;
        try {
            object7 = Boolean.TRUE;
            serializable = Class.forName("org.eclipse.core.runtime.Path");
            object6 = ((Class)serializable).getConstructor(string2.getClass());
            Object obj = ((Constructor)object6).newInstance(string2);
            Class<?> clazz = Class.forName("org.eclipse.core.runtime.Platform");
            object5 = Class.forName("org.eclipse.core.runtime.Plugin");
            object4 = clazz.getMethod("getPlugin", this.currentPlugin.getClass()).invoke(null, this.currentPlugin);
            inputStream = (InputStream)((Class)object5).getMethod("openStream", Class.forName("org.eclipse.core.runtime.IPath"), Boolean.TYPE).invoke(object4, obj, object7);
            string3 = new File(((URL)((Class)object5).getMethod("find", Class.forName("org.eclipse.core.runtime.IPath")).invoke(object4, obj)).getFile()).getParentFile().getAbsolutePath();
        }
        catch (ClassNotFoundException classNotFoundException) {
            inputStream = this.getConfigInputStream(string2, hashtable);
            string3 = new File(string2).getParentFile().getAbsolutePath();
        }
        catch (InvocationTargetException invocationTargetException) {
            inputStream = this.getConfigInputStream(string2, hashtable);
            string3 = new File(this.originalConfigFile).getParentFile().getAbsolutePath();
        }
        catch (Exception exception) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_Error", (String)string2), (Throwable)exception);
        }
        object7 = (String)hashtable.get(Messages.getString((String)"HyadesGAInputLogFilenameTag"));
        serializable = null;
        if (object7 != null && ((String)object7).trim().length() > 0) {
            serializable = new File(((String)object7).trim());
        }
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        object6 = document.getElementsByTagName(Messages.getString((String)"HyadesGASensorTagName"));
        int n = object6.getLength();
        int n2 = 0;
        while (n2 < n) {
            object5 = (Element)object6.item(n2);
            if (object5 != null) {
                Object object8;
                int n3;
                int n4;
                Object object9;
                object3 = null;
                boolean bl = false;
                boolean bl2 = false;
                Object object10 = null;
                Object object11 = null;
                NodeList nodeList = object5.getChildNodes();
                int n5 = 0;
                while (n5 < nodeList.getLength()) {
                    if (nodeList.item(n5).getNodeType() == 1) {
                        Object object12;
                        object4 = (Element)nodeList.item(n5);
                        if (object4.getTagName().equals(Messages.getString((String)"HyadesGAPropertyTagName"))) {
                            object12 = object4;
                            object2 = object12.getAttribute(Messages.getString((String)"HyadesGAPropertyNameTag"));
                            object = object12.getAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"));
                            if (((String)object2).equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                                object10 = object12;
                                if (serializable != null) {
                                    object12.setAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"), ((File)serializable).getParent());
                                }
                            } else if (((String)object2).equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                                object11 = object12;
                                if (serializable != null) {
                                    object12.setAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"), ((File)serializable).getName());
                                }
                            } else if (((String)object2).equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                                if (object != null && ((String)object).length() > 0) {
                                    object9 = this.modifyConverter((String)object, string3, hashtable, (File)serializable);
                                    object12.setAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"), (String)object9);
                                }
                            } else if (((String)object2).equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                                this.parserName = object;
                            } else {
                                object = (String)hashtable.get(object2);
                                if (object != null) {
                                    object12.setAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"), ((String)object).trim());
                                }
                            }
                        } else if (object4.getTagName().equals(Messages.getString((String)"HyadesGAGenericSensorTagName"))) {
                            object3 = object4;
                            object9 = object3.getElementsByTagName(Messages.getString((String)"HyadesGASensorPropertyTagName"));
                            n4 = object9.getLength();
                            n3 = 0;
                            while (n3 < n4) {
                                object12 = (Element)object9.item(n3);
                                object2 = object12.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameTag"));
                                object = object12.getAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"));
                                if (((String)object2).equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                                    object10 = object12;
                                    if (serializable != null) {
                                        object12.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), ((File)serializable).getParent());
                                    }
                                } else if (((String)object2).equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                                    object11 = object12;
                                    if (serializable != null) {
                                        object12.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), ((File)serializable).getName());
                                    }
                                } else if (((String)object2).equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                                    if (object != null && ((String)object).length() > 0) {
                                        object8 = this.modifyConverter((String)object, string3, hashtable, (File)serializable);
                                        object12.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), (String)object8);
                                    }
                                } else if (((String)object2).equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                                    this.parserName = object;
                                } else {
                                    object = (String)hashtable.get(object2);
                                    if (object != null) {
                                        object12.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), ((String)object).trim());
                                    }
                                }
                                ++n3;
                            }
                        } else if (object4.getTagName().equals(Messages.getString((String)"HyadesGAStaticParserSensorTagName")) || object4.getTagName().equals(Messages.getString((String)"HyadesGASingleFileSensorTagName"))) {
                            object3 = object4;
                            object9 = object3.getElementsByTagName(Messages.getString((String)"HyadesGASensorPropertyTagName"));
                            n4 = object9.getLength();
                            n3 = 0;
                            while (n3 < n4) {
                                object12 = (Element)object9.item(n3);
                                object2 = object12.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameTag"));
                                object = (String)hashtable.get(object2);
                                if (object != null) {
                                    object12.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), ((String)object).trim());
                                }
                                ++n3;
                            }
                            object8 = object3.getAttributes();
                            int n6 = object8.getLength();
                            int n7 = 0;
                            while (n7 < n6) {
                                Node node = object8.item(n7);
                                String string4 = node.getNodeName();
                                if (string4.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                                    if (serializable != null) {
                                        node.setNodeValue(((File)serializable).getParent());
                                    }
                                } else if (string4.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                                    if (serializable != null) {
                                        node.setNodeValue(((File)serializable).getName());
                                    }
                                } else if (string4.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                                    this.parserName = node.getNodeValue();
                                } else if (string4.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                                    String string5 = this.modifyConverter(node.getNodeValue(), string3, hashtable, (File)serializable);
                                    node.setNodeValue(string5);
                                } else {
                                    object = (String)hashtable.get(string4);
                                    if (object != null) {
                                        node.setNodeValue(((String)object).trim());
                                    }
                                }
                                ++n7;
                            }
                        }
                    }
                    ++n5;
                }
                object9 = object5.getAttributes();
                n4 = object9.getLength();
                n3 = 0;
                while (n3 < n4) {
                    object8 = object9.item(n3);
                    String string6 = object8.getNodeName();
                    object = (String)hashtable.get(string6);
                    if (object != null && ((String)object).length() > 0) {
                        object8.setNodeValue(((String)object).trim());
                    }
                    ++n3;
                }
                if (this.newDirectory != null) {
                    if (object10 != null) {
                        object10.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), this.newDirectory);
                    } else if (object3 != null) {
                        object8 = object3.getAttributeNode(Messages.getString((String)"HyadesGAdirectoryAttributeName"));
                        object8.setNodeValue(this.newDirectory);
                    }
                }
                if (this.newFileName != null) {
                    if (bl2) {
                        object11.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueTag"), this.newFileName);
                    } else if (object3 != null) {
                        object8 = object3.getAttributeNode(Messages.getString((String)"HyadesGAfileNameAttributeName"));
                        object8.setNodeValue(this.newFileName);
                    }
                }
            }
            ++n2;
        }
        object5 = document.getElementsByTagName(Messages.getString((String)"HyadesGAOutputterTagName"));
        int n8 = object5.getLength();
        int n9 = 0;
        while (n9 < n8) {
            object3 = (Element)object5.item(n9);
            object = document.createElement(Messages.getString((String)"HyadesGAPropertyTagName"));
            object.setAttribute(Messages.getString((String)"HyadesGAPropertyValueTag"), this.key);
            object.setAttribute(Messages.getString((String)"HyadesGAPropertyNameTag"), Messages.getString((String)"HyadesGAStaticParserLoggerKeyName"));
            object3.appendChild((Node)object);
            ++n9;
        }
        try {
            object3 = File.createTempFile("GLA", ".adapter");
        }
        catch (Exception exception) {
            object2 = new File(string2);
            String string7 = new String("GLA" + System.currentTimeMillis() + ".adapter");
            object3 = new File(((File)object2).getParent(), string7);
        }
        ((File)object3).deleteOnExit();
        this.saveConfigFile(document, (File)object3);
        return ((File)object3).getAbsolutePath();
    }

    protected String modifyConverter(String string, String string2, Hashtable hashtable, File file) {
        return string;
    }

    private void saveConfigFile(Document document, File file) {
        String string = System.getProperty("os.name", null);
        OutputFormat outputFormat = new OutputFormat(document);
        if (string.startsWith("Windows")) {
            outputFormat.setLineSeparator("\r\n");
        } else if (string.equals("z/OS") || string.equals("OS/390")) {
            outputFormat.setEncoding("IBM-1047");
        }
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setPreserveSpace(true);
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)new FileWriter(file), outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

