/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.util;

import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;

public final class XMLTypeUtil {
    public static boolean isSpace(char value) {
        return DataValue.XMLChar.isSpace(value);
    }

    public static String normalize(String value, boolean collapse) {
        if (value == null) {
            return null;
        }
        StringBuffer buffer = null;
        boolean skipSpace = collapse;
        int i = 0;
        int size = value.length();
        int offset = 0;
        while (i < size) {
            char c = value.charAt(i);
            if (XMLTypeUtil.isSpace(c)) {
                if (skipSpace) {
                    if (buffer == null) {
                        buffer = new StringBuffer(value);
                    }
                    buffer.deleteCharAt(i - offset++);
                } else {
                    skipSpace = collapse;
                    if (c != ' ') {
                        if (buffer == null) {
                            buffer = new StringBuffer(value);
                        }
                        buffer.setCharAt(i - offset, ' ');
                    }
                }
            } else {
                skipSpace = false;
            }
            ++i;
        }
        if (skipSpace) {
            int length;
            if (buffer == null) {
                length = value.length();
                if (length > 0) {
                    return value.substring(0, length - 1);
                }
                return value;
            }
            length = buffer.length();
            if (length > 0) {
                return buffer.substring(0, length - 1);
            }
            return buffer.toString();
        }
        if (buffer == null) {
            return value;
        }
        return buffer.toString();
    }

    public static EValidator.PatternMatcher createPatternMatcher(String pattern) {
        return new PatternMatcherImpl(pattern);
    }

    private static class PatternMatcherImpl
    implements EValidator.PatternMatcher {
        protected RegEx.RegularExpression regularExpression;

        public PatternMatcherImpl(String pattern) {
            this.regularExpression = new RegEx.RegularExpression(pattern, "X");
        }

        public boolean matches(String value) {
            return this.regularExpression.matches(value);
        }

        public String toString() {
            return this.regularExpression.getPattern();
        }
    }
}

