/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.util.EObjectsTraverser;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public class ContainmentTraverser
extends EObjectsTraverser {
    private boolean resolve;
    private ChildrenListPool childrenPool;

    public ContainmentTraverser(Collection contents) {
        super(contents);
        this.resolve = true;
        this.childrenPool = new ChildrenListPool();
    }

    public ContainmentTraverser(Collection contents, boolean resolve) {
        super(contents);
        this.resolve = resolve;
        this.childrenPool = new ChildrenListPool();
    }

    protected boolean traverseEObject(EObject object) {
        List children = this.childrenPool.alloc();
        this.populateChildren(object, children);
        boolean res = this.traverse(children);
        this.childrenPool.release(children);
        return res;
    }

    private void populateChildren(EObject parent, List children) {
        EList features = parent.eClass().getEAllContainments();
        int i = features.size() - 1;
        while (i >= 0) {
            EStructuralFeature sf = (EStructuralFeature)features.get(i);
            if (parent.eIsSet(sf)) {
                Object result = parent.eGet(sf, this.resolve);
                if (result instanceof EList) {
                    Iterator iter2 = this.getIterator((EList)result);
                    while (iter2.hasNext()) {
                        EObject element = (EObject)iter2.next();
                        if (element == null) continue;
                        children.add(element);
                    }
                } else if (result != null) {
                    children.add(result);
                }
            }
            --i;
        }
    }

    protected Iterator getIterator(EList result) {
        if (this.resolve) {
            return result.iterator();
        }
        return ((InternalEList)result).basicIterator();
    }

    protected EObject getElement(EObject traversedElement) {
        return traversedElement;
    }

    public static final class ChildrenListPool {
        private ArrayList lists = new ArrayList(20);
        private int currentEntryIndex = -1;

        public List alloc() {
            Object list;
            if (this.lists.size() == this.currentEntryIndex + 1) {
                list = new FastList();
                this.lists.add(list);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                list = (List)this.lists.get(this.currentEntryIndex);
            }
            return list;
        }

        public void release(List children) {
            children.clear();
            --this.currentEntryIndex;
        }
    }
}

