/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;

public class XMLMapImpl
implements XMLResource.XMLMap {
    protected static final String XSD2ECORE = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";
    protected Map ecoreToXMLInfo;
    protected EPackage noNamespacePkg;
    protected String idAttributeName;
    protected Map urisToNamesToClassifiers;
    protected Map eClassToFeatures;
    protected Set processedEPackages;
    protected EPackage.Registry packageRegistry = EPackage.Registry.INSTANCE;

    public XMLMapImpl() {
        this.ecoreToXMLInfo = new HashMap();
        this.processedEPackages = new HashSet();
        this.eClassToFeatures = new HashMap();
    }

    public void add(ENamedElement element, XMLResource.XMLInfo info) {
        this.ecoreToXMLInfo.put(element, info);
    }

    public XMLResource.XMLInfo getInfo(ENamedElement element) {
        XMLResource.XMLInfo result = (XMLResource.XMLInfo)this.ecoreToXMLInfo.get(element);
        if (result == null) {
            Iterator i = element.getEAnnotations().iterator();
            while (i.hasNext()) {
                EAnnotation eAnnotation = (EAnnotation)i.next();
                if (!XSD2ECORE.equals(eAnnotation.getSource())) continue;
                result = new XMLInfoImpl();
                EMap details = eAnnotation.getDetails();
                result.setName((String)details.get((Object)"name"));
                result.setTargetNamespace((String)details.get((Object)"targetNamespace"));
                String representation = (String)details.get((Object)"representation");
                if ("element".equals(representation)) {
                    result.setXMLRepresentation(0);
                    continue;
                }
                if ("attribute".equals(representation)) {
                    result.setXMLRepresentation(1);
                    continue;
                }
                if (!"simple-content".equals(representation)) continue;
                result.setXMLRepresentation(2);
            }
            if (result != null) {
                this.ecoreToXMLInfo.put(element, result);
            }
        }
        return result;
    }

    public void setNoNamespacePackage(EPackage pkg) {
        this.noNamespacePkg = pkg;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePkg;
    }

    public void setIDAttributeName(String name) {
        this.idAttributeName = name;
    }

    public String getIDAttributeName() {
        return this.idAttributeName;
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public EPackage.Registry getPackageRegistry() {
        return this.packageRegistry;
    }

    public EClassifier getClassifier(String namespaceURI, String name) {
        EPackage ePackage = this.packageRegistry.getEPackage(namespaceURI);
        if (ePackage != null) {
            Map namesToClassifiers;
            if (this.processedEPackages.add(ePackage)) {
                if (this.urisToNamesToClassifiers == null) {
                    this.urisToNamesToClassifiers = new HashMap();
                }
                this.getInfoForClassifiers(ePackage);
                Iterator i = this.ecoreToXMLInfo.entrySet().iterator();
                while (i.hasNext()) {
                    EClassifier eClassifier;
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    if (!(key instanceof EClassifier) || (eClassifier = (EClassifier)key).getEPackage() != ePackage) continue;
                    XMLResource.XMLInfo info = (XMLResource.XMLInfo)entry.getValue();
                    String uri = info.getTargetNamespace();
                    if (uri == null) {
                        uri = namespaceURI;
                    }
                    if (!(key instanceof EClassifier) || info.getName() == null) continue;
                    HashMap namesToClassifiers2 = (HashMap)this.urisToNamesToClassifiers.get(uri);
                    if (namesToClassifiers2 == null) {
                        namesToClassifiers2 = new HashMap();
                        this.urisToNamesToClassifiers.put(uri, namesToClassifiers2);
                    }
                    namesToClassifiers2.put(info.getName(), key);
                }
            }
            if ((namesToClassifiers = (Map)this.urisToNamesToClassifiers.get(namespaceURI)) != null) {
                return (EClassifier)namesToClassifiers.get(name);
            }
        }
        return null;
    }

    private void getInfoForClassifiers(EPackage ePackage) {
        Iterator i = ePackage.getEClassifiers().iterator();
        while (i.hasNext()) {
            this.getInfo((ENamedElement)i.next());
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name) {
        Iterator i = eClass.getEAllStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)i.next();
            XMLResource.XMLInfo info = this.getInfo((ENamedElement)feature);
            if (info == null) continue;
            String infoURI = info.getTargetNamespace();
            String infoName = info.getName();
            if (!(namespaceURI == null ? infoURI == null && (name.equals(infoName) || infoName == null && name.length() == 0) : namespaceURI.equals(infoURI) && name.equals(infoName))) continue;
            return feature;
        }
        return null;
    }

    public List getFeatures(EClass eClass) {
        EList result = (EList)this.eClassToFeatures.get(eClass);
        if (result == null) {
            String featureOrder;
            result = new UniqueEList();
            Iterator i = eClass.getESuperTypes().iterator();
            while (i.hasNext()) {
                result.addAll((Collection)this.getFeatures((EClass)i.next()));
            }
            EList eAttributes = eClass.getEAttributes();
            result.addAll((Collection)eAttributes);
            EList eReferences = eClass.getEReferences();
            result.addAll((Collection)eReferences);
            EAnnotation eAnnotation = eClass.getEAnnotation(XSD2ECORE);
            if (eAnnotation != null && (featureOrder = (String)eAnnotation.getDetails().get((Object)"feature-order")) != null) {
                int size = result.size();
                int index = size - eReferences.size() - eAttributes.size();
                StringTokenizer stringTokenizer = new StringTokenizer(featureOrder);
                while (stringTokenizer.hasMoreTokens()) {
                    String featureName = stringTokenizer.nextToken();
                    int i2 = index;
                    while (i2 < size) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)result.get(i2);
                        if (featureName.equals(eStructuralFeature.getName())) {
                            result.move(index, (Object)eStructuralFeature);
                            break;
                        }
                        ++i2;
                    }
                    ++index;
                }
            }
            this.eClassToFeatures.put(eClass, result);
        }
        return result;
    }
}

