/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.ui.util.OverlayIcon;

public class SwingUtil {
    public static final int NORMAL = 0;
    public static final int RUNNING = 1;
    public static final int COMPLETED = 2;
    public static final int DISABLED = 3;

    public static Container addLabelComponentRows(Container container, GridBagLayout gridBagLayout, JLabel[] jLabelArray, JComponent[] jComponentArray) {
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        int n = 2;
        int n2 = 2;
        int n3 = jLabelArray.length;
        for (int i = 0; i < n3; ++i) {
            if (jLabelArray[i] == null || jComponentArray[i] == null) continue;
            n = i == 0 ? 0 : 2;
            n2 = i == n3 - 1 ? 0 : 2;
            gridBagConstraints.insets = new Insets(n, 2, n2, 2);
            if (jLabelArray[i].getLabelFor() == null) {
                jLabelArray[i].setLabelFor(jComponentArray[i]);
            }
            SwingUtil.adjustMnemonic(jLabelArray[i]);
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
            container.add(jLabelArray[i]);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jComponentArray[i], gridBagConstraints);
            container.add(jComponentArray[i]);
        }
        return container;
    }

    public static void adjustMnemonic(JLabel jLabel) {
        if (jLabel == null || jLabel.getDisplayedMnemonic() > 0) {
            return;
        }
        String string = jLabel.getText();
        int n = string.length();
        int n2 = 0;
        while (n2 >= 0) {
            char c;
            if ((n2 = string.indexOf("&", n2)) >= n - 1 || (c = string.charAt(++n2)) == '&') continue;
            string = string.substring(0, n2 - 1) + string.substring(n2);
            jLabel.setText(string);
            jLabel.setDisplayedMnemonic(c);
            n2 = -1;
        }
    }

    public static void adjustMnemonic(AbstractButton abstractButton) {
        if (abstractButton == null || abstractButton.getMnemonic() > 0) {
            return;
        }
        String string = abstractButton.getText();
        int n = string.length();
        int n2 = 0;
        while (n2 >= 0) {
            char c;
            if ((n2 = string.indexOf("&", n2)) < 0 || n2 >= n - 1 || (c = string.charAt(++n2)) == '&') continue;
            string = string.substring(0, n2 - 1) + string.substring(n2);
            abstractButton.setText(string);
            abstractButton.setMnemonic(c);
            n2 = -1;
        }
    }

    public static void expandTree(JTree jTree, int n, boolean bl) {
        if (jTree == null) {
            return;
        }
        SwingUtil.expandTree(jTree, jTree.getModel().getRoot(), 0, n, bl);
    }

    public static int expandTree(JTree jTree, Object object, int n, int n2, boolean bl) {
        if (jTree == null || jTree.getModel() == null) {
            return -1;
        }
        TreeModel treeModel = jTree.getModel();
        if (object != null && !treeModel.isLeaf(object)) {
            if (bl) {
                jTree.expandRow(n);
            } else {
                jTree.collapseRow(n);
            }
            if (n2 != 0) {
                for (int i = 0; n + 1 < jTree.getRowCount() && i < treeModel.getChildCount(object); ++i) {
                    ++n;
                    Object object2 = treeModel.getChild(object, i);
                    if (object2 == null) break;
                    TreePath treePath = null;
                    while ((treePath = jTree.getPathForRow(n)) != null && treePath.getLastPathComponent() != object2) {
                        ++n;
                    }
                    if (treePath == null) break;
                    n = SwingUtil.expandTree(jTree, object2, n, n2 - 1, bl);
                }
            }
        }
        return n;
    }

    public static Dimension getMaxWidth(Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            return dimension2;
        }
        if (dimension2 == null) {
            return dimension;
        }
        if (dimension.getWidth() > dimension2.getWidth()) {
            return dimension;
        }
        return dimension2;
    }

    public static Dimension resizeDimension(Dimension dimension, double d, double d2) {
        if (dimension == null) {
            return null;
        }
        if (d == 1.0 && d2 == 1.0) {
            return dimension;
        }
        return new Dimension((int)(dimension.getWidth() * d), (int)(dimension.getHeight() * d2));
    }

    public static void setSameSize(JComponent[] jComponentArray) {
        SwingUtil.setSameSize(jComponentArray, 1.0, 1.0);
    }

    public static void setSameSize(JComponent[] jComponentArray, double d) {
        SwingUtil.setSameSize(jComponentArray, d, d);
    }

    public static void setSameSize(JComponent[] jComponentArray, double d, double d2) {
        int n;
        Dimension dimension = null;
        int n2 = jComponentArray.length;
        for (n = 0; n < n2; ++n) {
            dimension = SwingUtil.getMaxWidth(dimension, jComponentArray[n].getMinimumSize());
        }
        dimension = SwingUtil.resizeDimension(dimension, d, d2);
        n2 = jComponentArray.length;
        for (n = 0; n < n2; ++n) {
            jComponentArray[n].setMinimumSize(dimension);
            jComponentArray[n].setPreferredSize(dimension);
            jComponentArray[n].setMaximumSize(dimension);
        }
    }

    public static boolean selectComboItemByValue(JComboBox jComboBox, String string) {
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!((String)jComboBox.getItemAt(i)).equals(BaseString.toString((Object)string))) continue;
            jComboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public static Icon getIcon(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = ClassLoader.getSystemResource("icons/" + string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static Icon getIcon(String string, int n, boolean bl) {
        Object object;
        Object object2 = SwingUtil.getIcon(string);
        if (object2 == null) {
            return null;
        }
        if (!bl) {
            object = null;
            if (object2 instanceof ImageIcon) {
                object = ((ImageIcon)object2).getImage();
            }
            if (object != null) {
                object2 = new ImageIcon(GrayFilter.createDisabledImage((Image)object));
            }
        }
        if (n != 0) {
            object = new OverlayIcon((Icon)object2);
            switch (n) {
                case 1: {
                    ((OverlayIcon)object).setRightTopIcon(SwingUtil.getIcon("run_ovr.gif"));
                    break;
                }
                case 2: {
                    ((OverlayIcon)object).setRightTopIcon(SwingUtil.getIcon("complete_ovr.gif"));
                }
            }
            object2 = object;
        }
        return object2;
    }
}

