/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jmxagent.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.ObjectName;
import org.eclipse.hyades.perfmon.jmxagent.parser.Parser;
import org.eclipse.hyades.perfmon.jmxagent.parser.ParserException;
import org.eclipse.hyades.perfmon.jmxagent.resource.JmxElement;
import org.eclipse.hyades.perfmon.jmxagent.resource.ResourceManager;
import org.eclipse.hyades.perfmon.jmxagent.resource.SetComparator;
import org.w3c.dom.Element;

public class Filter {
    Parser currentParser;
    ResourceManager manager;

    public Filter(Parser parser, ResourceManager resourceManager) {
        this.currentParser = parser;
        this.manager = resourceManager;
    }

    private String getDomain(String string) {
        return string.substring(0, string.indexOf(":"));
    }

    private String getProperties(String string) {
        String string2;
        int n;
        if (string.endsWith("*")) {
            string = string.substring(0, string.indexOf("*"));
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.indexOf(","));
        }
        if ((n = (string2 = string.substring(string.indexOf(":") + 1)).indexOf("*,")) != -1) {
            string2 = n + 2 < string2.length() ? string2.substring(0, n) + string2.substring(n + 2) : string2.substring(0, n);
        }
        return string2;
    }

    private String formatString(String string, String string2, String string3) {
        String string4 = string2;
        string4 = string4.replaceAll("\\\\V", string3);
        string4 = string4.replaceAll("\\\\N", string);
        return string4;
    }

    public String getName(Element element) {
        if (element.hasAttribute("name")) {
            return element.getAttribute("name");
        }
        return "DEFAULT_NAME";
    }

    public String getType(Element element) {
        if (element.hasAttribute("type")) {
            return element.getAttribute("type");
        }
        return "filter";
    }

    public String getValue(Element element) {
        if (element.hasAttribute("value")) {
            return element.getAttribute("value");
        }
        return "*";
    }

    public String getDisplayName(Element element) {
        if (element.hasAttribute("displayname")) {
            return element.getAttribute("displayname");
        }
        return "\\V";
    }

    public String getDescription(Element element) {
        if (element.hasAttribute("description")) {
            return element.getAttribute("description");
        }
        return "\\N";
    }

    public String getDisplayExpression(Element element) {
        if (element.hasAttribute("displayRegex")) {
            return element.getAttribute("displayRegex");
        }
        return null;
    }

    public boolean getMatching(Element element, String string) {
        if (element.hasAttribute("strictmatching")) {
            return new Boolean(element.getAttribute("strictmatching"));
        }
        return !string.equals("expressionfilter");
    }

    public boolean getNegate(Element element) {
        if (element.hasAttribute("negate")) {
            return new Boolean(element.getAttribute("negate"));
        }
        return false;
    }

    private boolean hasChildren(Set set, String string, String string2, boolean bl) {
        if (string2 == null) {
            return true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            boolean bl2 = bl ^ objectName.getCanonicalName().matches(string2);
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public Set filterNewNodes(Set set, ArrayList arrayList, String string, ObjectName objectName, String string2) throws Exception {
        TreeSet<JmxElement> treeSet = new TreeSet<JmxElement>(new SetComparator());
        TreeSet<ObjectName> treeSet2 = new TreeSet<ObjectName>(new SetComparator());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList arrayList4 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            block16: {
                ObjectName objectName2;
                JmxElement jmxElement;
                String string3;
                StringBuffer stringBuffer;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                Element element;
                block17: {
                    block18: {
                        block15: {
                            element = (Element)arrayList.get(n);
                            string8 = this.getName(element);
                            string7 = this.getType(element);
                            string6 = this.getValue(element);
                            string5 = this.getDisplayName(element);
                            string4 = this.getDescription(element);
                            if (!string7.equals("static")) break block15;
                            stringBuffer = new StringBuffer(this.getDomain(string)).append(":");
                            string3 = this.getProperties(string);
                            if (string3.equals("")) {
                                stringBuffer.append("*");
                            } else {
                                stringBuffer.append(string3).append(",*");
                            }
                            if (this.hasChildren(set, string8, this.getDisplayExpression(element), this.getNegate(element))) {
                                jmxElement = new JmxElement(1, stringBuffer.toString(), string2, objectName, string5, string4, element);
                                treeSet.add(jmxElement);
                            }
                            break block16;
                        }
                        if (string6.equals("*") || string7.equals("expressionfilter")) break block17;
                        if (!string7.equals("filter")) break block18;
                        stringBuffer = new StringBuffer("");
                        if (string.charAt(string.length() - 1) != ':') {
                            stringBuffer.append(string).append(",");
                        }
                        stringBuffer = stringBuffer.append(string8).append("=").append(string6).append(",*");
                        objectName2 = this.manager.createObjectName(stringBuffer.toString());
                        jmxElement = new JmxElement(1, objectName, string2, objectName2, this.formatString(string8, string5, string6), this.formatString(string8, string4, string6), element);
                        treeSet.add(jmxElement);
                        break block16;
                    }
                    if (!string7.equals("domainfilter")) break block16;
                    arrayList3.add(string6);
                    stringBuffer = new StringBuffer(string);
                    string3 = this.getProperties(stringBuffer + ",*");
                    if (string3.equals("")) {
                        stringBuffer.append(string6).append(":*");
                    } else {
                        stringBuffer.append(string6).append(":").append(string3).append(",*");
                    }
                    objectName2 = this.manager.createObjectName(stringBuffer.toString());
                    jmxElement = new JmxElement(1, stringBuffer.toString(), string2, objectName2, this.formatString(string8, string5, string6), this.formatString(string8, string4, string6), element);
                    treeSet.add(jmxElement);
                    break block16;
                }
                Iterator iterator = set.iterator();
                boolean bl = this.getMatching(element, string7);
                while (iterator.hasNext()) {
                    String string9;
                    ObjectName objectName3 = (ObjectName)iterator.next();
                    if (string7.equals("expressionfilter")) {
                        boolean bl2 = this.getNegate(element);
                        boolean bl3 = bl2 ^ objectName3.getCanonicalName().matches(string6);
                        if (!bl3 || bl) continue;
                        treeSet2.add(objectName3);
                        continue;
                    }
                    if (string7.equals("filter")) {
                        String string10 = objectName3.getKeyProperty(string8);
                        if (string10 == null) {
                            if (bl) continue;
                            treeSet2.add(objectName3);
                            continue;
                        }
                        if (arrayList2.contains(string10)) continue;
                        arrayList2.add(string10);
                        String string11 = string;
                        if (string11.toString().endsWith("*")) {
                            string11 = string11.substring(0, string11.length() - 2);
                        }
                        if (string11.toString().endsWith(",")) {
                            string11 = string11.substring(0, string11.length() - 2);
                        }
                        if (string11.charAt(string11.length() - 1) != ':') {
                            string11 = string11 + ",";
                        }
                        stringBuffer = new StringBuffer(string11).append(string8).append("=").append(string10).append(",*");
                        objectName2 = this.manager.createObjectName(stringBuffer.toString());
                        jmxElement = new JmxElement(1, stringBuffer.toString(), string2, objectName2, this.formatString(string8, string5, string10), this.formatString(string8, string4, string10), element);
                        treeSet.add(jmxElement);
                        continue;
                    }
                    if (!string7.equals("domainfilter") || (string9 = objectName3.getDomain()) == null || arrayList3.contains(string9)) continue;
                    arrayList3.add(string9);
                    string3 = this.getProperties(string + ",*");
                    stringBuffer = string3.equals("") ? new StringBuffer(string9).append(":*") : new StringBuffer(string9).append(":").append(string3).append(",*");
                    objectName2 = this.manager.createObjectName(stringBuffer.toString());
                    jmxElement = new JmxElement(1, stringBuffer.toString(), string2, objectName2, this.formatString(string8, string5, string9), this.formatString(string8, string4, string9), element);
                    treeSet.add(jmxElement);
                }
            }
            ++n;
        }
        if (treeSet2.size() > 0) {
            this.addObjects(treeSet, treeSet2, objectName, string2, string);
        }
        return treeSet;
    }

    private String simplify(String string, String string2) {
        int n;
        String string3 = this.getDomain(string);
        String string4 = this.getProperties(string);
        String string5 = this.getProperties(string2);
        String[] stringArray = string5.split(",");
        String[] stringArray2 = string4.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            boolean bl = false;
            n = 0;
            while (n < stringArray.length && !bl) {
                if (stringArray2[n2].equals(stringArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                arrayList.add(stringArray2[n2]);
            }
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer(string3 + ":");
        n = 1;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (n == 1) {
                n = 0;
                stringBuffer.append(arrayList.get(n3));
            } else {
                stringBuffer.append(",").append(arrayList.get(n3));
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void addObjects(Set set, Set set2, ObjectName objectName, String string, String string2) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            if (this.currentParser.isVerboseMBeans()) {
                set.add(new JmxElement(2, objectName, string, objectName2, objectName2.getCanonicalName(), "MBean", null));
                continue;
            }
            String string3 = this.simplify(objectName2.getCanonicalName(), string2);
            set.add(new JmxElement(2, objectName, string, objectName2, string3, "MBean", null));
        }
    }

    public Set filter(Set set, ObjectName objectName, String string, String string2, Element element) throws ParserException {
        try {
            ArrayList arrayList = this.currentParser.getChildFilter(string2, element);
            if (arrayList.size() == 0) {
                TreeSet treeSet = new TreeSet(new SetComparator());
                this.addObjects(treeSet, set, objectName, string, string2);
                return treeSet;
            }
            String string3 = this.getDomain(string2);
            String string4 = this.getProperties(string2);
            String string5 = string3 + ":" + string4;
            Set set2 = this.filterNewNodes(set, arrayList, string5, objectName, string);
            return set2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

