/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigUtility {
    private static String resourceLocation = "org.eclipse.hyades.internal.config.generator.SetConfig";
    private static String lineSeparator = System.getProperty("line.separator");
    protected static ResourceBundle resource = null;

    public static String getString(String property) {
        return ConfigUtility.getString(resourceLocation, property);
    }

    public static String getString(String res, String property) {
        try {
            resource = ResourceBundle.getBundle(res);
        }
        catch (MissingResourceException e) {
            Logger.err(e.getMessage());
        }
        if (resource != null) {
            return resource.getString(property);
        }
        return null;
    }

    public static String printElement(Node node) {
        return ConfigUtility.print(node, 0, false);
    }

    public static String print(Node node) {
        return ConfigUtility.print(node, 0, true);
    }

    public static String print(Node node, int numTab, boolean deepPrint) {
        int i;
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(ConfigUtility.tabs(numTab) + "<" + node.getNodeName());
        NamedNodeMap attrs = node.getAttributes();
        NodeList elems = node.getChildNodes();
        if (attrs != null) {
            i = 0;
            while (i < attrs.getLength()) {
                if (attrs.item(i) instanceof Attr) {
                    strbuf.append(" ");
                    strbuf.append(((Attr)attrs.item(i)).getName());
                    strbuf.append("=\"");
                    strbuf.append(((Attr)attrs.item(i)).getValue());
                    strbuf.append("\"");
                }
                ++i;
            }
        }
        if (!deepPrint || elems == null || elems.getLength() == 0) {
            strbuf.append("/>" + lineSeparator);
        } else {
            strbuf.append(">" + lineSeparator);
            i = 0;
            while (i < elems.getLength()) {
                strbuf.append(ConfigUtility.print(elems.item(i), numTab + 1, true));
                ++i;
            }
            strbuf.append(ConfigUtility.tabs(numTab) + "</" + node.getNodeName() + ">" + lineSeparator);
        }
        return strbuf.toString();
    }

    protected static String tabs(int length) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < length) {
            strbuf.append("\t");
            ++i;
        }
        return strbuf.toString();
    }

    public static String removeTrailings(String in) {
        String out = null;
        if (in != null) {
            out = in.trim();
            while (out.endsWith(PlatformObject.sr)) {
                out = out.substring(0, out.length() - 1);
            }
        }
        return out;
    }

    public static String arrayToString(String[] array) {
        StringBuffer str = null;
        if (array != null) {
            str = new StringBuffer();
            int i = 0;
            while (i < array.length) {
                str.append(array[i]);
                if (i < array.length - 1) {
                    str.append(',');
                }
                ++i;
            }
        }
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    public static String[] stringToArray(String str) {
        String[] array = null;
        if (str != null) {
            StringTokenizer strtok = new StringTokenizer(str, " ,");
            array = new String[strtok.countTokens()];
            int i = 0;
            while (strtok.hasMoreTokens()) {
                array[i++] = strtok.nextToken();
            }
        }
        return array;
    }

    public static String getJvmLib(String javaPath) throws IOException {
        String sr = PlatformObject.sr;
        String jvm = PlatformObject.jvmLib;
        File f = null;
        String path = new String(javaPath + sr + "classic" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "classic" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + "server" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "server" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + "client" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "client" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
        f = new File(path);
        if (f != null && f.exists()) {
            return f.getCanonicalPath();
        }
        if (PlatformObject.name.equals("HP-UX")) {
            path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
        } else if (PlatformObject.name.equals("SunOS")) {
            path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
            path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
            f = new File(path);
            if (f != null && f.exists()) {
                return f.getCanonicalPath();
            }
        }
        return null;
    }
}

