/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AgentQueryStateCommand;
import org.eclipse.hyades.internal.execution.local.common.AttachToAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DetachFromAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisterAgentInterestCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringRemoteAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StopMonitorCommand;
import org.eclipse.hyades.internal.execution.local.common.TCPDataServer;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;

public class AgentImpl
implements Agent,
ProcessListener,
ConnectionListener {
    protected String _name = null;
    protected String _type = null;
    protected String _uuid = null;
    protected Process _process = null;
    protected AgentConfiguration _config;
    protected boolean _autoAttach = false;
    protected boolean _isMonitored = false;
    protected boolean _isActive = false;
    protected boolean _isAttached = false;
    protected TCPDataServer _server = null;
    protected String _profileFile = null;
    protected Vector _listeners = new Vector(10);
    private Object _lock = new Object();

    public AgentImpl(Process process, String name) {
        this(process, name, null);
    }

    public AgentImpl(Process process, String name, String type) {
        this(process, name, type, false);
    }

    public AgentImpl(Process process, String name, String type, boolean active) {
        this._process = process;
        this._name = name;
        this._type = type;
        this._isActive = active;
        process.addProcessListener(this);
        try {
            process.getNode().getConnection().addConnectionListener(this);
        }
        catch (InactiveProcessException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentListener(AgentListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentListener(AgentListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    public Process getProcess() {
        return this._process;
    }

    public void setAutoAttach(boolean auto) {
        this._autoAttach = auto;
        Process proc = this.getProcess();
        if (proc != null && proc.isActive()) {
            ControlMessage message = new ControlMessage();
            RegisterAgentInterestCommand command = new RegisterAgentInterestCommand();
            command.setAgentName(this._name);
            try {
                command.setProcessId(new Long(proc.getProcessId()));
                message.appendCommand(command);
                proc.getNode().getConnection().sendMessage(message, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement element) {
                        AgentImpl.this.handleCommand(element);
                    }
                });
            }
            catch (InactiveProcessException e) {
                return;
            }
            catch (IOException e) {
            }
        }
    }

    public boolean isAutoAttach() {
        return this._autoAttach;
    }

    public void attach() throws InactiveAgentException, InactiveProcessException {
        this._isAttached = true;
        ControlMessage message = new ControlMessage();
        AttachToAgentCommand command = new AttachToAgentCommand();
        command.setAgentName(this._name);
        command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        message.appendCommand(command);
        try {
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement command) {
                    AgentImpl.this.handleCommand(command);
                }
            });
        }
        catch (IOException e) {}
    }

    public void detach() throws InactiveAgentException, InactiveProcessException {
        this._isAttached = false;
        this.stopMonitoring();
        this._server = null;
        ControlMessage message = new ControlMessage();
        DetachFromAgentCommand command = new DetachFromAgentCommand();
        command.setAgentName(this._name);
        command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        message.appendCommand(command);
        try {
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement command) {
                    AgentImpl.this.handleCommand(command);
                }
            });
        }
        catch (IOException e) {}
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        return this._uuid;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isMonitored() {
        return this._isMonitored;
    }

    public boolean isAttached() {
        return this.isAttached(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(boolean remote) {
        if (!remote) {
            return this._isAttached;
        }
        ControlMessage message = new ControlMessage();
        AgentQueryStateCommand command = new AgentQueryStateCommand();
        Object object = this._lock;
        synchronized (object) {
            try {
                command.setAgentName(this._name);
                command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
                message.appendCommand(command);
                this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        switch ((int)command.getTag()) {
                            case 44: {
                                AgentImpl.this._isAttached = true;
                                Object object = AgentImpl.this._lock;
                                synchronized (object) {
                                    AgentImpl.this._lock.notify();
                                    break;
                                }
                            }
                            case 45: {
                                AgentImpl.this._isAttached = false;
                                Object object = AgentImpl.this._lock;
                                synchronized (object) {
                                    AgentImpl.this._lock.notify();
                                    break;
                                }
                            }
                        }
                    }
                });
                this._lock.wait(5000L);
            }
            catch (InactiveProcessException e1) {
            }
            catch (IOException e2) {
            }
            catch (InterruptedException e3) {
                // empty catch block
            }
        }
        return this._isAttached;
    }

    public void startMonitoring(DataProcessor processor) throws InactiveAgentException {
        if (!this._isAttached) {
            return;
        }
        if (this._server == null) {
            this._server = new TCPDataServer();
            try {
                this._server.startServer(processor);
            }
            catch (Exception e) {}
        } else {
            this._server.resumeServer(processor);
        }
        ControlMessage message = new ControlMessage();
        StartMonitoringRemoteAgentCommand command = new StartMonitoringRemoteAgentCommand();
        command.setAgentName(this._name);
        command.setPort((short)this._server.getPort());
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            message.appendCommand(command);
            this._process.getNode().getConnection().sendMessage(message, null);
        }
        catch (InactiveProcessException e) {
            throw new InactiveAgentException();
        }
        catch (IOException e) {
            // empty catch block
        }
        this._isMonitored = true;
    }

    public void stopMonitoring() throws InactiveAgentException {
        if (this._server != null) {
            this._server.stopServer();
        }
        if (!this._isMonitored) {
            return;
        }
        ControlMessage message = new ControlMessage();
        StopMonitorCommand command = new StopMonitorCommand();
        command.setAgentName(this._name);
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            message.appendCommand(command);
            this._process.getNode().getConnection().sendMessage(message, null);
        }
        catch (InactiveProcessException e) {
            throw new InactiveAgentException();
        }
        catch (IOException e) {
            // empty catch block
        }
        this._isMonitored = false;
    }

    public void setConfiguration(AgentConfiguration config) {
        this._config = config;
    }

    public AgentConfiguration getConfiguration() {
        if (this._config == null) {
            this._config = new AgentConfiguration();
        }
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishConfiguration() throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        if (this._config == null) {
            return;
        }
        int entryCount = 0;
        ControlMessage message = new ControlMessage();
        AgentConfiguration agentConfiguration = this._config;
        synchronized (agentConfiguration) {
            int i = 0;
            while (i < this._config.size()) {
                AgentConfigurationEntry entry = this._config.getEntryAt(i);
                if (entry != null && entry.isEnabled()) {
                    ++entryCount;
                    SetNVPairCommand command = new SetNVPairCommand();
                    try {
                        command.setProcessId(Long.parseLong(this._process.getProcessId()));
                    }
                    catch (InactiveProcessException e) {
                        throw new InactiveAgentException();
                    }
                    command.setAgentName(this._name);
                    command.setType(entry.getType());
                    command.setName(entry.getName());
                    command.setValue(entry.getValue());
                    message.appendCommand(command);
                }
                ++i;
            }
        }
        if (entryCount > 0) {
            try {
                this._process.getNode().getConnection().sendMessage(message, null);
            }
            catch (InactiveProcessException e) {
                throw new InactiveAgentException();
            }
            catch (IOException e) {
            }
        }
    }

    public void invokeCustomCommand(CustomCommand command) throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        ControlMessage message = new ControlMessage();
        message.appendCommand(command);
        command.setAgentName(this._name);
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement element) {
                    AgentImpl.this.handleCommand(element);
                }
            });
        }
        catch (InactiveProcessException e) {
            throw new InactiveAgentException();
        }
        catch (IOException e) {
        }
    }

    public void setUUID(String uuid) {
        this._uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(final CommandElement command) {
        switch ((int)command.getTag()) {
            case 35: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this._isActive = true;
                    if (this._autoAttach) {
                        this._isAttached = true;
                    }
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).agentActive(this);
                    }
                    break;
                }
            }
            case 36: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this._isActive = false;
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).agentInactive(this);
                    }
                    break;
                }
            }
            case 37: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).error(this, ((ErrorCommand)command).getErrorId(), ((ErrorCommand)command).getErrorString());
                    }
                    break;
                }
            }
            case 98: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    try {
                        InetAddress address = ((MonitorPeerRequestCommand)command).getPeerNode();
                        if (address != null) {
                            final Node node = NodeFactory.createNode(address.getHostAddress());
                            if (!node.isConnected()) {
                                node.connect(10002);
                            }
                            final AgentImpl agent = this;
                            Runnable delegate = new Runnable(){

                                public void run() {
                                    String peerProcessId = Long.toString(((MonitorPeerRequestCommand)command).getProcessId());
                                    Enumeration processes = null;
                                    try {
                                        processes = node.listProcesses();
                                    }
                                    catch (NotConnectedException e) {
                                        // empty catch block
                                    }
                                    Process proc = null;
                                    while (processes.hasMoreElements()) {
                                        proc = (Process)processes.nextElement();
                                        try {
                                            if (proc.getProcessId().equals(peerProcessId)) break;
                                            proc = null;
                                        }
                                        catch (InactiveProcessException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (proc == null) {
                                        return;
                                    }
                                    Agent peer = proc.getAgent(((MonitorPeerRequestCommand)command).getAgentName());
                                    if (peer == null) {
                                        return;
                                    }
                                    Enumeration elements = AgentImpl.this._listeners.elements();
                                    while (elements.hasMoreElements()) {
                                        AgentListener listener = (AgentListener)elements.nextElement();
                                        if (!(listener instanceof AgentPeerListener)) continue;
                                        ((AgentPeerListener)listener).peerWaiting(agent, peer);
                                    }
                                }
                            };
                            Thread newThread = new Thread(delegate, "PeerDelegate");
                            newThread.start();
                        }
                    }
                    catch (UnknownHostException e) {
                    }
                    catch (AgentControllerUnavailableException e) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 41: {
                try {
                    ProcessImpl process = (ProcessImpl)this.getProcess();
                    process.handleCommand(command);
                }
                catch (ClassCastException e) {}
                break;
            }
            default: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).handleCommand(this, command);
                    }
                    break;
                }
            }
        }
    }

    public void processLaunched(Process process) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExited(Process process) {
        if (this._server != null) {
            this._server.shutdownServer();
        }
        if (process == this._process && this._isActive) {
            Vector vector = this._listeners;
            synchronized (vector) {
                this._isActive = false;
                Enumeration elements = this._listeners.elements();
                while (elements.hasMoreElements()) {
                    ((AgentListener)elements.nextElement()).agentInactive(this);
                }
            }
        }
    }

    public boolean isToProfileFile() {
        return this._profileFile != null && this._profileFile.trim().length() != 0;
    }

    public String getProfileFile() {
        return this._profileFile;
    }

    public void setProfileFile(String _profileFile) {
        this._profileFile = _profileFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Vector vector = this._listeners;
        synchronized (vector) {
            this._isActive = false;
            Enumeration elements = this._listeners.elements();
            while (elements.hasMoreElements()) {
                ((AgentListener)elements.nextElement()).agentInactive(this);
            }
        }
    }
}

