/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.remote;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.eclipse.hyades.internal.execution.recorder.remote.IRecorderMessageTypes;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderCommandHandler;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderHandleCommandException;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class RecorderAgentController
implements IRecorderMessageTypes {
    private boolean okToStart = false;
    private RemoteComponentSkeleton skeleton = null;
    private RecorderAgent recordHarnessAgent = null;
    private static String agentClassPath;
    private Process process = null;
    private Thread recorderThread;

    public static void main(String[] stringArray) {
        agentClassPath = stringArray[0];
        RecorderAgentController recorderAgentController = new RecorderAgentController();
        recorderAgentController.setupCommandHandler();
        recorderAgentController.waitForInitialization();
    }

    private void waitForInitialization() {
        while (!this.okToStart) {
            this.delay(100);
        }
        while (this.recordHarnessAgent == null) {
            this.delay(100);
        }
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void setupCommandHandler() {
        this.skeleton = new RemoteComponentSkeleton("racRunner", "tester");
        this.skeleton.addCommandListener((CustomCommandHandler)new RecorderCommandHandler(this));
        try {
            this.skeleton.initialize();
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            agentControllerUnavailableException.printStackTrace();
        }
    }

    public void setOKToStart(boolean bl) {
        this.okToStart = bl;
    }

    public synchronized void sendByteDataToDataProcessor(byte[] byArray, int n, int n2) {
        this.sendByteDataToDataProcessor(byArray, n, n2, 1);
    }

    public synchronized void sendDebugMessageToDataProcessor(String string) {
        this.sendByteDataToDataProcessor(string.getBytes(), 0, string.getBytes().length, 2);
    }

    public synchronized void sendControlMessageToDataProcessor(String string) {
        this.sendByteDataToDataProcessor(string.getBytes(), 0, string.getBytes().length, 3);
    }

    public synchronized void sendCompleteNotification() {
        String string = "finished";
        this.sendByteDataToDataProcessor(string.getBytes(), 0, string.getBytes().length, 4);
    }

    protected synchronized void sendByteDataToDataProcessor(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = this.createByteBuf(byArray, n, n2, n3);
        this.skeleton.logMessage(byArray2, 0, byArray2.length);
    }

    private byte[] createByteBuf(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n2 + 1];
        byArray2[0] = new Integer(n3).byteValue();
        int n4 = 1;
        while (n4 <= n2) {
            byArray2[n4] = byArray[n4 + n - 1];
            ++n4;
        }
        return byArray2;
    }

    public void reportException(String string, Throwable throwable) {
        this.sendDebugMessageToDataProcessor("\n\n*****************************Exception Stack********************************\n" + string);
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable != null) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            stringBuffer.append(charArrayWriter.toString() + "\n");
        }
        this.sendDebugMessageToDataProcessor(stringBuffer.toString());
        this.sendDebugMessageToDataProcessor("****************************************************************************\n\n");
    }

    public void initAgent(String string) {
        this.sendDebugMessageToDataProcessor("about to load recorder agent: " + agentClassPath);
        try {
            this.recordHarnessAgent = (RecorderAgent)Class.forName(agentClassPath).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.reportException("unable to load recorder agent: " + agentClassPath, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.reportException("unable to load recorder agent: " + agentClassPath, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.reportException("unable to load recorder agent: " + agentClassPath, classNotFoundException);
        }
        this.sendDebugMessageToDataProcessor("load successful");
        this.sendDebugMessageToDataProcessor("about to initialize recorder agent: " + agentClassPath);
        this.recordHarnessAgent.setController(this);
        if (this.recordHarnessAgent.init(string)) {
            this.sendDebugMessageToDataProcessor("initialization successful");
        } else {
            this.sendDebugMessageToDataProcessor("initialization failed");
        }
    }

    public void startRecording() {
        RecorderThread recorderThread = new RecorderThread(this.recordHarnessAgent);
        recorderThread.start();
        this.recorderThread = recorderThread.getWorkerThread();
        while (!this.recordHarnessAgent.isReady()) {
            this.delay(100);
        }
    }

    public void stopRecording() {
        try {
            this.recordHarnessAgent.handleCommand(1, null);
        }
        catch (RecorderHandleCommandException recorderHandleCommandException) {
            this.reportException("unable to stop recording", recorderHandleCommandException);
        }
        this.sendCompleteNotification();
    }

    protected class RecorderDeathWatch
    extends Thread {
        private Process process;
        private Thread thread;
        private RecorderAgent agent;

        public RecorderDeathWatch(Process process, Thread thread, RecorderAgent recorderAgent) {
            this.process = process;
            this.thread = thread;
            this.agent = recorderAgent;
            String string = "Recorder Death Watch";
            RecorderAgentController.this.sendDebugMessageToDataProcessor("recorder death watch started started with name: " + string);
            this.setName(string);
        }

        public void run() {
            try {
                this.thread.join();
                RecorderAgentController.this.stopRecording();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public class RecorderThread
    extends Thread {
        private RecorderAgent runnable = null;
        private Thread workerThread = null;

        public RecorderThread(RecorderAgent recorderAgent) {
            this.runnable = recorderAgent;
            this.setName("Recorder Thread");
        }

        public void run() {
            this.workerThread = this.runnable.run();
        }

        public Thread getWorkerThread() {
            return this.workerThread;
        }
    }
}

