/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.MessageDialog;
import org.eclipse.hyades.test.manual.runner.ui.panel.EmptyPanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.LoopPanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.NamedElementPanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.TestCasePanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.TestInvocationExecutionPanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.TestInvocationPanel;
import org.eclipse.hyades.test.manual.runner.ui.panel.TestSuitePanel;
import org.eclipse.hyades.test.manual.runner.ui.tree.TestSuiteTreePanel;
import org.eclipse.hyades.test.manual.runner.ui.util.BaseCardLayout;
import org.eclipse.hyades.test.manual.runner.ui.util.EditorItem;
import org.eclipse.hyades.test.manual.runner.ui.util.IRefreshable;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

public class RemoteAppFrame
extends JFrame
implements TreeSelectionListener {
    private static final Dimension FRAME_SIZE = new Dimension(750, 500);
    private JSplitPane mainSplitPane;
    private JSplitPane detailSplitPane;
    private TestSuiteTreePanel treePanel;
    private JPanel attributePanel;
    private JPanel executionPanel;
    private JMenuItem nodeExpandAllMenuItem;
    private JMenuItem nodeCollapseAllMenuItem;
    private int detailSplitPosition = -1;

    public RemoteAppFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle(RemoteAppResourceBundle.getString("frame.title"));
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add(this.createControls());
        ((Component)this).setSize(FRAME_SIZE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                RemoteAppFrame.this.doOpen();
            }

            public void windowClosing(WindowEvent windowEvent) {
                RemoteAppFrame.this.doClose(true);
            }
        });
        System.out.println(RemoteAppResourceBundle.getString("event.frame.Available"));
    }

    public void dispose() {
        this.treePanel.dispose();
        super.dispose();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenuBar());
        jMenuBar.add(this.createViewMenuBar());
        jMenuBar.add(this.createTestcaseMenuBar());
        return jMenuBar;
    }

    private JMenu createFileMenuBar() {
        JMenu jMenu = new JMenu(RemoteAppResourceBundle.getString("menu.File"));
        SwingUtil.adjustMnemonic(jMenu);
        final JMenuItem jMenuItem = new JMenuItem(RemoteAppResourceBundle.getString("menu.File.Exit"));
        SwingUtil.adjustMnemonic(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.doClose(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                if (ModelUtil.DEFAULT_EXECUTION_MANAGER.hasNext()) {
                    jMenuItem.setText(RemoteAppResourceBundle.getString("action.InterruptExecution"));
                } else {
                    jMenuItem.setText(RemoteAppResourceBundle.getString("action.StopExecution"));
                }
                jMenuItem.setMnemonic(0);
                SwingUtil.adjustMnemonic(jMenuItem);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JMenu createViewMenuBar() {
        JMenu jMenu = new JMenu(RemoteAppResourceBundle.getString("menu.View"));
        SwingUtil.adjustMnemonic(jMenu);
        JMenuItem jMenuItem = new JMenuItem(RemoteAppResourceBundle.getString("menu.View.SelectTaskToExecute"));
        SwingUtil.adjustMnemonic(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.selectNextTaskToExecute();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(RemoteAppResourceBundle.getString("menu.View.ExpandAll"));
        SwingUtil.adjustMnemonic(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SwingUtil.expandTree(RemoteAppFrame.this.getTreePanel().getTree(), -1, true);
                    Object var3_2 = null;
                    RemoteAppFrame.this.setCursor(null);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    RemoteAppFrame.this.setCursor(null);
                    throw throwable;
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(RemoteAppResourceBundle.getString("menu.View.CollapseAll"));
        SwingUtil.adjustMnemonic(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SwingUtil.expandTree(RemoteAppFrame.this.getTreePanel().getTree(), -1, false);
                    Object var3_2 = null;
                    RemoteAppFrame.this.setCursor(null);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    RemoteAppFrame.this.setCursor(null);
                    throw throwable;
                }
            }
        });
        this.nodeExpandAllMenuItem = new JMenuItem(RemoteAppResourceBundle.getString("menu.View.NodeExpandAll"));
        SwingUtil.adjustMnemonic(this.nodeExpandAllMenuItem);
        this.nodeExpandAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.expandNode(true);
            }
        });
        this.nodeExpandAllMenuItem.setEnabled(false);
        this.nodeCollapseAllMenuItem = new JMenuItem(RemoteAppResourceBundle.getString("menu.View.NodeCollapseAll"));
        SwingUtil.adjustMnemonic(this.nodeCollapseAllMenuItem);
        this.nodeCollapseAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.expandNode(false);
            }
        });
        this.nodeCollapseAllMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(this.nodeExpandAllMenuItem);
        jMenu.add(this.nodeCollapseAllMenuItem);
        return jMenu;
    }

    private JMenu createTestcaseMenuBar() {
        JMenu jMenu = new JMenu(RemoteAppResourceBundle.getString("menu.Action"));
        SwingUtil.adjustMnemonic(jMenu);
        JMenuItem jMenuItem = new JMenuItem(RemoteAppResourceBundle.getString("menu.Execution.SendMessage") + " ...");
        SwingUtil.adjustMnemonic(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteAppFrame.this.sendMessage();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private Component createControls() {
        this.treePanel = new TestSuiteTreePanel();
        this.getTreePanel().getTree().addTreeSelectionListener(this);
        this.attributePanel = new JPanel(new BaseCardLayout());
        this.attributePanel.add((Component)new EmptyPanel(), this.getClass().getName());
        this.executionPanel = new JPanel(new BaseCardLayout());
        this.executionPanel.add((Component)new EmptyPanel(), this.getClass().getName());
        this.detailSplitPane = new JSplitPane(0, this.attributePanel, this.executionPanel);
        this.detailSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane = new JSplitPane(1, this.getTreePanel(), this.detailSplitPane);
        this.mainSplitPane.setOneTouchExpandable(true);
        return this.mainSplitPane;
    }

    protected TestSuiteTreePanel getTreePanel() {
        return this.treePanel;
    }

    protected void doOpen() {
        this.mainSplitPane.setDividerLocation(0.37);
        this.mainSplitPane.setDividerSize(7);
        this.detailSplitPane.setDividerLocation(0.65);
        this.detailSplitPane.setDividerSize(7);
        this.detailSplitPosition = this.detailSplitPane.getDividerLocation();
        ModelUtil.getEventLogger().logTyped(ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot(), 0, null);
        this.selectNextTaskToExecute();
    }

    public void doClose(boolean bl) {
        VerdictEvent verdictEvent = null;
        String string = null;
        if (ModelUtil.DEFAULT_EXECUTION_MANAGER.hasNext()) {
            verdictEvent = new VerdictEvent();
            verdictEvent.setOwnerId(ModelUtil.getHierarchyId(ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot()));
            string = RemoteAppResourceBundle.getString("msgbox.close.InterruptText");
            verdictEvent.setVerdict(2);
            verdictEvent.setText(RemoteAppResourceBundle.getString("interruptText"));
            verdictEvent.setReason(2);
        } else {
            verdictEvent = ModelUtil.DEFAULT_ARBITER.analyse();
            string = RemoteAppResourceBundle.getString("msgbox.close.StopText");
        }
        if ((ModelUtil.DEFAULT_EXECUTION_MANAGER.hasNext() || bl) && 0 != JOptionPane.showConfirmDialog(this, string, RemoteAppResourceBundle.getString("word.Question"), 0)) {
            return;
        }
        ModelUtil.DEFAULT_EXECUTION_MANAGER.closeStatedLoops();
        ModelUtil.closeExecutedTests();
        ModelUtil.getEventLogger().log((ExecutionEvent)verdictEvent);
        System.out.println(RemoteAppResourceBundle.getString("event.application.Closed"));
        ModelUtil.getEventLogger().logTyped(ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot(), 1, null);
        try {
            ModelUtil.DEFAULT_EXECUTION_MANAGER.dispose();
            ModelUtil.clearVerdicts();
            ModelUtil.setEventLogger(null);
            TestInvocation.removeListeners();
            this.dispose();
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void sendMessage() {
        Object object = this.getTreePanel().getTree().getLastSelectedPathComponent();
        if (object instanceof NamedElement) {
            MessageDialog.show(this, (NamedElement)object);
        }
    }

    protected void selectNextTaskToExecute() {
        this.getTreePanel().select(ModelUtil.DEFAULT_EXECUTION_MANAGER.next());
    }

    protected void expandNode(boolean bl) {
        if (this.getTreePanel().getTree().getSelectionCount() == 0) {
            return;
        }
        Object object = this.getTreePanel().getTree().getLastSelectedPathComponent();
        int n = this.getTreePanel().getTree().getSelectionRows()[0];
        if (object != null && (object instanceof TestSuite || object instanceof Loop)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SwingUtil.expandTree(this.getTreePanel().getTree(), object, n, -1, bl);
                Object var5_4 = null;
                this.setCursor(null);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setCursor(null);
                throw throwable;
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.getTreePanel().getTree().getLastSelectedPathComponent();
        this.adjustAttributePanel(object);
        this.adjustExecutionPanel(object);
        boolean bl = object != null && (object instanceof TestSuite || object instanceof Loop);
        this.nodeExpandAllMenuItem.setEnabled(bl);
        this.nodeCollapseAllMenuItem.setEnabled(bl);
    }

    private void adjustAttributePanel(Object object) {
        BaseCardLayout baseCardLayout;
        IRefreshable iRefreshable;
        if (object == null) {
            object = this;
        }
        if ((iRefreshable = (IRefreshable)((Object)(baseCardLayout = (BaseCardLayout)this.attributePanel.getLayout()).showAndTell(this.attributePanel, object.getClass().getName()))) == null) {
            iRefreshable = this.createAttributePanel(object);
            if (iRefreshable == null) {
                object = this;
            }
            iRefreshable = (IRefreshable)((Object)baseCardLayout.showAndTell(this.attributePanel, object.getClass().getName()));
        }
        iRefreshable.refreshContent(new EditorItem(object, false));
    }

    private IRefreshable createAttributePanel(Object object) {
        NamedElementPanel namedElementPanel = null;
        if (object instanceof TestSuite) {
            namedElementPanel = new TestSuitePanel(this);
        } else if (object instanceof Loop) {
            namedElementPanel = new LoopPanel();
        } else if (object instanceof TestCase) {
            namedElementPanel = new TestCasePanel();
        } else if (object instanceof TestInvocation) {
            namedElementPanel = new TestInvocationPanel();
        }
        if (namedElementPanel != null) {
            this.attributePanel.add((Component)namedElementPanel, object.getClass().getName());
        }
        return namedElementPanel;
    }

    private void adjustExecutionPanel(Object object) {
        BaseCardLayout baseCardLayout;
        IRefreshable iRefreshable;
        if (object == null) {
            object = this;
        }
        if ((iRefreshable = (IRefreshable)((Object)(baseCardLayout = (BaseCardLayout)this.executionPanel.getLayout()).showAndTell(this.executionPanel, object.getClass().getName()))) == null) {
            iRefreshable = this.createExecutionPanel(object);
            if (iRefreshable == null) {
                object = this;
            }
            iRefreshable = (IRefreshable)((Object)baseCardLayout.showAndTell(this.executionPanel, object.getClass().getName()));
        }
        this.adjustFocus(object);
        iRefreshable.refreshContent(new EditorItem(object, true));
        this.adjustDetailDividerPosition(object);
    }

    private void adjustFocus(Object object) {
        TestInvocation testInvocation;
        if (object instanceof TestInvocation && (testInvocation = (TestInvocation)object).getExecutionCount() == 0) {
            this.getTreePanel().getTree().transferFocus();
            this.executionPanel.requestFocus();
        }
    }

    private void adjustDetailDividerPosition(Object object) {
        if (object == this) {
            if (this.detailSplitPane.getRightComponent().isVisible()) {
                this.detailSplitPosition = this.detailSplitPane.getDividerLocation();
                this.detailSplitPane.getRightComponent().setVisible(false);
            }
        } else if (!this.detailSplitPane.getRightComponent().isVisible()) {
            this.detailSplitPane.getRightComponent().setVisible(true);
            if (this.detailSplitPosition >= 0) {
                this.detailSplitPane.setDividerLocation(this.detailSplitPosition);
            }
        }
    }

    private IRefreshable createExecutionPanel(Object object) {
        TestInvocationExecutionPanel testInvocationExecutionPanel = null;
        if (object instanceof TestInvocation) {
            testInvocationExecutionPanel = new TestInvocationExecutionPanel();
        }
        if (testInvocationExecutionPanel != null) {
            this.executionPanel.add((Component)testInvocationExecutionPanel, object.getClass().getName());
        }
        return testInvocationExecutionPanel;
    }
}

