/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.test.http.runner.HttpHeader;

public abstract class HttpElement {
    private String id = Integer.toString(this.hashCode());
    private String version;
    private Map headersByName;
    private String body;

    public void addHeader(HttpHeader httpHeader) {
        if (HttpHeader.isValid(httpHeader)) {
            if (this.headersByName == null) {
                this.headersByName = new HashMap();
            }
            this.headersByName.put(httpHeader.getName(), httpHeader);
            httpHeader.setElement(this);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public HttpHeader[] getHeaders() {
        if (this.headersByName == null) {
            return new HttpHeader[0];
        }
        return this.headersByName.values().toArray(new HttpHeader[this.headersByName.values().size()]);
    }

    public HttpHeader getHeader(String string) {
        return (HttpHeader)this.headersByName.get(string);
    }

    public String getHeaderValue(String string) {
        HttpHeader httpHeader = this.getHeader(string);
        if (httpHeader == null) {
            return null;
        }
        return httpHeader.getValue();
    }

    public int getHeaderIntValue(String string) {
        HttpHeader httpHeader = this.getHeader(string);
        if (httpHeader != null) {
            try {
                return Integer.parseInt(httpHeader.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }
}

