/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.execution.recorder.http.remote.SSLCheckClass;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class ClientSideReader
extends Thread {
    public static final String ERROR_SSL_REQUEST_MADE = "-1";
    public static final String ERROR_NO_TESTKEYS = "-2";
    static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
    static int iConn = 0;
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
    InputStream from_client;
    OutputStream to_client;
    InputStream from_server;
    OutputStream to_server;
    PeekSocket client = null;
    Socket httpServer = null;
    ServerSideReader serverReader = null;
    boolean bSecure = false;
    boolean bNoPrintToServer = false;
    PacketWriter packetWriter = null;
    String destServer = null;
    int serverPort = 80;
    int iConnection = 0;
    static int isSSLClassAvailable = -1;
    static boolean foundTestKeys = false;

    ClientSideReader(PeekSocket peekSocket, PacketWriter packetWriter) {
        try {
            this.from_client = peekSocket.getInputStream();
            this.to_client = peekSocket.getOutputStream();
            this.client = peekSocket;
            this.iConnection = ClientSideReader.getNextConnection();
            this.packetWriter = packetWriter;
            packetWriter.writeRecorderMessage(1, "Client Connected, connection " + this.iConnection);
        }
        catch (Exception exception) {
            packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
        }
    }

    static synchronized int getNextConnection() {
        return ++iConn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        boolean bl = false;
        String string = null;
        if (isSSLClassAvailable == -1 && (isSSLClassAvailable = this.findSSLClass()) == 1) {
            foundTestKeys = this.checkForTestKeys();
        }
        try {
            byte[] byArray = new byte[this.client.getReceiveBufferSize()];
            bl = this.processSocksRequest();
            if (bl) {
                this.bSecure = this.checkSSLByte();
                if (this.bSecure) {
                    if (isSSLClassAvailable != 1) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
                        return;
                    }
                    if (!foundTestKeys) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
                        return;
                    }
                    SSLCheckClass sSLCheckClass = new SSLCheckClass(this);
                    sSLCheckClass.checkForSecureConnectionRequest();
                } else {
                    string = this.checkForRegularConnectionRequest();
                }
                while ((n = this.from_client.read(byArray)) != -1) {
                    Thread.sleep(1L);
                    this.bNoPrintToServer = false;
                    boolean bl2 = false;
                    String string2 = new String(byArray, 0, n);
                    if (this.bSecure) {
                        this.packetWriter.writePacket(this.bSecure, true, this.iConnection, byArray, n);
                        if (!this.bNoPrintToServer) {
                            this.to_server.write(byArray, 0, n);
                            this.to_server.flush();
                        }
                    }
                    if (this.bSecure) continue;
                    this.packetWriter.writePacket(this.bSecure, true, this.iConnection, string2.getBytes(), string2.getBytes().length);
                    if (this.bNoPrintToServer || string2.getBytes().length <= 0) continue;
                    this.to_server.write(string2.getBytes(), 0, string2.getBytes().length);
                    this.to_server.flush();
                }
            }
            this.packetWriter.writeCloseConnectionInfo(this.iConnection);
            if (this.httpServer == null) return;
            this.httpServer.close();
            return;
        }
        catch (Exception exception) {
            this.packetWriter.writeCloseConnectionInfo(this.iConnection);
            try {
                if (this.httpServer == null) return;
                this.httpServer.close();
                return;
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + ": " + iOException);
            }
        }
    }

    private boolean processSocksRequest() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        byte[] byArray = new byte[4];
        boolean bl2 = false;
        InetAddress inetAddress = null;
        try {
            byte[] byArray2 = new byte[this.client.getReceiveBufferSize()];
            n = this.from_client.read(byArray2);
            if (n < 8) {
                bl = false;
            } else {
                int n5 = 0;
                n5 = 0;
                while (n5 < 8) {
                    Byte by = new Byte(byArray2[n5]);
                    switch (n5) {
                        case 0: {
                            n3 = by.intValue();
                            break;
                        }
                        case 1: {
                            n4 = by.intValue();
                            break;
                        }
                        case 2: {
                            int n6 = 0;
                            n6 = by.intValue();
                            if (n6 < 0) {
                                n6 += 256;
                            }
                            n2 = n6 * 256;
                            break;
                        }
                        case 3: {
                            int n7 = 0;
                            n7 = by.intValue();
                            if (n7 < 0) {
                                n7 += 256;
                            }
                            n2 += n7;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            byArray[n5 - 4] = byArray2[n5];
                        }
                    }
                    ++n5;
                }
                string = ClientSideReader.IP4ByteToString(byArray);
                inetAddress = InetAddress.getByName(string);
                this.destServer = inetAddress.getHostName();
                this.serverPort = n2;
                this.httpServer = new Socket(inetAddress, n2);
                if (this.httpServer != null) {
                    this.respondToClient(true);
                    bl = true;
                } else {
                    bl = false;
                    this.respondToClient(false);
                    this.packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + this.destServer + " Port: " + this.serverPort);
                }
            }
        }
        catch (Exception exception) {
            this.packetWriter.writeRecorderMessage(1, "Error Reading from Client");
            this.packetWriter.writeCloseConnectionInfo(this.iConnection);
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(1, "Error closing Client" + iOException);
            }
        }
        return bl;
    }

    private static String IP4ByteToString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < 4) {
            string = byArray[n] >= 0 ? string + String.valueOf(byArray[n]) : string + String.valueOf(256 + byArray[n]);
            if (n < 3) {
                string = string + ".";
            }
            ++n;
        }
        return string;
    }

    private void respondToClient(boolean bl) {
        byte[] byArray = new byte[8];
        byArray[0] = 0;
        byArray[1] = bl ? 90 : 91;
        try {
            this.to_client.write(byArray, 0, 8);
            this.to_client.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String checkForRegularConnectionRequest() {
        String string = null;
        boolean bl = false;
        try {
            this.packetWriter.writeOpenConnectionInfo(this.bSecure, this.iConnection, this.destServer, this.serverPort, this.client, this.httpServer, null, null);
            this.to_server = this.httpServer.getOutputStream();
            this.from_server = this.httpServer.getInputStream();
            this.serverReader = new ServerSideReader(this.client, this.httpServer, this.from_server, this.to_client, this.packetWriter, this.iConnection, this.bSecure, this.httpServer.getReceiveBufferSize());
            this.serverReader.start();
        }
        catch (Exception exception) {
            this.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            this.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            this.packetWriter.writeCloseConnectionInfo(this.iConnection);
            try {
                this.client.close();
                string = null;
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + ": " + iOException);
            }
        }
        return string;
    }

    public int findSSLClass() {
        int n = -1;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
            n = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            n = 0;
        }
        return n;
    }

    boolean checkSSLByte() {
        boolean bl = false;
        int n = 0;
        try {
            n = this.client.peek();
        }
        catch (IOException iOException) {
            this.packetWriter.writeRecorderMessage(2, "exception checking for SSL Connection: " + iOException);
        }
        if (n == 128 || n == 20 || n == 21 || n == 22 || n == 23) {
            bl = true;
            this.bSecure = true;
        } else {
            this.bSecure = false;
            bl = false;
        }
        return bl;
    }

    boolean checkForTestKeys() {
        boolean bl = false;
        File file = new File("C:\\testkeys");
        bl = file.exists();
        return bl;
    }
}

