/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.RecorderX509TrustManager;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class SSLCheckClass {
    SSLSocket sslServer = null;
    SSLSocket spySocket = null;
    ClientSideReader csr = null;
    static final String SpySocketException = HttpRecResourceBundle.getInstance().getString("RECORDER_SSL_SPYSOCKET_EXCEPTION");
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

    public SSLCheckClass(ClientSideReader clientSideReader) {
        this.csr = clientSideReader;
    }

    public boolean createSSLSpyServerSocket() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory;
            SSLContext sSLContext;
            char[] cArray = "passphrase".toCharArray();
            String string = System.getProperty("java.vm.vendor");
            if (string.indexOf("Sun") >= 0) {
                sSLContext = SSLContext.getInstance("TLS");
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            } else {
                sSLContext = SSLContext.getInstance("SSL");
                keyManagerFactory = KeyManagerFactory.getInstance("IbmX509");
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(new FileInputStream("C:\\testkeys"), cArray);
            keyManagerFactory.init(keyStore, cArray);
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            this.spySocket = (SSLSocket)sSLSocketFactory.createSocket(this.csr.client, "localhost", this.csr.client.getLocalPort(), true);
            this.spySocket.setUseClientMode(false);
        }
        catch (Exception exception) {
            this.csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + exception);
            this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean checkForSecureConnectionRequest() {
        boolean bl = false;
        if (this.connectToSecureServer(this.csr.destServer, this.csr.serverPort)) {
            if (this.createSSLSpyServerSocket()) {
                this.csr.packetWriter.writeOpenConnectionInfo(this.csr.bSecure, this.csr.iConnection, this.csr.destServer, this.csr.serverPort, this.csr.client, this.csr.httpServer, this.spySocket, this.sslServer);
            }
            try {
                this.csr.to_client = this.spySocket.getOutputStream();
                this.csr.from_client = this.spySocket.getInputStream();
                this.csr.to_server = this.sslServer.getOutputStream();
                this.csr.from_server = this.sslServer.getInputStream();
                this.csr.bSecure = true;
                this.csr.serverReader = new ServerSideReader(this.csr.client, this.csr.httpServer, this.csr.from_server, this.csr.to_client, this.csr.packetWriter, this.csr.iConnection, this.csr.bSecure, this.spySocket.getReceiveBufferSize());
                this.csr.serverReader.start();
            }
            catch (IOException iOException) {
                this.csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + iOException);
                this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)iOException);
                return false;
            }
        }
        this.csr.bNoPrintToServer = true;
        return this.csr.bSecure;
    }

    public boolean connectToSecureServer(String string, int n) {
        try {
            SSLSocketFactory sSLSocketFactory = null;
            TrustManager[] trustManagerArray = new TrustManager[]{new RecorderX509TrustManager()};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            this.sslServer = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            this.sslServer.startHandshake();
        }
        catch (Exception exception) {
            this.csr.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            this.csr.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            return false;
        }
        return true;
    }
}

