/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner;

import java.util.ArrayList;
import org.eclipse.hyades.test.http.runner.HttpHeader;

public abstract class HttpElement {
    private String id = Integer.toString(this.hashCode());
    private String version;
    private ArrayList headers;
    private String body;

    public void addHeader(HttpHeader httpHeader) {
        if (HttpHeader.isValid(httpHeader)) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(httpHeader);
            httpHeader.setElement(this);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public HttpHeader[] getHeaders() {
        if (this.headers == null) {
            return new HttpHeader[0];
        }
        return this.headers.toArray(new HttpHeader[this.headers.size()]);
    }

    public HttpHeader[] getHeaders(String string) {
        if (string == null || this.headers == null) {
            return new HttpHeader[0];
        }
        ArrayList<HttpHeader> arrayList = new ArrayList<HttpHeader>();
        int n = 0;
        while (n < this.headers.size()) {
            if (((HttpHeader)this.headers.get(n)).getName().equalsIgnoreCase(string)) {
                arrayList.add((HttpHeader)this.headers.get(n));
            }
            ++n;
        }
        return arrayList.toArray(new HttpHeader[arrayList.size()]);
    }

    public void removeHeaders(String string) {
        if (string == null || this.headers == null) {
            return;
        }
        int n = this.headers.size() - 1;
        while (n >= 0) {
            if (((HttpHeader)this.headers.get(n)).getName().equalsIgnoreCase(string)) {
                this.headers.remove((HttpHeader)this.headers.get(n));
            }
            --n;
        }
    }

    public String[] getHeaderValues(String string) {
        HttpHeader[] httpHeaderArray = this.getHeaders(string);
        if (httpHeaderArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[httpHeaderArray.length];
        int n = 0;
        while (n < httpHeaderArray.length) {
            stringArray[n] = httpHeaderArray[n].getValue();
            ++n;
        }
        return stringArray;
    }

    public int[] getHeaderIntValues(String string) {
        HttpHeader[] httpHeaderArray = this.getHeaders(string);
        if (httpHeaderArray == null) {
            return new int[0];
        }
        int[] nArray = new int[httpHeaderArray.length];
        int n = 0;
        while (n < httpHeaderArray.length) {
            try {
                nArray[n] = Integer.parseInt(httpHeaderArray[n].getValue());
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n] = -1;
            }
            ++n;
        }
        return nArray;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }
}

