/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.remote;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.AgentNotRegisteredException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;

public class RemoteComponentSkeleton {
    private static boolean nativesAvailable = false;
    private boolean isLogging = false;
    private boolean isInitialized = false;
    protected Vector monitorListeners = new Vector();
    protected Vector serverListeners = new Vector();
    protected Vector commandListeners = new Vector();
    protected Vector clientListeners = new Vector();
    private boolean uuidsValid = false;
    private String agentUUID;
    private String nodeUUID;
    private String jvmUUID;
    private String name;
    private String type;
    private boolean isRegistered = false;
    private long mechanism = 0L;
    private static boolean serviceAvailable = false;
    private static int agentCount = 0;
    private boolean requestForMonitor = false;
    private AgentConfiguration _defaultConfiguration = null;

    public RemoteComponentSkeleton(String string, String string2) {
        this.setName(string);
        this.setType(string2);
        this._defaultConfiguration = new AgentConfiguration();
        this._defaultConfiguration.setAgentName(string);
    }

    public void addAgentControllerListener(AgentControllerListener agentControllerListener) {
        Vector vector = this.serverListeners;
        synchronized (vector) {
            this.serverListeners.add(agentControllerListener);
        }
    }

    public void addMonitorListener(MonitorListener monitorListener) {
        Vector vector = this.monitorListeners;
        synchronized (vector) {
            this.monitorListeners.add(monitorListener);
        }
    }

    public void addRemoteClientListener(RemoteClientListener remoteClientListener) {
        Vector vector = this.clientListeners;
        synchronized (vector) {
            this.clientListeners.add(remoteClientListener);
        }
    }

    public void addCommandListener(CustomCommandHandler customCommandHandler) {
        Vector vector = this.commandListeners;
        synchronized (vector) {
            this.commandListeners.add(customCommandHandler);
        }
    }

    private void agentControllerActive() {
        serviceAvailable = true;
        this.uuidsValid = true;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (agentCount == 0) {
                this.getClass().notify();
            }
        }
        Vector vector = this.serverListeners;
        synchronized (vector) {
            Enumeration enumeration = this.serverListeners.elements();
            while (enumeration.hasMoreElements()) {
                AgentControllerListener agentControllerListener = (AgentControllerListener)enumeration.nextElement();
                agentControllerListener.agentControllerActive();
            }
        }
    }

    private void agentControllerInactive() {
        serviceAvailable = false;
        this.setLogging(false);
        this._defaultConfiguration.clear();
        Vector vector = this.serverListeners;
        synchronized (vector) {
            Enumeration enumeration = this.serverListeners.elements();
            while (enumeration.hasMoreElements()) {
                AgentControllerListener agentControllerListener = (AgentControllerListener)enumeration.nextElement();
                agentControllerListener.agentControllerInactive();
            }
        }
    }

    private void remoteClientExited() {
        this.setLogging(false);
        Vector vector = this.clientListeners;
        synchronized (vector) {
            Enumeration enumeration = this.clientListeners.elements();
            while (enumeration.hasMoreElements()) {
                RemoteClientListener remoteClientListener = (RemoteClientListener)enumeration.nextElement();
                remoteClientListener.clientInactive();
            }
        }
    }

    public synchronized void deregister() {
        if (this.isInitialized) {
            this.deregister0(this.name);
            this.isInitialized = false;
            --agentCount;
        }
    }

    private native void deregister0(String var1);

    public void finalize() {
        this.deregister0(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public synchronized void initialize() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (agentCount == 0) {
                    try {
                        this.getClass().wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    public synchronized void initializeFast() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    private native void initializeEngine0(String var1, String var2) throws AgentControllerUnavailableException;

    public boolean isAgentControllerActive() {
        return serviceAvailable;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public synchronized void logMessage(byte[] byArray, int n, int n2) {
        if (this.isLogging) {
            this.logMessage0(this.name, byArray, n, n2);
        }
    }

    public synchronized void logMessage(String string) {
        if (this.isLogging) {
            this.logMessage0(this.name, string);
        }
    }

    private native void logMessage0(String var1, byte[] var2, int var3, int var4);

    private native void logMessage0(String var1, String var2);

    public synchronized void logErrMsg(String string, String string2, int n) {
        this.logErrorMessage(string, string2, n);
    }

    private native void logErrorMessage(String var1, String var2, int var3);

    public synchronized void logMessageUTF8(String string) {
        if (this.isLogging) {
            try {
                this.logMessageUTF81(this.name, string.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                this.logMessageUTF80(this.name, string);
            }
        }
    }

    private native void logMessageUTF81(String var1, byte[] var2);

    private native void logMessageUTF80(String var1, String var2);

    public void sendMessageToAttachedClient(String string, long l) {
        if (nativesAvailable) {
            this.sendMessage0(string, l);
        }
    }

    private native void sendMessage0(String var1, long var2);

    public void sendMessageToAttachedClient(byte[] byArray, int n, int n2, long l) {
        if (nativesAvailable) {
            this.sendMessage0(byArray, n, n2, l);
        }
    }

    private native void sendMessage0(byte[] var1, int var2, int var3, long var4);

    private synchronized void setLogging(boolean bl) {
        Object object;
        this.isLogging = bl;
        Vector vector = this.monitorListeners;
        synchronized (vector) {
            object = this.monitorListeners.elements();
            while (object.hasMoreElements()) {
                MonitorListener monitorListener = (MonitorListener)object.nextElement();
                if (this.isLogging) {
                    monitorListener.monitorActive();
                    continue;
                }
                monitorListener.monitorInactive();
            }
        }
        if (this.isLogging && this.requestForMonitor) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    private void setName(String string) {
        this.name = new String(string);
    }

    private void setType(String string) {
        this.type = new String(string);
    }

    private void setAgentUUID(String string) {
        this.agentUUID = string;
    }

    public String getAgentUUID() {
        return this.agentUUID;
    }

    private void setNodeUUID(String string) {
        this.nodeUUID = string;
    }

    public String getNodeUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.nodeUUID;
    }

    private void setJVMUUID(String string) {
        this.jvmUUID = string;
    }

    public String getJVMUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.jvmUUID;
    }

    public void requestMonitorThroughPeer(InetAddress inetAddress, String string, long l) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0(inetAddress.getAddress(), string);
            try {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    Object var8_6 = null;
                    this.requestForMonitor = false;
                }
                Object var8_5 = null;
                this.requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, String var2);

    public void requestMonitorThroughPeer(InetAddress inetAddress, long l, String string, long l2) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0(inetAddress.getAddress(), l, string);
            try {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    Object var10_7 = null;
                    this.requestForMonitor = false;
                }
                Object var10_6 = null;
                this.requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, long var2, String var4);

    private void peerUnreachable() {
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            if (this.requestForMonitor) {
                this.notifyAll();
            }
        }
    }

    public AgentConfiguration getDefaultConfiguration() {
        return this._defaultConfiguration;
    }

    private void addEntryToDefaultConfiguration(AgentConfigurationEntry agentConfigurationEntry) {
        this._defaultConfiguration.addEntry(agentConfigurationEntry);
    }

    public void broadcastMessage(String string, long l) {
        this.sendMessageToAttachedClient(string, l);
    }

    public void broadcastMessage(byte[] byArray, int n, int n2, long l) {
        this.sendMessageToAttachedClient(byArray, n, n2, l);
    }

    private Object createObjectInContextOfClassLoader(String string) {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return var2_2;
    }

    private void incomingCommand(CommandElement commandElement) {
        if (commandElement instanceof CustomCommand) {
            Vector vector = this.commandListeners;
            synchronized (vector) {
                Enumeration enumeration = this.commandListeners.elements();
                while (enumeration.hasMoreElements()) {
                    CustomCommandHandler customCommandHandler = (CustomCommandHandler)enumeration.nextElement();
                    customCommandHandler.handleCommand((CustomCommand)commandElement);
                }
            }
        }
    }

    static {
        try {
            System.loadLibrary("hcjbnd");
            nativesAvailable = true;
        }
        catch (Throwable throwable) {
            nativesAvailable = false;
        }
    }
}

