/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected Vector nodes;
    protected NodeImpl ownerNode;

    protected NamedNodeMapImpl(NodeImpl nodeImpl) {
        this.ownerNode = nodeImpl;
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    final void changed(boolean bl) {
        this.flags = (short)(bl ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    protected void cloneContent(NamedNodeMapImpl namedNodeMapImpl) {
        if (namedNodeMapImpl.nodes != null) {
            this.nodes = new Vector(namedNodeMapImpl.nodes.size());
            int n = 0;
            while (n < namedNodeMapImpl.nodes.size()) {
                NodeImpl nodeImpl = (NodeImpl)namedNodeMapImpl.nodes.elementAt(n);
                NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.cloneNode(true);
                nodeImpl2.isSpecified(nodeImpl.isSpecified());
                this.nodes.insertElementAt(nodeImpl2, n);
                ++n;
            }
        }
    }

    public NamedNodeMapImpl cloneMap(NodeImpl nodeImpl) {
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(nodeImpl);
        namedNodeMapImpl.cloneContent(this);
        return namedNodeMapImpl;
    }

    protected int findNamePoint(String string, int n) {
        int n2 = 0;
        if (this.nodes != null) {
            int n3 = n;
            int n4 = this.nodes.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = string.compareTo(((Node)this.nodes.elementAt(n2)).getNodeName());
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    protected int findNamePoint(String string, String string2) {
        if (this.nodes == null) {
            return -1;
        }
        if (string2 == null) {
            return -1;
        }
        int n = 0;
        while (n < this.nodes.size()) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            String string3 = nodeImpl.getNamespaceURI();
            String string4 = nodeImpl.getLocalName();
            if (string == null ? string3 == null && (string2.equals(string4) || string4 == null && string2.equals(nodeImpl.getNodeName())) : string.equals(string3) && string2.equals(string4)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node getNamedItem(String string) {
        int n = this.findNamePoint(string, 0);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = this.findNamePoint(string, string2);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final void hasDefaults(boolean bl) {
        this.flags = (short)(bl ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = (short)(bl ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    public Node item(int n) {
        return this.nodes != null && n < this.nodes.size() ? (Node)this.nodes.elementAt(n) : null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, 0);
        if (n < 0) {
            throw new DOMException(8, "DOM008 Not found");
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        this.nodes.removeElementAt(n);
        return nodeImpl;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int n = this.findNamePoint(string, string2);
        if (n < 0) {
            throw new DOMException(8, "DOM008 Not found");
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        this.nodes.removeElementAt(n);
        return nodeImpl;
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        int n = this.findNamePoint(node.getNodeName(), 0);
        NodeImpl nodeImpl = null;
        if (n >= 0) {
            nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(node, n);
        }
        return nodeImpl;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        int n = this.findNamePoint(node.getNamespaceURI(), node.getLocalName());
        NodeImpl nodeImpl = null;
        if (n >= 0) {
            nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
        } else {
            n = this.findNamePoint(node.getNodeName(), 0);
            if (n >= 0) {
                nodeImpl = (NodeImpl)this.nodes.elementAt(n);
                this.nodes.insertElementAt(node, n);
            } else {
                n = -1 - n;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(node, n);
            }
        }
        return nodeImpl;
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.nodes != null) {
            int n = 0;
            while (n < this.nodes.size()) {
                ((NodeImpl)this.item(n)).setOwnerDocument(documentImpl);
                ++n;
            }
        }
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.isReadOnly(bl);
        if (bl2 && this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeImpl)enumeration.nextElement()).setReadOnly(bl, bl2);
            }
        }
    }
}

