/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public class RemoteLogParserLoader {
    public static void main(String[] stringArray) {
        System.setProperty("org.apache.commons.logging.Log", "org.eclipse.hyades.logging.commons.Logger");
        Log log = null;
        long l = 300000L;
        try {
            l = Long.parseLong(System.getProperty("org.eclipse.hyades.logging.parsers.maxWaitTimeInMillis"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            log = LogFactory.getLog((String)"Remote Log Loader IRemoteEntity");
            int n = stringArray.length;
            if (n == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_PARAMETER_ERROR_"));
            }
            int n2 = 0;
            if (stringArray[n2].trim().equals("com.ibm.etools.logging.parsers.RemoteLogParserLoader")) {
                ++n2;
            }
            String string = null;
            if (n <= n2) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CLASSNAME_PARAMETER_ERROR_"));
            }
            string = stringArray[n2];
            if (n <= ++n2) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string2 = null;
            int n3 = -1;
            while (n > n2) {
                if ((n3 = (string2 = stringArray[n2++]).indexOf(61)) == -1) continue;
                hashtable.put(string2.substring(0, n3), string2.substring(n3 + 1));
            }
            if (hashtable.isEmpty()) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
            }
            if (log instanceof IPreemptedLogger) {
                ((IPreemptedLogger)log).waitUntilLogging(l);
                if (!((IPreemptedLogger)log).isLogging()) {
                    throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_MONITORING_ERROR_", string, String.valueOf((double)l / 1000.0)));
                }
            }
            try {
                if (log instanceof Logger) {
                    ((Logger)log).setLevel(0);
                }
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                clazz.getMethod("setUserInput", hashtable.getClass()).invoke(obj, hashtable);
                clazz.getMethod("parse", Class.forName("org.apache.commons.logging.Log")).invoke(obj, log);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new LogParserException(invocationTargetException.getTargetException().getMessage());
            }
            catch (Throwable throwable) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_INITIALIZATION_ERROR_", string));
            }
        }
        catch (Throwable throwable) {
            LoggingAgent loggingAgent = new LoggingAgent("Remote Log Loader Error IRemoteEntity");
            loggingAgent.waitUntilLogging(l);
            if (loggingAgent.isLogging()) {
                loggingAgent.write(throwable.getMessage());
            } else {
                System.err.println(throwable.getMessage());
            }
            loggingAgent.deregister();
        }
        if (log != null && log instanceof IPreemptedLogger) {
            ((IPreemptedLogger)log).finalize();
        }
    }
}

