/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import java.util.Stack;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.Invoker;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.remote.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class SessionImpl
extends ExecutionComponentImpl
implements ISession {
    private Object completionLock = new Object();
    private boolean completed = false;
    private boolean initializedWithRAC = false;
    RemoteComponentSkeleton agent;
    private final Stack messageQueue = new Stack();

    public SessionImpl(String string, String string2) {
        this.agent = new RemoteComponentSkeleton(string, string2);
    }

    public void init() {
        this.agent.addAgentControllerListener(new AgentControllerListener(){

            public void agentControllerActive() {
                SessionImpl.this.initializedWithRAC = true;
            }

            public void agentControllerInactive() {
                if (SessionImpl.this.initializedWithRAC) {
                    System.exit(-2);
                }
            }
        });
        this.agent.addRemoteClientListener(new RemoteClientListener(){

            public void clientActive() {
            }

            public void clientInactive() {
                System.exit(-3);
            }
        });
        this.agent.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand customCommand) {
                Stack stack = SessionImpl.this.messageQueue;
                synchronized (stack) {
                    SessionImpl.this.messageQueue.push(customCommand);
                    if (SessionImpl.this.messageQueue.size() == 1) {
                        SessionImpl.this.messageQueue.notify();
                    }
                }
            }
        });
        ExecutionComponentFactoryImpl.getInstance(this);
        try {
            this.agent.initialize();
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            // empty catch block
        }
    }

    public void waitForExit() {
        while (!this.completed) {
            Object object = this.completionLock;
            synchronized (object) {
                try {
                    this.completionLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void exit() {
        Object object = this.completionLock;
        synchronized (object) {
            this.completed = true;
            this.completionLock.notifyAll();
        }
    }

    public void release() {
        this.exit();
    }

    public void replyRemote(CustomCommand customCommand) {
        byte[] byArray = customCommand.getDataBinary();
        this.agent.broadcastMessage(byArray, 0, byArray.length, 0L);
    }

    public void handleCommands() {
        while (true) {
            Stack stack = this.messageQueue;
            synchronized (stack) {
                Object object;
                Stack stack2;
                while (this.messageQueue.size() == 0) {
                    stack2 = this.messageQueue;
                    synchronized (stack2) {
                        block18: {
                            try {
                                this.messageQueue.wait(2000L);
                                if (this.messageQueue.size() != 0) break block18;
                                object = this.completionLock;
                                synchronized (object) {
                                    if (this.completed) {
                                        return;
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                stack2 = (CustomCommand)this.messageQueue.pop();
                object = null;
                try {
                    object = Marshaller.unmarshalMethodCall((byte[])stack2.getDataBinary());
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    return;
                }
                try {
                    ReturnData returnData = Invoker.invoke((CallData)object);
                    stack2.setData(Marshaller.marshalReturnValue((ReturnData)returnData));
                    this.replyRemote((CustomCommand)stack2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

