/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.extractors.SimpleExtractor;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class RegularExpressionExtractor
extends SimpleExtractor {
    private Perl5Compiler compiler = new Perl5Compiler();
    private PatternMatcherInput input = new PatternMatcherInput("");
    private Perl5Matcher matcher = new Perl5Matcher();
    private Pattern compiledStartPattern;
    private Pattern compiledEndPattern;

    public void update() throws AdapterInvalidConfig {
        super.update();
        if (this.getStartPattern() != null && !this.getStartPattern().equals("")) {
            try {
                this.compiledStartPattern = this.compiler.compile(this.getStartPattern());
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_Start_Pattern_Invalid", malformedPatternException.getMessage()));
            }
        }
        if (this.getEndPattern() != null && !this.getEndPattern().equals("")) {
            try {
                this.compiledEndPattern = this.compiler.compile(this.getEndPattern());
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_End_Pattern_Invalid", malformedPatternException.getMessage()));
            }
        }
    }

    protected void search(SimpleExtractor.StringPosition stringPosition, String string, String string2, int n) {
        boolean bl = false;
        String string3 = null;
        int n2 = -1;
        Pattern pattern = null;
        pattern = string == this.getStartPattern() ? this.compiledStartPattern : this.compiledEndPattern;
        this.input.setInput(string2, n, string2.length() - n);
        this.matcher.setMultiline(true);
        bl = this.matcher.contains(this.input, pattern);
        if (bl) {
            string3 = this.input.match();
            n2 = this.input.getMatchBeginOffset();
        }
        if (n2 > -1 && n2 < string2.length()) {
            stringPosition.setStartPosition(n2);
            if (string3.length() > 1) {
                stringPosition.setEndPosition(n2 + string3.length() - 1);
            } else {
                stringPosition.setEndPosition(n2);
            }
            stringPosition.setValid(true);
        }
    }
}

