/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;

public class Thd
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _name = null;
    public int _ID;
    public Vector _stack;
    public Vector _stackNative;
    public String _threadId = null;
    public String _priority = null;
    public String _state = null;
    public int _waitMonitorID = 0;
    public Monitor _waitMonitor = null;
    public Properties _props = null;
    private boolean _fHtml = false;
    private boolean _selfWaiter = false;
    private static String sTab = "   ";
    public transient Thd _nextByTOS = null;
    public transient Thd _prevByTOS = null;

    public Thd(String string, String string2, String string3, String string4) {
        this._version = _curVersion;
        this._name = string;
        this._ID = DumpData.getID();
        this._stack = null;
        this._stackNative = null;
        this._threadId = string2;
        this._priority = string4;
        this._state = string3;
        this._stack = new Vector();
        this._stackNative = new Vector();
        this._waitMonitor = null;
        this._props = new Properties();
        this._nextByTOS = null;
        this._prevByTOS = null;
        this._fHtml = false;
    }

    public String getThreadId() {
        return this._threadId;
    }

    public void setProperty(String string, String string2) {
        this._props.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._props.getProperty(string);
    }

    public void addStackEntry(StkEntry stkEntry) {
        this._stack.add(stkEntry);
    }

    public void addStackEntryNative(StkEntryNative stkEntryNative) {
        this._stackNative.add(stkEntryNative);
    }

    public String getName() {
        return this._name;
    }

    public void setWaitMonitor(Monitor monitor) {
        this._waitMonitorID = monitor._ID;
        this._waitMonitor = monitor;
    }

    public int getWaitMonitorId() {
        return this._waitMonitorID;
    }

    public boolean waitingForWebWork() {
        return this.boolPropVal("WAITING_FOR_WEB_WORK");
    }

    public boolean waitingForOtherWork() {
        return this.boolPropVal("WAITING_FOR_OTHER_WORK");
    }

    public String getServletName() {
        return this.getProperty("SERVLET_NAME");
    }

    public String[] getEjbNames() {
        return new String[0];
    }

    public boolean isServletThread() {
        boolean bl = false;
        bl = this.isExecutingWebWork() || this.waitingForWebWork() || this.isEmptyServletThd();
        return bl;
    }

    public boolean isEmptyServletThd() {
        return this.getName().indexOf("Servlet") != -1 && this.getStkSize() == 0;
    }

    public boolean isOrbThread() {
        boolean bl = false;
        bl = this.isExecutingRemoteOrbWork() || this.waitingForOrbWork() || this.isEmptyOrbThd();
        return bl;
    }

    public boolean isEmptyOrbThd() {
        return this.getName().indexOf("ORB") != -1 && this.getStkSize() == 0;
    }

    public boolean isExecutingWebWork() {
        return this.boolPropVal("EXECUTING_WEB_WORK");
    }

    public boolean isExecutingOrbWork() {
        return this.boolPropVal("EXECUTING_ORB_WORK");
    }

    public boolean isExecutingRemoteOrbWork() {
        return this.boolPropVal("EXECUTING_REMOTE_ORB_WORK");
    }

    public boolean waitingForOrbWork() {
        return this.boolPropVal("WAITING_FOR_REMOTE_ORB_WORK");
    }

    public boolean waitingForInfrastructureWork() {
        return this.boolPropVal("WAITING_FOR_INFRASTRUCTURE_WORK");
    }

    public boolean waitingForQueueWork() {
        return this.boolPropVal("WAITING_FOR_QUEUE_WORK");
    }

    public boolean waitingForWork() {
        return this.waitingForOrbWork() || this.waitingForWebWork() || this.waitingForQueueWork() || this.waitingForOtherWork();
    }

    public boolean firstStackDifference(Vector vector, Thd thd) {
        int n;
        Object var3_3 = null;
        Object var4_4 = null;
        int n2 = this._stack.size();
        int n3 = n2 > (n = thd._stack.size()) ? n : n2;
        int n4 = 0;
        while (n4 < n3) {
            StkEntry stkEntry = (StkEntry)this._stack.elementAt(n4);
            StkEntry stkEntry2 = (StkEntry)thd._stack.elementAt(n4);
            if (!stkEntry.getFQName().equals(stkEntry2.getFQName()) || n4 == n3 - 1) {
                Caller caller;
                boolean bl = false;
                int n5 = 0;
                while (n5 < vector.size()) {
                    caller = (Caller)vector.elementAt(n5);
                    StkEntry stkEntry3 = caller._stkEntry;
                    if (stkEntry3.getFQName().equals(stkEntry2.getFQName())) {
                        bl = true;
                        ++caller._count;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    caller = new Caller();
                    caller._stkEntry = stkEntry2;
                    caller._count = 1;
                    vector.add(caller);
                }
                return true;
            }
            ++n4;
        }
        if (n > n2) {
            System.out.println(TAUtils.getNLSValue("ta.warnmsg.AnalysisIncomplete", "WARNING: stack diff analysis incomplete for thread") + " " + thd.getName());
        }
        return false;
    }

    public static int getCallerCount(Object object) {
        return ((Caller)object)._count;
    }

    public static String getCallerName(Object object) {
        return ((Caller)object)._stkEntry.getFQName();
    }

    public Vector format(int n, boolean bl) {
        Vector<String> vector = new Vector<String>();
        this._fHtml = bl;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + sTab;
            ++n2;
        }
        vector.add(" ");
        vector.add(string + this.html("<a name=" + this.getThreadId() + "></a>") + TAUtils.getNLSValue("ta.format.ThreadInformation", "Thread information") + ":");
        vector.add(string + sTab + TAUtils.getNLSValue("ta.format.ThreadType", "Thread type") + "..................... " + this._props.getProperty("THREAD_TYPE"));
        vector.add(string + sTab + TAUtils.getNLSValue("ta.format.Name", "name") + "............................ " + this._name);
        vector.add(string + sTab + TAUtils.getNLSValue("ta.format.ThreadID", "thread id") + "....................... " + this._threadId);
        vector.add(string + sTab + TAUtils.getNLSValue("ta.format.Priority", "priority") + "........................ " + this._priority);
        vector.add(string + sTab + TAUtils.getNLSValue("ta.format.State", "state") + "........................... " + this._state);
        String string2 = "";
        String string3 = "";
        if (this._nextByTOS != null) {
            string3 = "<a href=#" + this._nextByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.next", "next") + "]</a> ";
        }
        if (this._prevByTOS != null) {
            string2 = "<a href=#" + this._prevByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.previous", "previous") + "]</a> ";
        }
        if (bl && (this._nextByTOS != null || this._prevByTOS != null)) {
            vector.add(string + sTab + " " + string2 + string3 + TAUtils.getNLSValue("ta.msg.WithSameTOS", "with same top of stack") + ".");
        }
        if (!this.waitingForWebWork() && !this.waitingForOrbWork() && this._waitMonitor != null) {
            vector.add(string + "\t" + TAUtils.getNLSValue("ta.msg.WaitingOnMonitor", "Waiting on monitor") + "................ " + this._waitMonitor.getName());
        }
        vector.add(string + sTab + TAUtils.getNLSValue("ta.msg.WaitingForWebWork", "Waiting for web work") + "............. " + Thd.yesOrNo(this.waitingForWebWork()));
        vector.add(string + sTab + TAUtils.getNLSValue("ta.msg.ExecutingWebOrLocalEjbWork", "Executing web or local EJB work") + ".. " + Thd.yesOrNo(this.isExecutingWebWork() || this.isExecutingOrbWork() || this.isExecutingRemoteOrbWork()));
        vector.add(string + sTab + TAUtils.getNLSValue("ta.msg.WaitingForRemoteOrb", "Waiting for remote orb work") + "...... " + Thd.yesOrNo(this.waitingForOrbWork()));
        if (this._stack.size() <= 0 && this._stackNative.size() <= 0) {
            vector.add(string + sTab + sTab + "* " + TAUtils.getNLSValue("ta.msg.NoStackInfo", "no stack information available") + " *");
        } else {
            StkEntry stkEntry;
            int n3;
            if (this._stack.size() > 0) {
                vector.add(string + sTab + TAUtils.getNLSValue("ta.string.Stack", "Stack") + ": ");
                n3 = 0;
                while (n3 < this._stack.size()) {
                    stkEntry = (StkEntry)this._stack.get(n3);
                    vector.add(stkEntry.format(n));
                    ++n3;
                }
            }
            if (this._stackNative.size() > 0) {
                vector.add(string + sTab + "Native Stack" + ": ");
                n3 = 0;
                while (n3 < this._stackNative.size()) {
                    stkEntry = (StkEntryNative)this._stackNative.get(n3);
                    vector.add(((StkEntryNative)stkEntry).format(n));
                    ++n3;
                }
            }
        }
        return vector;
    }

    public static String yesOrNo(boolean bl) {
        if (bl) {
            return TAUtils.getNLSValue("ta.string.yes", "yes");
        }
        return TAUtils.getNLSValue("ta.string.no", "no");
    }

    public void print(int n, boolean bl) {
        Vector vector = this.format(n, bl);
        int n2 = 0;
        while (n2 < vector.size()) {
            System.out.println(vector.elementAt(n2));
            ++n2;
        }
    }

    public boolean stackContainsLike(String string) {
        int n = 0;
        boolean bl = false;
        StkEntry stkEntry = this.getStkEntry(n);
        while (stkEntry != null) {
            if (stkEntry.getFQName().indexOf(string) != -1) {
                bl = true;
                break;
            }
            stkEntry = this.getStkEntry(++n);
        }
        return bl;
    }

    public StkEntry getTOS() {
        if (this._stack.size() > 0) {
            return (StkEntry)this._stack.elementAt(0);
        }
        return null;
    }

    public StkEntry getBOS() {
        if (this._stack.size() > 0) {
            return (StkEntry)this._stack.elementAt(this._stack.size() - 1);
        }
        return null;
    }

    public int getStkSize() {
        return this._stack.size();
    }

    public int getStkNativeSize() {
        return this._stackNative.size();
    }

    public StkEntry getStkEntry(int n) {
        StkEntry stkEntry = null;
        if (n < this._stack.size()) {
            stkEntry = (StkEntry)this._stack.elementAt(n);
        }
        return stkEntry;
    }

    public StkEntryNative getStkEntryNative(int n) {
        StkEntryNative stkEntryNative = null;
        if (n < this._stackNative.size()) {
            stkEntryNative = (StkEntryNative)this._stackNative.elementAt(n);
        }
        return stkEntryNative;
    }

    protected boolean boolPropVal(String string) {
        boolean bl = false;
        String string2 = this.getProperty(string);
        if (string2 != null && string2.equals("true")) {
            bl = true;
        }
        return bl;
    }

    private String html(String string) {
        if (this._fHtml) {
            return string;
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this._version);
        objectOutput.writeObject(this._name);
        objectOutput.writeInt(this._ID);
        objectOutput.writeObject(this._stack);
        objectOutput.writeObject(this._stackNative);
        objectOutput.writeObject(this._threadId);
        objectOutput.writeObject(this._priority);
        objectOutput.writeObject(this._state);
        objectOutput.writeInt(this._waitMonitorID);
        objectOutput.writeObject(this._props);
        objectOutput.writeBoolean(this._fHtml);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._version = objectInput.readInt();
        this._name = (String)objectInput.readObject();
        this._ID = objectInput.readInt();
        this._stack = (Vector)objectInput.readObject();
        Object object = objectInput.readObject();
        try {
            this._stackNative = (Vector)object;
            this._threadId = (String)objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            this._stackNative = new Vector();
            this._threadId = (String)object;
        }
        this._priority = (String)objectInput.readObject();
        this._state = (String)objectInput.readObject();
        this._waitMonitorID = objectInput.readInt();
        this._props = (Properties)objectInput.readObject();
        this._fHtml = objectInput.readBoolean();
    }

    int getId() {
        return this._ID;
    }

    public Thd() {
    }

    public boolean isSelfWaiter() {
        return this._selfWaiter;
    }

    public void setSelfWaiter(boolean bl) {
        this._selfWaiter = bl;
    }

    class Caller {
        public StkEntry _stkEntry = null;
        public int _count = 1;

        Caller() {
        }
    }
}

