/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLevel;

public final class CommonBaseEventLogRecord
extends LogRecord
implements IExternalizableToXml {
    private CommonBaseEvent commonBaseEvent = null;
    private static EventFactory eventFactory = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory("org.eclipse.hyades.logging.java.CommonBaseEventLogRecord");
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL = "level";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME = "name";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE = "value";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME = "loggerName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER = "sequenceNumber";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME = "sourceClassName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME = "sourceMethodName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_THREAD_ID = "threadID";
    public static final String EXTENDED_DATA_ELEMENT_NAME_THROWN = "stackTrace";
    public static final String EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME = "stackFrame";

    public CommonBaseEventLogRecord(CommonBaseEvent commonBaseEvent) {
        super(Level.OFF, null);
        if (commonBaseEvent != null) {
            EList threadIDExtendedDataElements;
            EList sequenceNumberExtendedDataElements;
            this.commonBaseEvent = commonBaseEvent;
            EList levelExtendedDataElements = commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            if (levelExtendedDataElements == null || levelExtendedDataElements.size() <= 0) {
                short severity = commonBaseEvent.getSeverity();
                if (severity >= 50) {
                    this.setLevel(Level.SEVERE);
                } else if (severity >= 30 && severity <= 49) {
                    this.setLevel(Level.WARNING);
                } else {
                    this.setLevel(Level.INFO);
                }
            }
            if ((sequenceNumberExtendedDataElements = commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER)) == null || sequenceNumberExtendedDataElements.size() <= 0) {
                this.setSequenceNumber(super.getSequenceNumber());
            }
            if ((threadIDExtendedDataElements = commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID)) == null || threadIDExtendedDataElements.size() <= 0) {
                this.setThreadID(super.getThreadID());
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                commonBaseEvent.setCreationTimeAsLong(System.currentTimeMillis());
            }
        }
    }

    public CommonBaseEventLogRecord(Level level, String message) {
        super(level, message);
    }

    public CommonBaseEventLogRecord(Level level) {
        super(level, null);
    }

    public CommonBaseEventLogRecord(LogRecord logRecord) {
        super(logRecord.getLevel(), logRecord.getMessage());
        super.setMillis(logRecord.getMillis());
        super.setSequenceNumber(logRecord.getSequenceNumber());
        super.setThreadID(logRecord.getThreadID());
        super.setLoggerName(logRecord.getLoggerName());
        super.setParameters(logRecord.getParameters());
        super.setResourceBundle(logRecord.getResourceBundle());
        super.setResourceBundleName(logRecord.getResourceBundleName());
        super.setSourceClassName(logRecord.getSourceClassName());
        super.setSourceMethodName(logRecord.getSourceMethodName());
        super.setThrown(logRecord.getThrown());
    }

    public void setCommonBaseEvent(CommonBaseEvent commonBaseEvent) {
        this.commonBaseEvent = commonBaseEvent;
    }

    public void setLevel(Level level) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            ExtendedDataElement levelExtendedDataElement = eventFactory.createExtendedDataElement();
            levelExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            levelExtendedDataElement.setTypeAsInt(0);
            levelExtendedDataElement.addChild(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME, level.getName());
            levelExtendedDataElement.addChildWithIntValue(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE, level.intValue());
            this.commonBaseEvent.addExtendedDataElement(levelExtendedDataElement);
        } else {
            super.setLevel(level);
        }
    }

    public void setLoggerName(String name) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            ExtendedDataElement loggerNameExtendedDataElement = eventFactory.createExtendedDataElement();
            loggerNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            loggerNameExtendedDataElement.setValuesAsString(name);
            this.commonBaseEvent.addExtendedDataElement(loggerNameExtendedDataElement);
        } else {
            super.setLoggerName(name);
        }
    }

    public void setMessage(String message) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = eventFactory.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalogId(message);
        } else {
            super.setMessage(message);
        }
    }

    public void setMillis(long millis) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.setCreationTimeAsLong(millis);
        } else {
            super.setMillis(millis);
        }
    }

    public void setParameters(Object[] parameters) {
        super.setParameters(parameters);
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (parameters != null) {
                if (msgDataElement == null) {
                    msgDataElement = eventFactory.createMsgDataElement();
                    this.commonBaseEvent.setMsgDataElement(msgDataElement);
                }
                MsgCatalogToken[] msgCatalogTokens = new MsgCatalogToken[parameters.length];
                int counter = 0;
                while (counter < parameters.length) {
                    msgCatalogTokens[counter] = eventFactory.createMsgCatalogToken();
                    msgCatalogTokens[counter].setValue(String.valueOf(parameters[counter]));
                    ++counter;
                }
                msgDataElement.setMsgCatalogTokens(msgCatalogTokens);
            } else {
                msgDataElement.clearMsgCatalogTokens();
            }
        }
    }

    public void setResourceBundle(ResourceBundle bundle) {
        super.setResourceBundle(bundle);
    }

    public void setResourceBundleName(String name) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = eventFactory.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalog(name);
            msgDataElement.setMsgCatalogType("Java");
        } else {
            super.setResourceBundleName(name);
        }
    }

    public void setSequenceNumber(long seq) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            ExtendedDataElement sequenceNumberExtendedDataElement = eventFactory.createExtendedDataElement();
            sequenceNumberExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            sequenceNumberExtendedDataElement.setValuesAsLong(seq);
            this.commonBaseEvent.addExtendedDataElement(sequenceNumberExtendedDataElement);
        } else {
            super.setSequenceNumber(seq);
        }
    }

    public void setSourceClassName(String sourceClassName) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            ExtendedDataElement sourceClassNameExtendedDataElement = eventFactory.createExtendedDataElement();
            sourceClassNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            sourceClassNameExtendedDataElement.setValuesAsString(sourceClassName);
            this.commonBaseEvent.addExtendedDataElement(sourceClassNameExtendedDataElement);
        } else {
            super.setSourceClassName(sourceClassName);
        }
    }

    public void setSourceMethodName(String sourceMethodName) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            ExtendedDataElement sourceMethodNameExtendedDataElement = eventFactory.createExtendedDataElement();
            sourceMethodNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            sourceMethodNameExtendedDataElement.setValuesAsString(sourceMethodName);
            this.commonBaseEvent.addExtendedDataElement(sourceMethodNameExtendedDataElement);
        } else {
            super.setSourceMethodName(sourceMethodName);
        }
    }

    public void setThreadID(int threadID) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            ExtendedDataElement threadIDExtendedDataElement = eventFactory.createExtendedDataElement();
            threadIDExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            threadIDExtendedDataElement.setValuesAsInt(threadID);
            this.commonBaseEvent.addExtendedDataElement(threadIDExtendedDataElement);
        } else {
            super.setThreadID(threadID);
        }
    }

    public void setThrown(Throwable thrown) {
        super.setThrown(thrown);
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THROWN);
            this.commonBaseEvent.addExtendedDataElement(this.convertToExtendedDataElement(thrown));
        }
    }

    public CommonBaseEvent getCommonBaseEvent() {
        return this.commonBaseEvent;
    }

    public Level getLevel() {
        if (this.commonBaseEvent != null) {
            EList levelExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            if (levelExtendedDataElements != null && levelExtendedDataElements.size() > 0) {
                ExtendedDataElement levelExtendedDataElement = (ExtendedDataElement)levelExtendedDataElements.get(0);
                EList nameExtendedDataElements = levelExtendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME);
                EList valueExtendedDataElements = levelExtendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE);
                if (nameExtendedDataElements != null && nameExtendedDataElements.size() > 0 && valueExtendedDataElements != null && valueExtendedDataElements.size() > 0) {
                    ExtendedDataElement nameExtendedDataElement = (ExtendedDataElement)nameExtendedDataElements.get(0);
                    ExtendedDataElement valueExtendedDataElement = (ExtendedDataElement)valueExtendedDataElements.get(0);
                    String name = nameExtendedDataElement.getValuesAsString();
                    if (name != null) {
                        try {
                            return Level.parse(name);
                        }
                        catch (IllegalArgumentException i) {
                            // empty catch block
                        }
                    }
                    return new CommonBaseEventLevel(name, valueExtendedDataElement.getValuesAsInt());
                }
            }
            return Level.INFO;
        }
        return super.getLevel();
    }

    public String getLoggerName() {
        if (this.commonBaseEvent != null) {
            EList loggerNameExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            if (loggerNameExtendedDataElements != null && loggerNameExtendedDataElements.size() > 0) {
                ExtendedDataElement loggerNameExtendedDataElement = (ExtendedDataElement)loggerNameExtendedDataElements.get(0);
                return loggerNameExtendedDataElement.getValuesAsString();
            }
        } else {
            return super.getLoggerName();
        }
        return null;
    }

    public String getMessage() {
        if (this.commonBaseEvent != null) {
            String msgCatalogId;
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null && (msgCatalogId = msgDataElement.getMsgCatalogId()) != null) {
                return msgCatalogId;
            }
        } else {
            return super.getMessage();
        }
        return this.commonBaseEvent.getMsg();
    }

    public long getMillis() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.getCreationTimeAsLong();
        }
        return super.getMillis();
    }

    public Object[] getParameters() {
        Object[] msgCatalogTokens;
        MsgDataElement msgDataElement;
        Object[] parameters = super.getParameters();
        if (parameters != null) {
            return parameters;
        }
        if (this.commonBaseEvent != null && (msgDataElement = this.commonBaseEvent.getMsgDataElement()) != null && (msgCatalogTokens = msgDataElement.getMsgCatalogTokensAsStrings()) != null && msgCatalogTokens.length > 0) {
            return msgCatalogTokens;
        }
        return null;
    }

    public ResourceBundle getResourceBundle() {
        return super.getResourceBundle();
    }

    public String getResourceBundleName() {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null) {
                return msgDataElement.getMsgCatalog();
            }
        } else {
            return super.getResourceBundleName();
        }
        return null;
    }

    public long getSequenceNumber() {
        if (this.commonBaseEvent != null) {
            EList sequenceNumberExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            if (sequenceNumberExtendedDataElements != null && sequenceNumberExtendedDataElements.size() > 0) {
                ExtendedDataElement sequenceNumberExtendedDataElement = (ExtendedDataElement)sequenceNumberExtendedDataElements.get(0);
                return sequenceNumberExtendedDataElement.getValuesAsLong();
            }
        } else {
            return super.getSequenceNumber();
        }
        return 0L;
    }

    public String getSourceClassName() {
        if (this.commonBaseEvent != null) {
            EList sourceClassNameExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            if (sourceClassNameExtendedDataElements != null && sourceClassNameExtendedDataElements.size() > 0) {
                ExtendedDataElement sourceClassNameExtendedDataElement = (ExtendedDataElement)sourceClassNameExtendedDataElements.get(0);
                return sourceClassNameExtendedDataElement.getValuesAsString();
            }
        } else {
            return super.getSourceClassName();
        }
        return null;
    }

    public String getSourceMethodName() {
        if (this.commonBaseEvent != null) {
            EList sourceMethodNameExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            if (sourceMethodNameExtendedDataElements != null && sourceMethodNameExtendedDataElements.size() > 0) {
                ExtendedDataElement sourceMethodNameExtendedDataElement = (ExtendedDataElement)sourceMethodNameExtendedDataElements.get(0);
                return sourceMethodNameExtendedDataElement.getValuesAsString();
            }
        } else {
            return super.getSourceMethodName();
        }
        return null;
    }

    public int getThreadID() {
        if (this.commonBaseEvent != null) {
            EList threadIDExtendedDataElements = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            if (threadIDExtendedDataElements != null && threadIDExtendedDataElements.size() > 0) {
                ExtendedDataElement threadIDExtendedDataElement = (ExtendedDataElement)threadIDExtendedDataElements.get(0);
                return threadIDExtendedDataElement.getValuesAsInt();
            }
        } else {
            return super.getThreadID();
        }
        return 0;
    }

    public Throwable getThrown() {
        return super.getThrown();
    }

    public String externalizeCanonicalXmlString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLString((CommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    public String externalizeCanonicalXmlDocString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLDocString((CommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    public String toString() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.toString();
        }
        return super.toString();
    }

    private ExtendedDataElement convertToExtendedDataElement(Throwable throwable) {
        Throwable cause;
        if (throwable == null) {
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN);
            extendedDataElement.setValuesAsString("null");
            return extendedDataElement;
        }
        StringBuffer thrownString = new StringBuffer(throwable.getClass().getName());
        String thrownMessage = throwable.getMessage();
        if (thrownMessage != null && thrownMessage.trim().length() > 0) {
            thrownString.append(':');
            thrownString.append(thrownMessage.trim());
        }
        if ((cause = throwable.getCause()) != null) {
            thrownString.append(":Cause:");
            thrownString.append(cause.getClass().getName());
            thrownMessage = cause.getMessage();
            if (thrownMessage != null && thrownMessage.trim().length() > 0) {
                thrownString.append(':');
                thrownString.append(thrownMessage.trim());
            }
        }
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN);
        extendedDataElement.setValuesAsString(thrownString.toString());
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        if (stackTraceElements != null) {
            ExtendedDataElement childExtendedDataElement = null;
            int counter = 0;
            while (counter < stackTraceElements.length) {
                childExtendedDataElement = eventFactory.createExtendedDataElement();
                childExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME.concat(String.valueOf(counter + 1)));
                childExtendedDataElement.setValuesAsString(stackTraceElements[counter].toString());
                extendedDataElement.addChild(childExtendedDataElement);
                ++counter;
            }
        }
        return extendedDataElement;
    }
}

