/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.SAXFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.xml.sax.SAXParseException;

public class XMLLoader
implements IXMLLoader {
    protected FileWriter file;
    protected HierarchyContext context;
    protected InvalidXMLException error;
    protected Map loaders = new HashMap();
    protected String currentAttributeName;
    protected String currentElementName;
    protected XMLFragmentHandler scanner;
    protected XMLFragmentLoader currentLoader;
    protected XMLFragmentLoader defaultLoader = new IgnoredXMLFragmentLoader();
    protected boolean startDocument;
    protected int depth = 0;
    protected int fragmentsCount;

    public XMLLoader(TRCAgentProxy agentProxy) {
        this.makeScanner();
        TRCAgent agent = agentProxy.getAgent();
        if (agent != null && agent.eResource() != null) {
            this.context = LoadersUtils.locateHierarchyContext(agent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            if (agentProxy != null) {
                this.context.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
                this.context.setNode(agentProxy.getProcessProxy().getNode());
                this.context.setProcessProxy(agentProxy.getProcessProxy());
                this.context.setAgentProxy(agentProxy);
            }
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else {
            if (this.context.getAgentProxy() == null) {
                this.context.setAgentProxy(agentProxy);
            }
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(agentProxy.getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(agentProxy.getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCAgent agent) {
        this.makeScanner();
        if (agent != null) {
            this.context = LoadersUtils.locateHierarchyContext(agent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            this.context.setNode(agent.getAgentProxy().getProcessProxy().getNode());
            this.context.setProcessProxy(agent.getAgentProxy().getProcessProxy());
            this.context.setAgentProxy(agent.getAgentProxy());
            this.context.setAgent(agent);
            if (agent.eResource() == null) {
                try {
                    this.addToResource(agent, this.context);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else if (this.context.getAgentProxy() == null) {
            this.context.setAgentProxy(agent.getAgentProxy());
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(agent.getAgentProxy().getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(agent.getAgentProxy().getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCMonitor monitor) {
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(monitor);
        }
        this.makeScanner();
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public void setCollectionMode(int collectionMode) {
        this.context.setCollectionMode(TRCCollectionMode.get(collectionMode));
    }

    public HierarchyContext getContext() {
        return this.context;
    }

    public int getProcessedFragments() {
        return this.fragmentsCount;
    }

    public void attributeName(String name) {
        if (this.isIgnoredElement()) {
            return;
        }
        this.currentAttributeName = name;
    }

    public void attributeValueCharacters(String attributeValue) {
        if (this.isIgnoredElement()) {
            return;
        }
        try {
            this.currentLoader.addAttribute(this.currentAttributeName, attributeValue);
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.isIgnoredElement()) {
            return;
        }
        try {
            if (this.currentLoader != null) {
                this.currentLoader.addCharacters(ch, start, length);
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public synchronized void cleanUp() {
        if (this.scanner == null) {
            return;
        }
        try {
            this.scanner.terminateParser();
        }
        catch (Exception e) {
            this.log(e);
        }
        this.scanner = null;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        this.file = null;
        this.error = null;
        this.depth = 0;
        this.startDocument = true;
        this.fragmentsCount = 0;
        ArrayList processed = new ArrayList();
        Iterator iter = this.loaders.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (processed.contains(entry.getValue())) continue;
            ((XMLFragmentLoader)entry.getValue()).cleanUp();
            processed.add(entry.getValue());
        }
        this.loaders.clear();
        if (this.getContext().getGlobalForwardReferences().size() > 0) {
            this.processGlobalForwardReferences();
        }
    }

    public void endDocument(Object object, int i) {
    }

    public void endElement(String elementName, int currentOffset) {
        this.currentElementName = elementName;
        try {
            if (this.currentLoader != null) {
                this.currentLoader.endChild(this.currentElementName);
            }
            --this.depth;
            if (this.depth == 0) {
                this.currentLoader.addYourselfInContext();
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public void error(InvalidXMLException exception) {
        this.error = exception;
        this.error.fillInStackTrace();
    }

    public void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
        if (this.error != null || this.scanner == null) {
            return;
        }
        if (toProfileFile) {
            this.writeToProfileFile(LoadersUtils.makeString(buffer, 0, length));
        } else {
            this.loadEvent(buffer, length, loadToModel);
        }
    }

    public void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException {
        block7: {
            if (this.error != null) {
                if (this.error.getEnclosedException() != null) {
                    LoadersUtils.log(this.error.getEnclosedException());
                }
                return;
            }
            if (this.scanner == null) {
                return;
            }
            if (this.getContext().getAgent() != null && this.getContext().getAgent().eResource() != null && !this.getContext().getAgent().eResource().isModified()) {
                this.getContext().getAgent().eResource().setModified(true);
            }
            this.setLoadToModel(loadToModel);
            try {
                this.scanner.scanContent(buffer, 0, length);
            }
            catch (Exception e) {
                if (this.error != null) break block7;
                this.log(e);
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    public void loadEvent(byte[] buffer, int length) throws InvalidXMLException {
        this.loadEvent(buffer, length, true);
    }

    public void restartParser() {
        if (this.scanner != null) {
            try {
                this.scanner.terminateParser();
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        this.error = null;
        this.startDocument = true;
        this.depth = 0;
        this.makeScanner();
    }

    public void startDocument() {
        this.startDocument = true;
    }

    public void startElement(String elementName, boolean hasAttributes, boolean isEmpty) {
        this.currentElementName = elementName;
        if (this.isIgnoredElement()) {
            return;
        }
        if (this.depth == 0) {
            this.currentLoader = this.getLoader(this.getName(this.currentElementName));
            this.currentLoader.initialize(this.getContext(), this.currentElementName);
            ++this.fragmentsCount;
        } else {
            try {
                this.currentLoader.startChild(this.currentElementName);
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        ++this.depth;
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == null) {
                return true;
            }
            if (this.currentElementName.equals("TRACE") || this.currentElementName.equals("CommonBaseEvents") || this.currentElementName.equals("Statistic")) {
                return true;
            }
            this.startDocument = false;
        }
        return false;
    }

    protected XMLFragmentLoader getLoader(String currentElementName) {
        XMLFragmentLoader loader = (XMLFragmentLoader)this.loaders.get(currentElementName);
        if (loader == null) {
            loader = (XMLFragmentLoader)LoaderExtensions.getInstance().get(currentElementName);
            if (loader != null) {
                try {
                    loader = (XMLFragmentLoader)loader.getClass().newInstance();
                    this.loaders.put(currentElementName, loader);
                    return loader;
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            loader = this.defaultLoader;
        }
        return loader;
    }

    protected String getName(String currentElementName) {
        int column = currentElementName.lastIndexOf(":");
        if (column != -1) {
            return currentElementName.substring(column);
        }
        return currentElementName;
    }

    protected void log(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException spx = (SAXParseException)e;
            System.err.println(spx.getLocalizedMessage());
            System.err.println("at line: " + spx.getLineNumber());
            System.err.println("at column: " + spx.getColumnNumber());
            spx.fillInStackTrace();
            LoadersUtils.log(spx);
        } else {
            LoadersUtils.log(e);
        }
    }

    protected void makeScanner() {
        this.scanner = (XMLFragmentHandler)XMLFragmentHandlerExtensions.getInstance().get("handler");
        if (this.scanner != null) {
            try {
                this.scanner = (XMLFragmentHandler)this.scanner.getClass().newInstance();
                this.scanner.setXMLLoader(this);
            }
            catch (Exception e) {
                this.log(e);
                this.scanner = new SAXFragmentHandler();
                this.scanner.setXMLLoader(this);
            }
        } else {
            this.scanner = new SAXFragmentHandler();
            this.scanner.setXMLLoader(this);
        }
    }

    protected void processGlobalForwardReferences() {
        Iterator iter = this.context.getAgent().getUnresolvedCorrelations().iterator();
        while (iter.hasNext()) {
            UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation)iter.next();
            Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator();
            while (iterator.hasNext()) {
                CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo)iterator.next();
                EObject owner = correlationSourceInfo.getOwner();
                EReference reference = correlationSourceInfo.getReference();
                EObject o = (EObject)LookupServiceExtensions.getInstance().locate(null, reference.getEReferenceType().getInstanceClass(), LoadersUtils.getLookUpKey(unresolvedCorrelation.getContextId()));
                if (o == null) continue;
                if (reference.isMany()) {
                    ((EList)owner.eGet((EStructuralFeature)reference)).add((Object)o);
                } else {
                    owner.eSet((EStructuralFeature)reference, (Object)o);
                }
                iterator.remove();
            }
            if (unresolvedCorrelation.getSourceInfos().size() != 0) continue;
            iter.remove();
        }
    }

    private void setLoadToModel(boolean loadToModel) {
        if (this.context.isLoadToModel() != loadToModel) {
            this.context.setLoadToModel(loadToModel);
        }
    }

    private void addToResource(TRCAgent agent, HierarchyContext context) {
        String monitorFolder = LoadersUtils.getMonitorFolder(context.getMonitor());
        Resource agDoc = null;
        if (agent.getName() == null) {
            agent.setName("unknown");
        }
        String aName = StringUtil.change(context.getMonitor().getName().trim(), " ", "") + "_" + context.getNode().getName().trim() + "_" + context.getProcessProxy().getPid() + "_" + context.getProcessProxy().getRuntimeId() + "_" + StringUtil.change(agent.getName().trim(), " ", "");
        String pFileName = monitorFolder + aName;
        agDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcaxmi")).createResource(SaveUtil.createURI(pFileName + ".trcaxmi"));
        agDoc.setModified(true);
        HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        if (agDoc != null) {
            agDoc.getContents().add((Object)agent);
        }
    }

    private void writeToProfileFile(String xml) {
        if (this.context.getAgentProxy() != null && this.context.getAgentProxy().getProfileFile() != null) {
            try {
                if (this.file == null) {
                    this.file = new FileWriter(this.context.getAgentProxy().getProfileFile());
                }
                this.file.write(xml);
                this.file.flush();
            }
            catch (IOException e) {
                this.error = new InvalidXMLException(e);
                throw this.error;
            }
        }
    }
}

