/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.eclipse.hyades.internal.config.generator.ConfigFile;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.PluginConfigFile;
import org.eclipse.hyades.internal.config.generator.TestJvm;

public class SetConfig {
    protected static ConfigFile conf = null;
    protected static boolean overwrite = false;
    protected static boolean silent = false;
    protected static boolean verify = true;
    private static int size = 100;
    private static String defaultConfigFile = null;
    private static Hashtable hash = new Hashtable(size);
    private static String sr = PlatformObject.sr;

    public static void main(String[] args) {
        if (TestJvm.isMinimumVersion(ConfigUtility.getString("Config.Java.Version"), System.getProperty("java.version"))) {
            SetConfig.doIt(args);
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Msg"));
        }
    }

    protected static void doIt(String[] args) {
        File input;
        Object hostList = null;
        SetConfig.populateHashtable(args);
        if (SetConfig.exist("-help") || SetConfig.exist("-h") || SetConfig.exist("-?")) {
            SetConfig.printHelp();
            return;
        }
        if (SetConfig.exist("-example") || SetConfig.exist("-ex")) {
            SetConfig.printExamples();
            return;
        }
        if (SetConfig.exist("-debug")) {
            Logger.setDebug(true);
        }
        if (SetConfig.exist("-overwrite") || SetConfig.exist("-ovr")) {
            overwrite = true;
        }
        if (SetConfig.exist("-silent") || SetConfig.exist("-s")) {
            silent = true;
        }
        if (SetConfig.exist("-noverify") || SetConfig.exist("-nov")) {
            verify = false;
        }
        if (SetConfig.getValue("RASERVER_HOME") == null) {
            File pwd = new File("..");
            try {
                SetConfig.setValue("RASERVER_HOME", pwd.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!SetConfig.isValidRaserverHome(SetConfig.getValue("RASERVER_HOME"))) {
            if (silent) {
                return;
            }
            SetConfig.setValue("RASERVER_HOME", SetConfig.promptRaserverHome(SetConfig.getValue("RASERVER_HOME")));
        }
        if (!SetConfig.isWritable(defaultConfigFile = new String(SetConfig.getValue("RASERVER_HOME") + sr + "config" + sr + "serviceconfig.xml"))) {
            System.out.println(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + defaultConfigFile);
            return;
        }
        conf = overwrite ? new ConfigFile() : ((input = new File(defaultConfigFile)).exists() ? new ConfigFile(input.getAbsolutePath()) : new ConfigFile());
        conf.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        if (PlatformObject.name.equals("OS/400")) {
            conf.setValue("JAVA_PATH", "/QSYS.LIB/Q5BVAJVM.PGM");
        } else if (silent) {
            if (SetConfig.getValue("JAVA_PATH") == null || SetConfig.getValue("JAVA_PATH").equals("")) {
                if (conf.getValue("JAVA_PATH") == null || conf.getValue("JAVA_PATH").equals("")) {
                    if (SetConfig.isValidJava(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt)) {
                        conf.setValue("JAVA_PATH", System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt);
                    } else {
                        conf.setValue("JAVA_PATH", "%JAVA_PATH%");
                    }
                }
            } else {
                conf.setValue("JAVA_PATH", SetConfig.getValue("JAVA_PATH"));
            }
        } else if (SetConfig.getValue("JAVA_PATH") == null) {
            if (conf.getValue("JAVA_PATH") == null) {
                conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt));
            } else {
                conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(conf.getValue("JAVA_PATH")));
            }
        } else if (SetConfig.isValidJava(SetConfig.getValue("JAVA_PATH"))) {
            conf.setValue("JAVA_PATH", SetConfig.getValue("JAVA_PATH"));
        } else {
            conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(SetConfig.getValue("JAVA_PATH")));
        }
        if (silent) {
            if (SetConfig.getValue("ALLOW") == null) {
                if (conf.getValue("ALLOW") == null) {
                    conf.setValue("ALLOW", "LOCAL");
                }
            } else {
                conf.setValue("ALLOW", SetConfig.getValue("ALLOW"));
            }
        } else if (SetConfig.getValue("ALLOW") == null) {
            if (conf.getValue("ALLOW") == null) {
                conf.setValue("ALLOW", SetConfig.promptAllow("LOCAL"));
            } else {
                conf.setValue("ALLOW", SetConfig.promptAllow(conf.getValue("ALLOW")));
            }
        } else if (SetConfig.isValidAllow(SetConfig.getValue("ALLOW"))) {
            conf.setValue("ALLOW", SetConfig.getValue("ALLOW"));
        } else {
            conf.setValue("ALLOW", SetConfig.promptAllow(SetConfig.getValue("ALLOW")));
        }
        if (conf.getValue("ALLOW").toUpperCase().equals("CUSTOM")) {
            if (silent) {
                if (SetConfig.getValue("HOSTS") == null) {
                    if (conf.getValue("HOSTS") == null) {
                        conf.setValue("HOSTS", "localhost");
                    }
                } else {
                    conf.setValue("HOSTS", SetConfig.getValue("HOSTS"));
                }
            } else if (SetConfig.getValue("HOSTS") == null) {
                if (conf.getValue("HOSTS") == null) {
                    conf.setValue("HOSTS", SetConfig.promptHosts("localhost"));
                } else {
                    conf.setValue("HOSTS", SetConfig.promptHosts(conf.getValue("HOSTS")));
                }
            } else if (SetConfig.isValidHosts(SetConfig.getValue("HOSTS"))) {
                conf.setValue("HOSTS", SetConfig.getValue("HOSTS"));
            } else {
                conf.setValue("HOSTS", SetConfig.promptHosts(SetConfig.getValue("HOSTS")));
            }
        }
        conf.generateConfiguration();
        if (conf != null) {
            conf.saveToFile();
        }
        SetConfig.generatePluginConfigurations();
    }

    private static String promptRaserverHome(String defaultValue) {
        String rc = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.RASERVER_HOME.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidRaserverHome(rc = SetConfig.promptUserInput(defaultValue)));
        return rc;
    }

    private static String promptJavaPath(String defaultValue) {
        String rc = null;
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Unix"));
        }
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidJava(rc = SetConfig.promptUserInput(defaultValue)));
        return rc;
    }

    private static String promptAllow(String defaultValue) {
        String rc = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidAllow(rc = SetConfig.promptUserInput(defaultValue)));
        return rc;
    }

    private static String promptHosts(String defaultValue) {
        System.out.println(ConfigUtility.getString("Config.Prompt.Hosts.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        return SetConfig.promptUserInput(defaultValue);
    }

    protected static String promptUserInput(String defaultValue) {
        String input;
        BufferedReader bReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            input = bReader.readLine();
        }
        catch (IOException e) {
            input = defaultValue;
        }
        if (input.equals("")) {
            input = defaultValue;
        }
        return ConfigUtility.removeTrailings(input);
    }

    private static boolean isValidRaserverHome(String path) {
        if (!verify) {
            return true;
        }
        boolean rc = false;
        if (path == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
            return false;
        }
        File p = new File(path);
        if (p.exists() && p.isDirectory()) {
            if (PlatformObject.name.equals("OS/400")) {
                File f = new File(p.getAbsolutePath() + File.separator + "bin" + File.separator + "SetConfig.sh");
                if (f.exists()) {
                    rc = true;
                }
            } else {
                File f = new File(p.getAbsolutePath() + File.separator + "bin" + File.separator + "RAServer" + PlatformObject.exeExt);
                if (f.exists()) {
                    rc = true;
                }
            }
        }
        if (!rc) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
        }
        return rc;
    }

    private static boolean isValidJava(String path) {
        if (!verify) {
            return true;
        }
        if (path == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
            return false;
        }
        File p = new File(path);
        if (p.exists() && p.isFile()) {
            boolean rc = TestJvm.isSupportedJava(path, ConfigUtility.getString("Config.Java.Version"));
            if (!rc) {
                System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            }
            return rc;
        }
        System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
        return false;
    }

    private static boolean isValidAllow(String allow) {
        if (!verify) {
            return true;
        }
        boolean rc = false;
        if (allow == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
            return false;
        }
        if (allow.toLowerCase().equals("all") || allow.toLowerCase().equals("local") || allow.toLowerCase().equals("custom")) {
            rc = true;
        }
        if (!rc) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
        }
        return rc;
    }

    private static boolean isValidHosts(String hosts) {
        if (!verify) {
            return true;
        }
        return hosts != null;
    }

    private static boolean isWritable(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f.canWrite();
        }
        return f.getParentFile().canWrite();
    }

    protected static boolean exist(String tag) {
        return hash.containsKey(tag);
    }

    protected static String getValue(String tag) {
        if (hash.containsKey(tag)) {
            return (String)hash.get(tag);
        }
        return null;
    }

    protected static void setValue(String tag, String value) {
        hash.put(tag, value);
    }

    protected static void removeKey(String tag) {
        hash.remove(tag);
    }

    private static void populateHashtable(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                int eq = args[i].indexOf(61);
                if (eq == -1) {
                    SetConfig.setValue(args[i], "");
                    continue;
                }
                String name = SetConfig.trim(args[i].substring(0, eq));
                String value = SetConfig.trim(args[i].substring(eq + 1));
                if (name == null || value == null) continue;
                SetConfig.setValue(name, value);
            }
        }
    }

    private static String trim(String str) {
        int start;
        if (str == null || str.length() == 0) {
            return null;
        }
        int end = str.length() - 1;
        for (start = 0; start < end && (str.charAt(start) == ' ' || str.charAt(start) == '\"' || str.charAt(start) == '\''); ++start) {
        }
        while (end > start && (str.charAt(end) == ' ' || str.charAt(end) == '\"' || str.charAt(end) == '\'')) {
            --end;
        }
        if (start != end) {
            return str.substring(start, end + 1);
        }
        return null;
    }

    private static void printHelp() {
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Cmd.Flags"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Help.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Help.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Silent.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Silent.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.NoVerify.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.NoVerify.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Examples.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Examples.Msg"));
        System.out.println();
        System.out.println(ConfigUtility.getString("Config.Cmd.Params"));
        System.out.println(ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.JAVA_PATH.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.JAVA_PATH.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.ALLOW.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.ALLOW.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.HOSTS.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.HOSTS.Msg"));
    }

    private static void printExamples() {
        System.out.println(ConfigUtility.getString("Config.Example.Tag"));
        System.out.println(ConfigUtility.getString("Config.Example.Example1.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example2.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example3.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example4.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Unix"));
        }
    }

    protected static void generatePluginConfigurations() {
        SetConfig.generateDatacollectionConfiguration();
        SetConfig.generateParsersConfiguration();
        SetConfig.generateTestConfiguration();
    }

    private static void generateDatacollectionConfiguration() {
        String name = "org.eclipse.hyades.datacollection";
        String f = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfig = null;
        File input = new File(f);
        pluginConfig = input.exists() && !overwrite ? new PluginConfigFile(input.getAbsolutePath()) : new PluginConfigFile();
        pluginConfig.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfig.generateConfiguration_datacollection(name);
    }

    private static void generateParsersConfiguration() {
        String name = "org.eclipse.hyades.logging.parsers";
        String f = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfig = null;
        File input = new File(f);
        pluginConfig = input.exists() && !overwrite ? new PluginConfigFile(input.getAbsolutePath()) : new PluginConfigFile();
        pluginConfig.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfig.generateConfiguration_parsers(name);
    }

    private static void generateTestConfiguration() {
        String name = "org.eclipse.hyades.test";
        String f = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfig = null;
        File input = new File(f);
        pluginConfig = input.exists() && !overwrite ? new PluginConfigFile(input.getAbsolutePath()) : new PluginConfigFile();
        pluginConfig.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfig.generateConfiguration_test(name);
    }
}

