/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.AgentProxyContext;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.GenericLookUpEntry;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.InvalidPassword;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class LoadersUtils {
    private static final Map threads = new HashMap();
    private static SimpleDateFormat partialCIMDateFormatDashDelimiter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss");
    private static SimpleDateFormat partialCIMDateFormatPlusDelimiter = new SimpleDateFormat("yyyy'+'MM'+'dd'T'HH:mm:ss");
    private static SimpleDateFormat partialCIMDateFormatNoDelimiter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final char[] SCRAMBLING_TABLE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', 'r', 'x', '5', 'O', '`', 'm', 'H', 'l', 'F', '@', 'L', 'C', 't', 'J', 'D', 'W', 'o', '4', 'K', 'w', '1', '\"', 'R', 'Q', '_', 'A', 'p', 'V', 'v', 'n', 'z', 'i', ')', '9', 'S', '+', '.', 'f', '(', 'Y', '&', 'g', '-', '2', '*', '{', '[', '#', '}', '7', '6', 'B', '|', '~', ';', '/', '\\', 'G', 's', 'N', 'X', 'k', 'j', '8', '$', 'y', 'u', 'h', 'e', 'd', 'E', 'I', 'c', '?', '^', ']', '\'', '%', '=', '0', ':', 'q', ' ', 'Z', ',', 'b', '<', '3', '!', 'a', '>', 'M', 'T', 'P', 'U', '\u00df', '\u00e1', '\u00d8', '\u00bb', '\u00a6', '\u00e5', '\u00bd', '\u00de', '\u00bc', '\u008d', '\u00f9', '\u0094', '\u00c8', '\u00b8', '\u0088', '\u00f8', '\u00be', '\u00c7', '\u00aa', '\u00b5', '\u00cc', '\u008a', '\u00e8', '\u00da', '\u00b7', '\u00ff', '\u00ea', '\u00dc', '\u00f7', '\u00d5', '\u00cb', '\u00e2', '\u00c1', '\u00ae', '\u00ac', '\u00e4', '\u00fc', '\u00d9', '\u00c9', '\u0083', '\u00e6', '\u00c5', '\u00d3', '\u0091', '\u00ee', '\u00a1', '\u00b3', '\u00a0', '\u00d4', '\u00cf', '\u00dd', '\u00fe', '\u00ad', '\u00ca', '\u0092', '\u00e0', '\u0097', '\u008c', '\u00c4', '\u00cd', '\u0082', '\u0087', '\u0085', '\u008f', '\u00f6', '\u00c0', '\u009f', '\u00f4', '\u00ef', '\u00b9', '\u00a8', '\u00d7', '\u0090', '\u008b', '\u00a5', '\u00b4', '\u009d', '\u0093', '\u00ba', '\u00d6', '\u00b0', '\u00e3', '\u00e7', '\u00db', '\u00a9', '\u00af', '\u009c', '\u00ce', '\u00c6', '\u0081', '\u00a4', '\u0096', '\u00d2', '\u009a', '\u00b1', '\u0086', '\u007f', '\u00b6', '\u0080', '\u009e', '\u00d0', '\u00a2', '\u0084', '\u00a7', '\u00d1', '\u0095', '\u00f1', '\u0099', '\u00fb', '\u00ed', '\u00ec', '\u00ab', '\u00c3', '\u00f3', '\u00e9', '\u00fd', '\u00f0', '\u00c2', '\u00fa', '\u00bf', '\u009b', '\u008e', '\u0089', '\u00f5', '\u00eb', '\u00a3', '\u00f2', '\u00b2', '\u0098'};
    private static char[] RESTORING_TABLE = null;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentProxyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$HierarchyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentsContext;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$impl$CorrelationEngineImpl;

    public static void setDefaultContext(HierarchyContext context) {
        String monitorFolder;
        TRCMonitor monitor = context.getMonitor();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        if (node == null) {
            node = LoadersUtils.locateNodeFromMonitor(monitor, "Unknown", "0", "0");
            if (node == null) {
                monitorFolder = LoadersUtils.getMonitorFolder(monitor);
                Resource nDoc = null;
                if (monitorFolder != null) {
                    String nName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + "Unknown";
                    String nodeFileName = monitorFolder + nName;
                    nDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(nodeFileName + ".trcnxmi")).createResource(SaveUtil.createURI(nodeFileName + ".trcnxmi"));
                    HierarchyResourceSetImpl.getInstance().getResources().add((Object)nDoc);
                }
                node = HierarchyFactory.eINSTANCE.createTRCNode();
                node.setIpAddress("0");
                node.setRuntimeId("0");
                node.setName("Unknown");
                monitor.getNodes().add((Object)node);
                node.setMonitor(monitor);
                context.setNode(node);
                if (nDoc != null) {
                    nDoc.getContents().add((Object)node);
                    nDoc.setModified(true);
                }
            }
            context.setNode(node);
        }
        if (process == null) {
            process = LoadersUtils.locateProcessFromNode(node, "0");
            if (process != null) {
                context.setProcessProxy(process);
                return;
            }
            monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;
            if (monitorFolder != null) {
                String pName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + node.getName().trim() + "_" + "-1" + "_" + "0";
                String pFileName = monitorFolder + pName;
                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcpxmi")).createResource(SaveUtil.createURI(pFileName + ".trcpxmi"));
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)procDoc);
            }
            process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            node.getProcessProxies().add((Object)process);
            process.setNode(node);
            process.setPid(-1);
            process.setRuntimeId("0");
            process.setName("Unknown");
            context.setProcessProxy(process);
            if (procDoc != null) {
                procDoc.getContents().add((Object)process);
                procDoc.setModified(true);
            }
        }
    }

    public static short getDeltaTimeZoneInMinutesFromCIMFormat(String creationTime) throws IllegalArgumentException {
        int creationTimeLength = creationTime.length();
        short timeZoneOffset = 0;
        if (creationTime.charAt(creationTimeLength - 1) != 'Z') {
            try {
                timeZoneOffset = Short.parseShort(creationTime.substring(creationTimeLength - 5, creationTimeLength - 3));
                timeZoneOffset = (short)(timeZoneOffset * 60);
                timeZoneOffset = (short)(timeZoneOffset + Short.parseShort(creationTime.substring(creationTimeLength - 2)));
                if (creationTime.charAt(creationTimeLength - 6) == '-') {
                    timeZoneOffset = (short)(timeZoneOffset * -1);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid parameter time stamp format.");
            }
        }
        return timeZoneOffset;
    }

    public static double getMicrosecondsFromCIMFormat(String creationTime) throws IllegalArgumentException {
        double creationTimeInMicros = 0.0;
        int tCharIndex = creationTime.indexOf(84);
        if (tCharIndex != -1) {
            try {
                creationTimeInMicros = (double)partialCIMDateFormatDashDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
            }
            catch (ParseException p) {
                try {
                    creationTimeInMicros = creationTime.charAt(tCharIndex - 3) == '+' ? (double)partialCIMDateFormatPlusDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0 : (double)partialCIMDateFormatNoDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
                }
                catch (ParseException pp) {
                    throw new IllegalArgumentException("Invalid parameter time stamp format.");
                }
            }
            creationTimeInMicros -= (double)LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat(creationTime) * 6.0E7;
            try {
                creationTimeInMicros += Double.parseDouble("0.".concat(creationTime.substring(tCharIndex + 10, creationTime.endsWith("Z") ? creationTime.length() - 1 : creationTime.length() - 6))) * 1000000.0;
            }
            catch (Exception e) {}
        } else {
            throw new IllegalArgumentException("Invalid parameter time stamp format.");
        }
        return creationTimeInMicros;
    }

    public static String getMonitorFolder(TRCMonitor monitor) {
        if (monitor == null) {
            return null;
        }
        Resource res = monitor.eResource();
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        int index = (uri = uri.replace('\\', '/')).lastIndexOf("/");
        if (index >= 0) {
            uri = uri.substring(0, index);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    public static SimpleDateFormat getPartialCIMDateFormat() {
        return LoadersUtils.getPartialCIMDateFormatDashDelimiter();
    }

    public static SimpleDateFormat getPartialCIMDateFormatDashDelimiter() {
        return partialCIMDateFormatDashDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatPlusDelimiter() {
        return partialCIMDateFormatPlusDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatNoDelimiter() {
        return partialCIMDateFormatNoDelimiter;
    }

    public static double convertCreationTime(String value) {
        return LoadersUtils.getMicrosecondsFromCIMFormat(value);
    }

    public static TRCAgent getOrCreateAgent(HierarchyContext context) {
        TRCAgent agent = context.getAgent();
        if (agent == null) {
            agent = LoadersUtils.createAgent(context);
        }
        return agent;
    }

    public static TRCAgent createAgent(HierarchyContext context) {
        LoadersUtils.setDefaultContext(context);
        TRCAgent agent = context.getAgent();
        TRCAgentProxy agentProxy = context.getAgentProxy();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        TRCMonitor monitor = context.getMonitor();
        String agentName = "Unknown";
        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;
        double startTime = (double)new Date().getTime() / 1000.0;
        if (monitorFolder != null) {
            String aName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(agentName.trim(), " ", "");
            String pFileName = monitorFolder + aName;
            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcaxmi")).createResource(SaveUtil.createURI(pFileName + ".trcaxmi"));
            agDoc.setModified(true);
            HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        }
        agent = HierarchyFactory.eINSTANCE.createTRCAgent();
        if (agentProxy == null) {
            agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
            agentProxy.setRuntimeId("" + startTime);
            agent.setRuntimeId("" + startTime);
            agent.setName(agentName);
            agentProxy.setName(agentName);
            agent.setType("Logging");
            agentProxy.setType("Logging");
            agent.setStartTime(startTime);
            agentProxy.setStartTime(startTime);
            agent.setAgentProxy(agentProxy);
            agentProxy.setProcessProxy(process);
            agent.setCollectionMode(context.getCollectionMode());
            agentProxy.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
            context.setAgentProxy(agentProxy);
        } else {
            agent.setRuntimeId(agentProxy.getRuntimeId());
            agent.setName(agentProxy.getName());
            if (agentProxy.getType() != null) {
                agent.setType(agentProxy.getType());
            } else {
                agent.setType("Logging");
                agentProxy.setType("Logging");
            }
            agent.setStartTime(agentProxy.getStartTime());
            agent.setAgentProxy(agentProxy);
            agent.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
        }
        if (context.getContextURI() == null) {
            context.setContextURI(agDoc.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, context);
        }
        if (agDoc != null) {
            agDoc.getContents().add((Object)agent);
            agDoc.setModified(true);
        }
        return agent;
    }

    public static void deregisterAgentInstance(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentInstance(null);
        }
    }

    public static void deregisterAgentListener(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentListener(null);
        }
    }

    public static void deregisterAgentProxyContext(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            LookupServiceExtensions.getInstance().deregister(null, c);
        }
    }

    public static void deregisterDataProcessor(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setDataProcessor(null);
        }
    }

    public static TRCAgent locateAgentFromMonitor(TRCMonitor monitor, String agentRId) {
        EList nodeList = monitor.getNodes();
        Iterator nodeIterator = nodeList.iterator();
        while (nodeIterator.hasNext()) {
            TRCNode node = (TRCNode)nodeIterator.next();
            if (node.eIsProxy()) continue;
            EList processList = node.getProcessProxies();
            Iterator processIterator = processList.iterator();
            while (processIterator.hasNext()) {
                TRCProcessProxy process = (TRCProcessProxy)processIterator.next();
                if (process.eIsProxy()) continue;
                EList agents = process.getAgentProxies();
                Iterator agentIterator = agents.iterator();
                while (agentIterator.hasNext()) {
                    TRCAgentProxy agent = (TRCAgentProxy)agentIterator.next();
                    if (agent.eIsProxy() || agent.getRuntimeId() == null || !agent.getRuntimeId().equals(agentRId)) continue;
                    return agent.getAgent();
                }
            }
        }
        return null;
    }

    public static TRCAgent locateAgentFromProcess(TRCProcessProxy process, String aName, String agentRId) {
        EList agents = process.getAgentProxies();
        Iterator i = agents.iterator();
        while (i.hasNext()) {
            TRCAgentProxy agent = (TRCAgentProxy)i.next();
            if (agent.eIsProxy() || agent.getName() == null || !agent.getName().equals(aName) || agent.getRuntimeId() != null && !agent.getRuntimeId().equals("") && !agent.getRuntimeId().equals(agentRId)) continue;
            return agent.getAgent();
        }
        return null;
    }

    public static Object locateAgentInstance(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getAgentInstance();
        }
        return null;
    }

    public static Object locateAgentListener(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getAgentListener();
        }
        return null;
    }

    public static XMLLoader locateDataProcessor(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getDataProcessor();
        }
        return null;
    }

    public static HierarchyContext locateHierarchyContext(TRCAgent agent) {
        HierarchyContext context = null;
        if (agent.eResource() != null) {
            context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, agent.eResource().getURI().toString());
        }
        if (context == null) {
            context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, agent.getRuntimeId());
        }
        return context;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TRCNode locateNodeFromMonitor(TRCMonitor monitor, String hostName, String ipaddr, String nRId) {
        EList list = monitor.getNodes();
        Iterator i = list.iterator();
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            while (i.hasNext()) {
                TRCNode node = (TRCNode)i.next();
                if (node.eIsProxy()) continue;
                String name = node.getName();
                try {
                    InetAddress naddr = InetAddress.getByName(name);
                    if (!addr.equals(naddr)) continue;
                    return node;
                }
                catch (UnknownHostException exc) {
                    String ipaddress = node.getIpAddress();
                    if (!name.equals(hostName) && (ipaddress == null || !ipaddress.equals(ipaddr))) continue;
                    node.setIpAddress(ipaddr);
                    node.setRuntimeId(nRId);
                    return node;
                    return null;
                }
            }
        }
        catch (UnknownHostException exc) {
            while (i.hasNext()) {
                TRCNode node = (TRCNode)i.next();
                String name = node.getName();
                String ipaddress = node.getIpAddress();
                if ((name == null || hostName == null || !name.equals(hostName)) && (ipaddress == null || !ipaddress.equals(ipaddr))) continue;
                node.setIpAddress(ipaddr);
                node.setRuntimeId(nRId);
                return node;
            }
        }
        return null;
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode node, String pRId) {
        EList processList = node.getProcessProxies();
        Iterator i = processList.iterator();
        while (i.hasNext()) {
            TRCProcessProxy process = (TRCProcessProxy)i.next();
            if (process.eIsProxy() || process.getRuntimeId() == null || process.getRuntimeId().compareTo(pRId) != 0) continue;
            return process;
        }
        return null;
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode node, int pId, String pRId) {
        EList processList = node.getProcessProxies();
        Iterator i = processList.iterator();
        while (i.hasNext()) {
            String runtimeId;
            int processId;
            TRCProcessProxy process = (TRCProcessProxy)i.next();
            if (process.eIsProxy() || (processId = process.getPid()) != pId || (runtimeId = process.getRuntimeId()) != null && !runtimeId.equals("") && !runtimeId.equals(pRId)) continue;
            process.setRuntimeId(pRId);
            return process;
        }
        return null;
    }

    public static void log(Throwable e) {
        LoadersUtils.log(e, null);
    }

    public static void log(Throwable e, String msg) {
        System.err.print(Thread.currentThread() + " - ");
        if (e == null) {
            System.err.println(" null Throwable");
            return;
        }
        if (msg != null) {
            System.err.print(msg + ": ");
        }
        e.printStackTrace(System.err);
    }

    public static void log(String s) {
        System.err.println(Thread.currentThread() + " - " + s);
    }

    public static String makeString(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, offset, length, "UTF8");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void registerAgentInstance(TRCAgentProxy agentProxy, Object ai) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentInstance(ai);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setAgentInstance(ai);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void registerAgentListener(TRCAgentProxy agentProxy, Object al) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentListener(al);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setAgentListener(al);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void registerDataProcessor(TRCAgentProxy agentProxy, XMLLoader processor) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentProxyContext == null ? (class$org$eclipse$hyades$loaders$util$AgentProxyContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentProxyContext")) : class$org$eclipse$hyades$loaders$util$AgentProxyContext, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setDataProcessor(processor);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setDataProcessor(processor);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void loadRootEvent(XMLLoader processor) {
        processor.loadEvent("<TRACE>".getBytes(), "<TRACE>".getBytes().length);
    }

    public static TRCAgent locateAgent(String agentIdRef, TRCAgent agent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(agentIdRef));
        if (agentsContext != null) {
            return agentsContext.getActiveAgent(agent);
        }
        return null;
    }

    public static boolean registerAgent(String agentIdRef, TRCAgent agent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = LoadersUtils.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(agentIdRef));
        if (agentsContext == null) {
            agentsContext = new AgentsContext(agentIdRef);
            LookupServiceExtensions.getInstance().register(null, agentsContext);
        }
        return agentsContext.registerAgent(agent);
    }

    public static Object getLookUpKey(int key) {
        return new Integer(key);
    }

    public static Object getLookUpKey(long key) {
        return new Long(key);
    }

    public static Object getLookUpKey(short key) {
        return new Short(key);
    }

    public static Object getLookUpKey(String key) {
        if (key == null) {
            return new Integer(0);
        }
        return new Integer(key.hashCode());
    }

    public static GenericLookUpEntry getGenericLookUpEntry(Thread thread) {
        Integer key = new Integer(thread.hashCode());
        GenericLookUpEntry entry = (GenericLookUpEntry)threads.get(key);
        if (entry == null) {
            entry = new GenericLookUpEntry();
            threads.put(key, entry);
        }
        return entry;
    }

    public static void registerGenericLookUpEntry(HierarchyContext context, Object key, Object value) {
        GenericLookUpEntry entry = LoadersUtils.getGenericLookUpEntry(Thread.currentThread());
        entry.setKey(key);
        entry.setValue(value);
        LookupServiceExtensions.getInstance().register(context, entry);
        entry.reset();
    }

    public static int getHashCode(byte[] data, int offset, int length) {
        int h = 0;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + data[offset + i];
        }
        return h;
    }

    public static int getHashCode(String value) {
        int h = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + value.charAt(i);
        }
        return h;
    }

    public static void setSessionStartTime(double time, TRCAgentProxy agentProxy) {
        TRCAgent agent;
        if (agentProxy == null) {
            return;
        }
        if (!agentProxy.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StartTime())) {
            agentProxy.setStartTime(time);
        }
        if ((agent = agentProxy.getAgent()) != null && !agent.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_StartTime())) {
            agent.setStartTime(time);
        }
    }

    public static CorrelationEngine findCorrelationEngine(String string) {
        return (CorrelationEngine)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$models$hierarchy$impl$CorrelationEngineImpl == null ? (class$org$eclipse$hyades$models$hierarchy$impl$CorrelationEngineImpl = LoadersUtils.class$("org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl")) : class$org$eclipse$hyades$models$hierarchy$impl$CorrelationEngineImpl, string);
    }

    public static void addCorrelationEngine(CorrelationEngine correlationEngine) {
        Resource resource = HierarchyResourceSetImpl.getInstance().getResource(URI.createURI((String)"http://www.eclipse.org/hyades/correlations.xmi"), false);
        resource.getContents().add((Object)correlationEngine);
    }

    public static CorrelationContainerProxy getInternalCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID) {
        URI internalCorrelationURI = LoadersUtils.createCorrelationContainerURI(agentProxy, correlationEngineID, "internalcc");
        Iterator iter = agentProxy.getInternalCorrelations().iterator();
        while (iter.hasNext()) {
            CorrelationContainerProxy correlationContainerProxy = (CorrelationContainerProxy)iter.next();
            CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
            if (correlationContainer != null) {
                URI ccURI;
                URI uRI = ccURI = correlationContainer.eIsProxy() ? ((InternalEObject)correlationContainer).eProxyURI() : correlationContainer.eResource().getURI();
                if (correlationContainerProxy.eIsProxy() || !ccURI.equals((Object)internalCorrelationURI)) continue;
                return correlationContainerProxy;
            }
            correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
            correlationContainer.setCorrelationContainerProxy(correlationContainerProxy);
            LoadersUtils.createCorrelationContainerResource(agentProxy, correlationEngineID, correlationContainer, "internalcc");
            return correlationContainerProxy;
        }
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        agentProxy.getInternalCorrelations().add((Object)correlationContainerProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName("InternalCorrelation_" + correlationEngineID);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().eResource().setModified(true);
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        return correlationContainerProxy;
    }

    public static CorrelationContainerProxy getCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag) {
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        CorrelationContainer correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
        correlationContainer.setCorrelationContainerProxy(correlationContainerProxy);
        LoadersUtils.createCorrelationContainerResource(agentProxy, correlationEngineID, correlationContainer, correlationTag);
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName(correlationTag + "_" + correlationEngineID);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        return correlationContainerProxy;
    }

    public static CorrelationContainerProxy getSQLCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag) {
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        CorrelationContainer correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
        URI agentURI = EcoreUtil.getURI((EObject)((TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)));
        String agentPostfix = LoadersUtils.getPostfix(agentURI);
        String ccPostfix = LoadersUtils.getCorrelationNamePostfix();
        String ccs = StringUtil.change(agentURI.toString(), agentPostfix, "_" + correlationTag + "-" + correlationEngineID + ccPostfix);
        URI correlationContainerResourceURI = URI.createURI((String)LoadersUtils.getContainerResourceURI(ccs));
        Resource ccr = HierarchyResourceSetImpl.getInstance().createResource(correlationContainerResourceURI);
        ccr.getContents().add((Object)correlationContainer);
        correlationContainerProxy.setCorrelationContainer(correlationContainer);
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName(correlationTag + "_" + correlationEngineID);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        correlationContainerProxy.setName(correlationTag);
        return correlationContainerProxy;
    }

    private static String getContainerResourceURI(String uri) {
        int i = uri.indexOf(35);
        if (i != -1) {
            uri = uri.substring(0, i);
        }
        return uri;
    }

    public static String getCorrelationNamePostfix() {
        String res = null;
        Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
        String activeDBType = store.getString("largeResourceSupportCurrentDBType");
        Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) continue;
            IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
            String postfix = (String)entry.getKey();
            if (!postfix.endsWith(".corrdb") || !hyadesResourceFactory.getStoreType(postfix).equals(activeDBType)) continue;
            return postfix;
        }
        if (res == null) {
            res = ".corrxmi";
        }
        return res;
    }

    public static URI createCorrelationContainerURI(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag) {
        URI internalCorrelationURI = agentProxy.getAgent().eResource().getURI();
        return LoadersUtils.createCorrelationContainerURI(internalCorrelationURI, correlationEngineID, correlationTag);
    }

    public static URI createCorrelationContainerURI(URI agentURI, String correlationEngineID, String correlationTag) {
        URI internalCorrelationURI = agentURI;
        internalCorrelationURI = internalCorrelationURI.trimFileExtension();
        String lastSegment = internalCorrelationURI.lastSegment() + "_" + (correlationTag + "-" + correlationEngineID + "-" + new Date().getTime()).hashCode();
        internalCorrelationURI = internalCorrelationURI.trimSegments(1);
        internalCorrelationURI = internalCorrelationURI.appendSegment(lastSegment);
        internalCorrelationURI = internalCorrelationURI.appendFileExtension("corrxmi");
        return internalCorrelationURI;
    }

    public static void createCorrelationContainerResource(TRCAgentProxy proxy, String correlationEngineID, CorrelationContainer container, String correlationTag) {
        URI internalCorrelationURI = LoadersUtils.createCorrelationContainerURI(proxy, correlationEngineID, correlationTag);
        Resource resource = HierarchyResourceSetImpl.getInstance().createResource(internalCorrelationURI);
        resource.setModified(true);
        resource.getContents().add((Object)container);
    }

    public static String getPostfix(URI uri) {
        String postfix = uri.toString();
        return LoadersUtils.getPostfix(postfix);
    }

    public static String getPostfix(String uri) {
        int fragmentIndex;
        String postfix = uri.toString();
        int index = postfix.lastIndexOf("__");
        postfix = index > 0 ? ((fragmentIndex = postfix.indexOf("#/", index)) > 0 ? postfix.substring(index, fragmentIndex) : postfix.substring(index)) : postfix.substring(postfix.lastIndexOf(46));
        return postfix;
    }

    public static String scramblePassword(String password) throws InvalidPassword {
        int length = password.length();
        char[] out = new char[length];
        for (int i = 0; i < length; ++i) {
            char value = password.charAt(i);
            if (value < '\u0000' || value > '\u00ff') {
                throw new InvalidPassword(password);
            }
            out[i] = SCRAMBLING_TABLE[value];
        }
        return "A" + new String(out);
    }

    private static final void resetRESTORINGTALBE() {
        if (RESTORING_TABLE != null) {
            return;
        }
        RESTORING_TABLE = new char[256];
        for (int i = 0; i < 256; ++i) {
            char value = SCRAMBLING_TABLE[i];
            LoadersUtils.RESTORING_TABLE[value] = (char)i;
        }
    }

    public static String restorePassword(String password) throws InvalidPassword {
        LoadersUtils.resetRESTORINGTALBE();
        int length = password.length();
        if (length == 0) {
            return "";
        }
        char[] out = new char[length - 1];
        for (int i = 1; i < length; ++i) {
            char value = password.charAt(i);
            if (value < '\u0000' || value > '\u00ff') {
                throw new InvalidPassword(password);
            }
            out[i - 1] = RESTORING_TABLE[value];
        }
        return new String(out);
    }

    public static String toString(String[] statements) {
        StringBuffer res = new StringBuffer();
        if (statements != null) {
            res.append('[');
            boolean first = true;
            for (int i = 0; i < statements.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    res.append(",\n");
                }
                res.append(statements[i]);
            }
            res.append(']');
        }
        return res.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

