/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateablePathClassLoader
extends ClassLoader {
    public UpdateablePathClassLoader(ClassLoader parent) {
        super(parent);
    }

    public UpdateablePathClassLoader() {
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringTokenizer tokenizer = this.getSearchPathTokens();
        String searchName = name.replace('.', File.separatorChar);
        File classFile = null;
        while (tokenizer.hasMoreTokens()) {
            StringBuffer buf = new StringBuffer(tokenizer.nextToken());
            buf.append(File.separatorChar);
            buf.append(searchName);
            buf.append(".class");
            classFile = new File(buf.toString());
            if (!classFile.exists()) continue;
            break;
        }
        if (!classFile.exists()) {
            throw new ClassNotFoundException(name);
        }
        FileInputStream fis = null;
        byte[] classBytes = null;
        try {
            fis = new FileInputStream(classFile);
            classBytes = new byte[fis.available()];
            fis.read(classBytes);
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException("Could not open input file: \"" + classFile.getPath() + "\"");
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Could not read '.class' file: \"" + classFile.getPath() + "\"");
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    protected URL findResource(String name) {
        URL resourceURL = null;
        StringTokenizer tokenizer = this.getSearchPathTokens();
        File resourceFile = null;
        while (tokenizer.hasMoreTokens()) {
            StringBuffer buf = new StringBuffer(tokenizer.nextToken());
            buf.append(File.separatorChar);
            buf.append(name);
            resourceFile = new File(buf.toString());
            if (!resourceFile.exists()) continue;
            break;
        }
        try {
            if (resourceFile.exists()) {
                resourceURL = resourceFile.toURL();
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Could not find resource \"" + name + "\"\n" + e);
        }
        return resourceURL;
    }

    protected Enumeration findResources(String name) throws IOException {
        Vector<URL> resourceURLs = new Vector<URL>();
        StringTokenizer tokenizer = this.getSearchPathTokens();
        File resourceFile = null;
        while (tokenizer.hasMoreTokens()) {
            StringBuffer buf = new StringBuffer(tokenizer.nextToken());
            buf.append(File.separatorChar);
            buf.append(name);
            resourceFile = new File(buf.toString());
            if (!resourceFile.exists()) continue;
            try {
                resourceURLs.add(resourceFile.toURL());
            }
            catch (MalformedURLException e) {
                System.err.println("Could not find resource \"" + name + "\"\n" + e);
            }
        }
        return resourceURLs.elements();
    }

    private StringTokenizer getSearchPathTokens() {
        String classpath = System.getProperty("java.class.path", ".");
        return new StringTokenizer(classpath, File.pathSeparator);
    }
}

