/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public class RemoteLogParserLoader {
    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.Log", "org.eclipse.hyades.logging.commons.Logger");
        Log logger = null;
        long maxWaitTimeInMillis = 300000L;
        try {
            maxWaitTimeInMillis = Long.parseLong(System.getProperty("org.eclipse.hyades.logging.parsers.maxWaitTimeInMillis"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            logger = LogFactory.getLog((String)"Remote Log Loader IRemoteEntity");
            int parameterNum = args.length;
            if (parameterNum == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_PARAMETER_ERROR_"));
            }
            int parameterIndex = 0;
            if (args[parameterIndex].trim().equals("com.ibm.etools.logging.parsers.RemoteLogParserLoader")) {
                ++parameterIndex;
            }
            String parserClassName = null;
            if (parameterNum <= parameterIndex) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CLASSNAME_PARAMETER_ERROR_"));
            }
            parserClassName = args[parameterIndex];
            if (parameterNum <= ++parameterIndex) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
            }
            Hashtable<String, String> parserParameters = new Hashtable<String, String>();
            String keyValuePair = null;
            int equalsSignIndex = -1;
            while (parameterNum > parameterIndex) {
                if ((equalsSignIndex = (keyValuePair = args[parameterIndex++]).indexOf(61)) == -1) continue;
                parserParameters.put(keyValuePair.substring(0, equalsSignIndex), keyValuePair.substring(equalsSignIndex + 1));
            }
            if (parserParameters.isEmpty()) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
            }
            if (logger instanceof IPreemptedLogger) {
                ((IPreemptedLogger)logger).waitUntilLogging(maxWaitTimeInMillis);
                if (!((IPreemptedLogger)logger).isLogging()) {
                    throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_MONITORING_ERROR_", parserClassName, String.valueOf((double)maxWaitTimeInMillis / 1000.0)));
                }
            }
            try {
                if (logger instanceof Logger) {
                    ((Logger)logger).setLevel(0);
                }
                Class<?> parserClass = Class.forName(parserClassName);
                Object parser = parserClass.newInstance();
                parserClass.getMethod("setUserInput", parserParameters.getClass()).invoke(parser, parserParameters);
                parserClass.getMethod("parse", Class.forName("org.apache.commons.logging.Log")).invoke(parser, logger);
            }
            catch (InvocationTargetException i) {
                throw new LogParserException(i.getTargetException().getMessage());
            }
            catch (Throwable t) {
                throw new LogParserException(ParserUtilities.getResourceString("REMOTE_LOG_PARSER_INITIALIZATION_ERROR_", parserClassName));
            }
        }
        catch (Throwable t) {
            LoggingAgent errorLogger = new LoggingAgent("Remote Log Loader Error IRemoteEntity");
            errorLogger.waitUntilLogging(maxWaitTimeInMillis);
            if (errorLogger.isLogging()) {
                errorLogger.write(t.getMessage());
            } else {
                System.err.println(t.getMessage());
            }
            errorLogger.deregister();
        }
        if (logger != null && logger instanceof IPreemptedLogger) {
            ((IPreemptedLogger)logger).finalize();
        }
    }
}

