/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.MonitoringParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractAccessLogParser
extends MonitoringParser {
    protected String clientIP = null;
    protected String method = null;
    protected String fileName = null;
    protected String returnCode = null;
    protected String fileSize = null;
    protected String userID = null;
    protected String userAgent = null;
    protected String referer = null;
    protected String message = null;
    protected StringBuffer currentTimeStamp = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = "";
    private long duplicateTimeStampCounter = 0L;

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] temp = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0) {
                    if (this.parseLogRecord()) {
                        if (this.cgiDebuggingOutput.length() > 0) {
                            this.createCGIDebuggingOutputCBE();
                            ++this.arrayIndex;
                            if (this.arrayIndex == this.MessageArraySize) {
                                this.increaseMsgArraySize();
                            }
                            ++this.recordCount;
                        }
                        this.reinitializeCBE();
                        if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                            this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                        } else {
                            this.previousTimeStamp = this.currentTimeStamp.toString();
                            this.duplicateTimeStampCounter = 0L;
                        }
                        this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                        if (this.message.length() > 1024) {
                            this.messages[this.arrayIndex].setMsg(this.message.substring(0, 1024));
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("message", this.message));
                        } else {
                            this.messages[this.arrayIndex].setMsg(this.message);
                        }
                        this.determineSeverity(this.messages[this.arrayIndex]);
                        if (this.method != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("method", this.method));
                        }
                        if (this.clientIP != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                        }
                        if (this.fileName != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                        }
                        if (this.returnCode != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("return_code", this.returnCode));
                        }
                        if (this.fileSize != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file_size", this.fileSize));
                        }
                        if (this.userID != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("userid", this.userID));
                        }
                        if (this.referer != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("referer", this.referer));
                        }
                        if (this.userAgent != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("userAgent", this.userAgent));
                        }
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.arrayIndex = 0;
                            ++this.recordCount;
                            this.reset();
                            return this.messages;
                        }
                        ++this.recordCount;
                        this.reset();
                    } else {
                        this.cgiDebuggingOutput.append(this.curLine);
                        this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
                    }
                }
                this.curLine = this.readLine();
            }
            if (this.cgiDebuggingOutput.length() > 0) {
                if (this.recordCount == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString("INVALID_ACCESS_LOG_ERROR_", this.file_path));
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                this.cgiDebuggingOutput = new StringBuffer();
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                temp = null;
                this.setEndOfFile();
            } else {
                int i = this.arrayIndex;
                while (i < this.MessageArraySize) {
                    this.messages[i] = null;
                    ++i;
                }
                temp = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException l) {
            throw l;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"));
        }
        return temp;
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification sourceComponentID = Parser.eventFactory.createComponentIdentification();
        sourceComponentID.setLocation(this.localHostId);
        sourceComponentID.setLocationType(this.localHostIdFormat);
        sourceComponentID.setComponent(this.sourceID);
        sourceComponentID.setSubComponent("Unknown");
        sourceComponentID.setComponentType("ApacheHTTPServer");
        sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation cbeSituation = Parser.eventFactory.createSituation();
        if (this.returnCode != null && this.returnCode.trim().length() > 0) {
            char firstChr = this.returnCode.charAt(0);
            if (this.returnCode.equals("202") || firstChr == '3' || firstChr == '1') {
                RequestSituation cbeRequestSituation = Parser.eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("SUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST INITIATED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
            } else if (firstChr == '2') {
                RequestSituation cbeRequestSituation = Parser.eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("SUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST COMPLETED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
            } else if (firstChr == '4' || firstChr == '5') {
                RequestSituation cbeRequestSituation = Parser.eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("UNSUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST INITIATED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
            }
        } else {
            ReportSituation cbeReportSituation = Parser.eventFactory.createReportSituation();
            cbeReportSituation.setReasoningScope("INTERNAL");
            cbeReportSituation.setReportCategory("LOG");
            cbeSituation.setCategoryName("ReportSituation");
            cbeSituation.setSituationType((SituationType)cbeReportSituation);
        }
        return cbeSituation;
    }

    protected void determineSeverity(CommonBaseEvent message) {
        if (this.returnCode != null && this.returnCode.trim().length() > 0) {
            char firstChr = this.returnCode.charAt(0);
            switch (firstChr) {
                case '4': {
                    message.setSeverity((short)40);
                    break;
                }
                case '5': {
                    message.setSeverity((short)60);
                    break;
                }
                default: {
                    message.setSeverity((short)10);
                    break;
                }
            }
        } else {
            message.setSeverity((short)10);
        }
    }

    protected boolean parseDate(int startIndex, int endIndex) {
        if (this.curLine.charAt(startIndex) == '[' && this.curLine.charAt(endIndex) == ']') {
            int timeZoneIndex = this.curLine.indexOf(45, startIndex);
            if (!(timeZoneIndex != -1 && timeZoneIndex <= endIndex || (timeZoneIndex = this.curLine.indexOf(43, startIndex)) != -1 && timeZoneIndex <= endIndex)) {
                return false;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
            Date creationDate = formatter.parse(this.curLine.substring(startIndex + 1, timeZoneIndex).trim(), new ParsePosition(0));
            if (creationDate != null) {
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.currentTimeStamp = new StringBuffer(formatter.format(creationDate).trim());
                this.currentTimeStamp.replace(10, 11, "T");
                this.currentTimeStamp.append(".000000");
                this.currentTimeStamp.append(this.curLine.charAt(timeZoneIndex));
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 1, timeZoneIndex + 3));
                this.currentTimeStamp.append(":");
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 3, timeZoneIndex + 5));
                return true;
            }
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int currentIndex;
        int count;
        StringTokenizer st = new StringTokenizer(this.curLine, " ");
        int fldCount = count = st.countTokens();
        if (count-- >= 1) {
            this.clientIP = st.nextToken();
        }
        if (!ParserUtilities.isValidIPAddress(this.clientIP)) {
            return false;
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            this.userID = st.nextToken();
            if (this.userID.equals("-")) {
                this.userID = null;
            }
        }
        if ((currentIndex = this.curLine.indexOf("[")) == -1) {
            return false;
        }
        int previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            return false;
        }
        if (!this.parseDate(previousIndex, currentIndex)) {
            return false;
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            this.method = st.nextToken();
        }
        if (this.method != null && this.method.charAt(0) == '\"') {
            this.method = this.method.substring(1);
            if (this.method.length() == 2 && this.method.charAt(0) == '-') {
                this.method = null;
                this.message = this.curLine.substring(currentIndex + 1).trim();
                if (count-- >= 1) {
                    this.returnCode = st.nextToken();
                }
                if (this.returnCode.equals("-")) {
                    this.returnCode = null;
                }
                if (count-- >= 1) {
                    this.fileSize = st.nextToken();
                    if (this.fileSize.equals("-")) {
                        this.fileSize = null;
                    }
                }
                if (count-- >= 1) {
                    int userAgentLength;
                    this.userAgent = st.nextToken();
                    if (this.userAgent.charAt(0) == '\"') {
                        this.userAgent = this.userAgent.substring(1);
                    }
                    if (this.userAgent.charAt((userAgentLength = this.userAgent.length()) - 1) == '\"') {
                        this.userAgent = this.userAgent.substring(0, userAgentLength - 1);
                    }
                    if (this.userAgent.equals("-")) {
                        this.userAgent = null;
                    }
                }
                if (count-- >= 1) {
                    int refererLength;
                    this.referer = st.nextToken();
                    if (this.referer.charAt(0) == '\"') {
                        this.referer = this.referer.substring(1);
                    }
                    if (this.referer.charAt((refererLength = this.referer.length()) - 1) == '\"') {
                        this.referer = this.referer.substring(0, refererLength - 1);
                    }
                    if (this.referer.equals("-")) {
                        this.referer = null;
                    }
                }
                return true;
            }
        }
        this.message = this.curLine.substring(currentIndex + 1).trim();
        String tmpFileName = this.message.substring(this.message.indexOf(32), this.message.lastIndexOf(34) - 1);
        this.fileName = tmpFileName.substring(tmpFileName.lastIndexOf(32)).indexOf("HTTP") > -1 ? tmpFileName.substring(0, tmpFileName.lastIndexOf(32)) : tmpFileName;
        String temp = null;
        if (count-- >= 1) {
            temp = st.nextToken();
        }
        while (!temp.endsWith("\"") && temp.indexOf(34) <= -1) {
            if (count-- < 1) break;
            temp = st.nextToken();
        }
        if (count-- >= 1) {
            this.returnCode = st.nextToken();
        }
        if (this.returnCode.equals("-")) {
            this.returnCode = null;
        }
        if (count-- >= 1) {
            this.fileSize = st.nextToken();
            if (this.fileSize.equals("-")) {
                this.fileSize = null;
            }
        }
        if (count-- >= 1) {
            int userAgentLength;
            this.userAgent = st.nextToken();
            if (this.userAgent.charAt(0) == '\"') {
                this.userAgent = this.userAgent.substring(1);
            }
            if (this.userAgent.charAt((userAgentLength = this.userAgent.length()) - 1) == '\"') {
                this.userAgent = this.userAgent.substring(0, userAgentLength - 1);
            }
            if (this.userAgent.equals("-")) {
                this.userAgent = null;
            }
        }
        if (count-- >= 1) {
            int refererLength;
            this.referer = st.nextToken();
            if (this.referer.charAt(0) == '\"') {
                this.referer = this.referer.substring(1);
            }
            if (this.referer.charAt((refererLength = this.referer.length()) - 1) == '\"') {
                this.referer = this.referer.substring(0, refererLength - 1);
            }
            if (this.referer.equals("-")) {
                this.referer = null;
            }
        }
        return true;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    protected void reset() {
        this.userID = null;
        this.method = null;
        this.returnCode = null;
        this.clientIP = null;
        this.fileName = null;
        this.fileSize = null;
        this.referer = null;
        this.userAgent = null;
        this.message = null;
        this.currentTimeStamp = null;
        this.cgiDebuggingOutput = new StringBuffer();
    }
}

