/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.BufferedPeriodicReader;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.util.MultipleFilesReader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private String pathSeparator = System.getProperty("file.separator");
    private String charset;
    private boolean multi = false;
    private MultipleFilesReader mfr = null;
    private RandomAccessFile tmpLog = null;
    private File tmpFile = null;
    private static String prefix = "hgla";

    public SingleOSFileSensor() {
        try {
            this.tmpFile = File.createTempFile(prefix, null);
            this.tmpLog = new RandomAccessFile(this.tmpFile, "rws");
        }
        catch (Exception e) {
            this.tmpLog = null;
        }
    }

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String directory = null;
        String fileName = null;
        String converterCmdAttribute = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable sensorProperties = this.getProperties();
        if (sensorProperties != null && !sensorProperties.isEmpty()) {
            directory = (String)sensorProperties.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            fileName = (String)sensorProperties.get(Messages.getString("HyadesGAfileNameAttributeName"));
            converterCmdAttribute = (String)sensorProperties.get(Messages.getString("HyadesGAconverterCmdAttributeName"));
            this.converterShell = (String)sensorProperties.get(Messages.getString("HyadesGAconverterShellAttributeName"));
        } else {
            NodeList sensorNodes = element.getChildNodes();
            int i = 0;
            while (i < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item(i)).getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) {
                    sensorTypeInstance = sensorNode;
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        directory = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        fileName = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"))) {
                        converterCmdAttribute = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) {
                        this.converterShell = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
                    }
                }
                ++i;
            }
        }
        if (converterCmdAttribute != null && (converterCmdAttribute = converterCmdAttribute.trim()).length() == 0) {
            converterCmdAttribute = null;
        }
        if (this.converterShell != null) {
            this.converterShell = this.converterShell.trim();
            if (this.converterShell.length() == 0) {
                this.converterShell = null;
            }
        }
        if (directory == null || directory.trim().length() == 0 || fileName == null || fileName.trim().length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
        }
        this.mfr = new MultipleFilesReader(directory, fileName, this.tmpLog);
        this.mfr.init();
        if (this.mfr.size() <= 1) {
            this.multi = false;
            if (this.tmpLog != null) {
                try {
                    this.tmpLog.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.mfr.size() == 1) {
                String fn = this.mfr.getNext();
                if (fn == null || fn.trim().length() == 0 || converterCmdAttribute == null && !new File(fn).canRead()) {
                    throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
                }
                this.setFileName(new File(fn).getName());
            } else {
                if (converterCmdAttribute == null) {
                    throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
                }
                this.setFileName(fileName.trim());
            }
        } else {
            this.multi = true;
            this.setFileName(this.tmpFile.getAbsolutePath());
            this.mfr.start();
        }
        this.setDirectory(directory.trim());
        this.setConverterCommand(converterCmdAttribute);
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.setMsg(Messages.getString("HyadesGASensor_SingleOSFileSensor_Configuration_INFO_", this.getFileName(), this.getDirectory(), this.getConverterCommand()));
        event.setSeverity((short)10);
        this.log(event);
        IComponent current = this;
        while (current != null) {
            if (current instanceof IContext) {
                this.charset = ((IContext)current).getCharset();
                break;
            }
            current = current.getParent();
        }
        if (this.charset == null) {
            this.charset = System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? "IBM-1047" : "UTF-8";
        }
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] lineArray = new String[2];
        lineArray[0] = "test string";
        return lineArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null && !this.flushingMode) {
            this.rawLogFileName = this.multi ? this.getFileName() : (this.getDirectory().endsWith(this.pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + this.pathSeparator + this.getFileName());
            if (this.rawLogFileName != null) {
                try {
                    if (this.input == null) {
                        this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                        this.input.setCharset(this.charset);
                        this.input.setConfidenceBufferSize(this.confidenceBufferSize);
                        this.input.setFileFooterSize(this.fileFooterSize);
                        this.input.setMultiFile(this.multi);
                    }
                    this.input.prepare();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    this.log(event);
                }
            }
        }
        int i = 0;
        while (i < this.lastLine.length) {
            this.lastLine[i] = null;
            ++i;
        }
        if (this.input != null) {
            int i2 = 0;
            while (i2 < this.maximumBlocking) {
                try {
                    this.lastLine[i2] = this.input.readLine();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    this.log(event);
                }
                if (this.lastLine[i2] == null) {
                    i2 = this.maximumBlocking;
                    this.rawLogFileName = null;
                }
                ++i2;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            this.mfr.interrupt();
            if (this.tmpLog != null) {
                try {
                    this.tmpLog.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.tmpFile.delete();
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)20);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final void setConverterCommand(String converterCmd) {
        this.converterCommand = converterCmd;
    }
}

