/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jmxagent;

import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerCommunicationInterface;
import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerStatInterface;
import org.eclipse.hyades.perfmon.jmxagent.ascode.jboss.JBossServer;
import org.eclipse.hyades.perfmon.jmxagent.ascode.jboss.JBossStat;
import org.eclipse.hyades.perfmon.jmxagent.ascode.jonas.JonasServer;
import org.eclipse.hyades.perfmon.jmxagent.ascode.jonas.JonasStat;
import org.eclipse.hyades.perfmon.jmxagent.communication.JmxAgent;
import org.eclipse.hyades.perfmon.jmxagent.parser.Parser;
import org.eclipse.hyades.perfmon.jmxagent.parser.ParserException;

public class JmxAgentExecute {
    static Parser agentConfig;

    public static void main(String[] stringArray) {
        String string = System.getProperty("agentXML");
        ServerCommunicationInterface serverCommunicationInterface = null;
        ServerStatInterface serverStatInterface = null;
        System.out.println("USING XML FILE : " + string);
        try {
            agentConfig = new Parser(string);
        }
        catch (ParserException parserException) {
            System.out.println("Parser Exception occured while parsing agent XML file.");
            parserException.printStackTrace();
            return;
        }
        System.out.println("Initializing Agent : " + agentConfig.getAgentName());
        if (agentConfig.getAgentName().equals("JBossAgent")) {
            serverCommunicationInterface = new JBossServer();
            serverStatInterface = new JBossStat(serverCommunicationInterface, agentConfig.getStatsName());
        } else if (agentConfig.getAgentName().equals("JonasAgent")) {
            serverCommunicationInterface = new JonasServer();
            serverStatInterface = new JonasStat(serverCommunicationInterface, agentConfig.getStatsName());
        }
        JmxAgent jmxAgent = new JmxAgent(agentConfig, serverCommunicationInterface, serverStatInterface);
    }
}

