/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * 
 * Source File Name = RAShm.h
 *
 * Descriptive Name = Remote Agent Architecture Shared Memory interface for agents
 *
 * Function:
 *    Defines:
 *
 * Dependencies:
 *    None
 *
 * Restrictions:
 *    None
 *
 * Change Activity:
 * Defect Date        Who Description
 * ====== =========== === ==============================================
 * 175248 Jun/01/2001 dns Initial drop
 * 175881 Sep/17/2001 dns changed ra_stopFlushingShm to take address of handle
 *                        pointer as a parameter instead of just the handle pointer
******************************************************************************/
#ifndef _RASHM_H
#define _RASHM_H


/* Shared Memory handle type */
#ifdef ra_shm_handle_t
#undef ra_shm_handle_t
#endif
struct _ra_shm_handle_t;
typedef struct _ra_shm_handle_t ra_shm_handle_t;

/* Shared Memory error type */
#ifdef ra_shm_err_t
#undef ra_shm_err_t
#endif
typedef long ra_shm_err_t;

/* Remote Agent shared memory routines */

#ifdef __cplusplus
#define RASHMEXTERN extern "C"
#else
#define RASHMEXTERN extern
#endif

RASHMEXTERN ra_shm_err_t ra_attachToShm(char *name, ra_shm_handle_t **handle);
RASHMEXTERN ra_shm_err_t ra_stopFlushingShm(ra_shm_handle_t **handle);


#endif
