/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgDataElement;

public class CommonBaseEventImpl
implements ICommonBaseEvent,
ISerializableAsXml {
    public static final String version = "CommonBaseEvent V1.0.0";
    protected IMsgDataElement msgDataElement;
    protected IComponentIdentification reporterComponentId;
    protected IComponentIdentification sourceComponentId;
    protected HashMap contextDataElements = new HashMap();
    protected HashMap extendedDataElements = new HashMap();
    protected HashMap associatedEvents = new HashMap();
    protected String extensionName;
    protected String localInstanceId;
    protected String globalInstanceId;
    protected String creationTime;
    protected long creationTimeValue;
    protected String situationType;
    protected String msg;
    protected long elapsedTime;
    protected short severity;
    protected short priority;
    protected short repeatCount;
    protected long sequenceNumber;

    protected CommonBaseEventImpl() {
        this.init();
    }

    public void addContextDataElement(IContextDataElement iContextDataElement) {
        this.contextDataElements.put(iContextDataElement.getName(), iContextDataElement);
    }

    public void addExtendedDataElement(IExtendedDataElement iExtendedDataElement) {
        this.extendedDataElements.put(iExtendedDataElement.getName(), iExtendedDataElement);
    }

    public void addAssociatedEvent(IAssociatedEvent iAssociatedEvent) {
        String string = iAssociatedEvent.getAssociationEngine().getName();
        if (string == null) {
            throw new RuntimeException("IAssociatedEvent must be assigned an AssociatineEngine to add it to an instance of ICommonBaseEvent");
        }
        this.associatedEvents.put(string, iAssociatedEvent);
    }

    public IContextDataElement[] getContextDataElements() {
        HashMap hashMap = this.contextDataElements;
        synchronized (hashMap) {
            if (this.contextDataElements.size() > 0) {
                IContextDataElement[] iContextDataElementArray = new IContextDataElement[this.contextDataElements.size()];
                Iterator iterator = this.contextDataElements.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iContextDataElementArray[n] = (IContextDataElement)iterator.next();
                    ++n;
                }
                IContextDataElement[] iContextDataElementArray2 = iContextDataElementArray;
                return iContextDataElementArray2;
            }
            IContextDataElement[] iContextDataElementArray = null;
            return iContextDataElementArray;
        }
    }

    public IExtendedDataElement[] getExtendedDataElements() {
        HashMap hashMap = this.extendedDataElements;
        synchronized (hashMap) {
            if (this.extendedDataElements.size() > 0) {
                IExtendedDataElement[] iExtendedDataElementArray = new IExtendedDataElement[this.extendedDataElements.size()];
                Iterator iterator = this.extendedDataElements.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iExtendedDataElementArray[n] = (IExtendedDataElement)iterator.next();
                    ++n;
                }
                IExtendedDataElement[] iExtendedDataElementArray2 = iExtendedDataElementArray;
                return iExtendedDataElementArray2;
            }
            IExtendedDataElement[] iExtendedDataElementArray = null;
            return iExtendedDataElementArray;
        }
    }

    public IAssociatedEvent[] getAssociatedEvents() {
        HashMap hashMap = this.associatedEvents;
        synchronized (hashMap) {
            if (this.associatedEvents.size() > 0) {
                IAssociatedEvent[] iAssociatedEventArray = new IAssociatedEvent[this.associatedEvents.size()];
                Iterator iterator = this.associatedEvents.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iAssociatedEventArray[n] = (IAssociatedEvent)iterator.next();
                    ++n;
                }
                IAssociatedEvent[] iAssociatedEventArray2 = iAssociatedEventArray;
                return iAssociatedEventArray2;
            }
            IAssociatedEvent[] iAssociatedEventArray = null;
            return iAssociatedEventArray;
        }
    }

    public IContextDataElement getContextDataElement(String string) {
        return (IContextDataElement)this.contextDataElements.get(string);
    }

    public IExtendedDataElement getExtendedDataElement(String string) {
        return (IExtendedDataElement)this.extendedDataElements.get(string);
    }

    public void removeContextDataElement(String string) {
        this.contextDataElements.remove(string);
    }

    public void removeExtendedDataElement(String string) {
        this.extendedDataElements.remove(string);
    }

    public void clearAssociatedEvents() {
        this.associatedEvents.clear();
    }

    public void clearContextDataElements() {
        this.contextDataElements.clear();
    }

    public void clearExtendedDataElements() {
        this.extendedDataElements.clear();
    }

    public String getCreationTime() {
        if (this.creationTime == null && this.creationTimeValue > 0L) {
            this.creationTime = CbeFormatter.convertDateToXmlSchemaDateTime(this.creationTimeValue);
        }
        return this.creationTime;
    }

    public long getCreationTimeAsLong() {
        if (this.creationTimeValue == 0L && this.creationTime != null) {
            this.creationTimeValue = CbeFormatter.convertXmlSchemaDateTimeToDate(this.creationTime);
        }
        return this.creationTimeValue;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getGlobalInstanceId() {
        return this.globalInstanceId;
    }

    public String getLocalInstanceId() {
        return this.localInstanceId;
    }

    public String getMsg() {
        return this.msg;
    }

    public short getPriority() {
        return this.priority;
    }

    public short getRepeatCount() {
        return this.repeatCount;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSeverity() {
        return this.severity;
    }

    public String getSituationType() {
        return this.situationType;
    }

    public IComponentIdentification getSourceComponentId() {
        return this.sourceComponentId;
    }

    public IMsgDataElement getMsgDataElement() {
        return this.msgDataElement;
    }

    public IComponentIdentification getReporterComponentId() {
        return this.reporterComponentId;
    }

    public void setCreationTime(String string) {
        this.creationTime = string;
        this.creationTimeValue = 0L;
    }

    public void setCreationTime(long l) {
        this.creationTimeValue = l;
        this.creationTime = null;
    }

    public void setElapsedTime(long l) {
        this.elapsedTime = l;
    }

    public void setExtensionName(String string) {
        this.extensionName = string;
    }

    public void setGlobalInstanceId(String string) {
        this.globalInstanceId = string;
    }

    public void setLocalInstanceId(String string) {
        this.localInstanceId = string;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public void setPriority(short s) {
        this.priority = s;
    }

    public void setRepeatCount(short s) {
        this.repeatCount = s;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public void setSeverity(short s) {
        this.severity = s;
    }

    public void setSituationType(String string) {
        this.situationType = string;
    }

    public void setSourceComponentId(IComponentIdentification iComponentIdentification) {
        this.sourceComponentId = iComponentIdentification;
    }

    public void setMsgDataElement(IMsgDataElement iMsgDataElement) {
        this.msgDataElement = iMsgDataElement;
    }

    public void setReporterComponentId(IComponentIdentification iComponentIdentification) {
        this.reporterComponentId = iComponentIdentification;
    }

    public void init() {
        this.clearAssociatedEvents();
        this.clearExtendedDataElements();
        this.clearContextDataElements();
        this.sourceComponentId = null;
        this.reporterComponentId = null;
        this.msgDataElement = null;
        this.extensionName = null;
        this.localInstanceId = null;
        this.creationTime = null;
        this.creationTimeValue = 0L;
        this.situationType = null;
        this.msg = null;
        this.elapsedTime = 0L;
        this.severity = 0;
        this.priority = 0;
        this.repeatCount = 0;
        this.sequenceNumber = 0L;
        this.setGlobalInstanceId(new Guid().toString());
    }

    public String externalizeCanonicalXmlString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public String externalizeCanonicalXmlDocString() {
        return CbeFormatter.toCanonicalXMLDocString(this);
    }

    public void internalizeCanonicalXmlString(String string) {
        CbeFormatter.fromCanonicalXMLString(this, string);
    }

    public void internalizeCanonicalXmlDocString(String string) {
        CbeFormatter.fromCanonicalXMLDocString(this, string);
    }

    public String getCommonBaseEventImplVersion() {
        return version;
    }

    public String getEventSchemaVersion() {
        return CbeFormatter.getEventFormatterVersion();
    }

    public String toString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof CommonBaseEventImpl && this.getClass() == object.getClass()) {
            CommonBaseEventImpl commonBaseEventImpl = (CommonBaseEventImpl)object;
            Object object2 = this.getGlobalInstanceId();
            Object object3 = commonBaseEventImpl.getGlobalInstanceId();
            if ((object2 != null && object2.equals(object3) || object2 == null && object3 == null) && this.getCreationTimeAsLong() == commonBaseEventImpl.getCreationTimeAsLong() && this.getElapsedTime() == commonBaseEventImpl.getElapsedTime() && this.getSeverity() == commonBaseEventImpl.getSeverity() && this.getPriority() == commonBaseEventImpl.getPriority() && this.getRepeatCount() == commonBaseEventImpl.getRepeatCount() && this.getSequenceNumber() == commonBaseEventImpl.getSequenceNumber()) {
                object2 = this.getLocalInstanceId();
                object3 = commonBaseEventImpl.getLocalInstanceId();
                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                    object2 = this.getExtensionName();
                    object3 = commonBaseEventImpl.getExtensionName();
                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                        object2 = this.getSituationType();
                        object3 = commonBaseEventImpl.getSituationType();
                        if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                            object2 = this.getMsg();
                            object3 = commonBaseEventImpl.getMsg();
                            if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                object2 = this.getMsgDataElement();
                                object3 = commonBaseEventImpl.getMsgDataElement();
                                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                    object2 = this.getReporterComponentId();
                                    object3 = commonBaseEventImpl.getReporterComponentId();
                                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                        object2 = this.getSourceComponentId();
                                        object3 = commonBaseEventImpl.getSourceComponentId();
                                        if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                            object2 = this.contextDataElements;
                                            object3 = commonBaseEventImpl.contextDataElements;
                                            if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                object2 = this.extendedDataElements;
                                                object3 = commonBaseEventImpl.extendedDataElements;
                                                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                    object2 = this.associatedEvents;
                                                    object3 = commonBaseEventImpl.associatedEvents;
                                                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                        bl = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }
}

