/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.agent;

import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class ComptestAgent {
    private static final boolean TEST = false;
    private static final String LISTENER_MSG = "LM##HP:";
    public static final long BROADCAST_CONTEXT_ID = 500L;
    private static final long SHUTDOWN_SLEEP_TIME = 2000L;
    private RemoteComponentSkeleton loggingAgent;

    public ComptestAgent(RemoteComponentSkeleton remoteComponentSkeleton) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.loggingAgent = remoteComponentSkeleton;
    }

    public static void sendData(AgentImpl agentImpl, String string) throws InactiveAgentException {
        if (string == null) {
            string = "";
        }
        CustomCommand customCommand = new CustomCommand();
        customCommand.setData(LISTENER_MSG + string);
        agentImpl.invokeCustomCommand(customCommand);
    }

    public static void sendData(AgentImpl agentImpl, byte[] byArray) throws InactiveAgentException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        CustomCommand customCommand = new CustomCommand();
        customCommand.setData(byArray);
        agentImpl.invokeCustomCommand(customCommand);
    }

    public boolean isInitialized() {
        return this.loggingAgent != null;
    }

    public boolean isAgentControllerActive() {
        return this.loggingAgent != null && this.loggingAgent.isAgentControllerActive();
    }

    public boolean isLogging() {
        return this.loggingAgent != null && this.loggingAgent.isLogging();
    }

    public void write(Object object) {
        if (this.isInitialized()) {
            if (this.isAgentControllerActive() && this.isLogging()) {
                this.loggingAgent.logMessageUTF8(object.toString());
            }
        } else {
            System.out.println(object.toString());
        }
    }

    public boolean write(String string) {
        boolean bl = false;
        if (this.isInitialized()) {
            bl = true;
            if (this.isAgentControllerActive() && this.isLogging()) {
                this.loggingAgent.logMessageUTF8(string);
            }
        } else {
            System.out.println(string);
        }
        return bl;
    }

    public void sendMessage(String string) {
        if (!this.isInitialized()) {
            throw new RuntimeException("ComptestAgent not initialized.");
        }
        this.loggingAgent.broadcastMessage(string, 500L);
    }

    public void sendMessage(byte[] byArray, int n, int n2) {
        if (!this.isInitialized()) {
            throw new RuntimeException("ComptestAgent not initialized.");
        }
        this.loggingAgent.broadcastMessage(byArray, n, n2, 500L);
    }
}

