/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.ILogger;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractErrorLogParser
extends Parser {
    private static final String TARGET_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_STAMP_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final String CATEGORY = "category";
    private static final String CGI = "CGI_debugging_output";
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int NOTICE = 3;
    private static final int WARN = 4;
    private static final int ERROR = 5;
    private static final int CRIT = 6;
    private static final int ALERT = 7;
    private static final int EMERG = 8;
    private static final String DEBUG_STRING = "debug";
    private static final String INFO_STRING = "info";
    private static final String NOTICE_STRING = "notice";
    private static final String WARN_STRING = "warn";
    private static final String ERROR_STRING = "error";
    private static final String CRIT_STRING = "crit";
    private static final String ALERT_STRING = "alert";
    private static final String EMERG_STRING = "emerg";
    protected String category;
    protected StringBuffer creationTime;
    protected String hostID;
    protected String body;
    protected String productVersion;
    protected String sourceId;
    protected short Type;
    protected String file;
    private String currentCreationTime = "";
    private long duplicateCreationTimeCounter = 0L;

    public void parse(ILogger iLogger) throws LogParserException {
        super.parse(iLogger);
        try {
            while (this.curLine != null) {
                Object object;
                this.reset();
                this.messages[this.arrayIndex].init();
                this.messages[this.arrayIndex].setSourceComponentId(Parser.eventFactory.createComponentIdentification());
                this.messages[this.arrayIndex].getSourceComponentId().init();
                this.messages[this.arrayIndex].setMsgDataElement(Parser.eventFactory.createMsgDataElement());
                this.messages[this.arrayIndex].getMsgDataElement().init();
                this.messages[this.arrayIndex].getSourceComponentId().setComponent(this.sourceId);
                this.messages[this.arrayIndex].getSourceComponentId().setLocation(this.localHostId);
                this.messages[this.arrayIndex].getSourceComponentId().setLocationType(this.localHostIdFormat);
                this.messages[this.arrayIndex].getSourceComponentId().setSubComponent("Unknown");
                this.messages[this.arrayIndex].getMsgDataElement().setMsgIdType("Not Applicable");
                this.messages[this.arrayIndex].getMsgDataElement().setMsgId("None");
                if (this.parseDate(0, 0)) {
                    this.parseRemainder();
                    this.messages[this.arrayIndex].setSeverity(this.Type);
                    if (this.category != null) {
                        object = Parser.createStringEDE(CATEGORY, this.category);
                        this.messages[this.arrayIndex].addExtendedDataElement((IExtendedDataElement)object);
                    }
                    if (this.hostID != null) {
                        object = Parser.createStringEDE("client", this.hostID);
                        this.messages[this.arrayIndex].addExtendedDataElement((IExtendedDataElement)object);
                    }
                    if (this.file != null) {
                        object = Parser.createStringEDE("file", this.file);
                        this.messages[this.arrayIndex].addExtendedDataElement((IExtendedDataElement)object);
                    }
                    this.messages[this.arrayIndex].setMsg(this.body);
                    this.messages[this.arrayIndex].getMsgDataElement().setMsgLocale("en-US");
                } else {
                    this.body = this.curLine.trim();
                    this.curLine = this.readLine();
                    while (this.curLine != null) {
                        if (this.parseDate(0, 1)) break;
                        this.body = this.body + " " + this.curLine.trim();
                        this.curLine = this.readLine();
                    }
                    if (this.body != null) {
                        if (this.body.trim().length() == 0) continue;
                        object = Parser.createStringEDE(CGI, this.body);
                        this.messages[this.arrayIndex].addExtendedDataElement((IExtendedDataElement)object);
                    }
                    this.messages[this.arrayIndex].setSeverity((short)10);
                }
                this.messages[this.arrayIndex].setCreationTime(this.creationTime.toString());
                object = new StringBuffer(this.localHostId);
                if (this.file_path != null) {
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(this.file_path);
                }
                if (this.localHostName != null) {
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(this.localHostName);
                }
                ((StringBuffer)object).append(' ');
                if (this.currentCreationTime.equals(this.creationTime.toString().trim())) {
                    this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateCreationTimeCounter);
                } else {
                    this.currentCreationTime = this.creationTime.toString().trim();
                    this.duplicateCreationTimeCounter = 0L;
                }
                this.logger.write((Object)this.messages[this.arrayIndex]);
            }
            this.writePartialArray();
        }
        catch (Throwable throwable) {
            LogParserException logParserException = new LogParserException(ParserUtilities.getResourceString("ERROR_LOG_PARSER_ERROR_"), throwable);
            logParserException.fillInStackTrace();
            throw logParserException;
        }
    }

    protected void reset() {
        this.Type = 0;
        this.body = null;
        this.hostID = null;
        this.file = null;
        this.category = null;
        this.creationTime = null;
    }

    protected boolean parseDate(int n, int n2) {
        String string = "";
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        if (this.isChar(this.curLine, n + 0, '[') && this.isLet(this.curLine, n + 1, 3) && this.isChar(this.curLine, n + 4, ' ') && this.isLet(this.curLine, n + 5, 3) && this.isChar(this.curLine, n + 8, ' ') && this.isNum(this.curLine, n + 10, 1) && this.isChar(this.curLine, n + 11, ' ') && this.isNum(this.curLine, n + 12, 2) && this.isChar(this.curLine, n + 14, ':') && this.isNum(this.curLine, n + 15, 2) && this.isChar(this.curLine, n + 17, ':') && this.isNum(this.curLine, n + 18, 2) && this.isChar(this.curLine, n + 20, ' ') && this.isNum(this.curLine, n + 21, 4) && this.isChar(this.curLine, n + 25, ']')) {
            ParsePosition parsePosition;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT, Locale.US);
            Date date = simpleDateFormat.parse(string = string + this.curLine.substring(1, 25), parsePosition = new ParsePosition(0));
            if (date != null) {
                if (n2 == 0) {
                    char c;
                    simpleDateFormat = new SimpleDateFormat(TARGET_FORMAT);
                    this.creationTime = new StringBuffer(simpleDateFormat.format(date));
                    this.creationTime.replace(10, 11, "T");
                    this.creationTime.append(".000000");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    int n3 = (calendar.get(15) + calendar.get(16)) / 60000;
                    String string2 = null;
                    String string3 = null;
                    if (n3 >= 0) {
                        c = '+';
                        string2 = String.valueOf(n3 / 60);
                        string3 = String.valueOf(n3 % 60);
                    } else {
                        c = '-';
                        string2 = String.valueOf(-1 * n3 / 60);
                        string3 = String.valueOf(-1 * n3 % 60);
                    }
                    this.creationTime.append(c);
                    if (string2.length() == 1) {
                        this.creationTime.append("0");
                    }
                    this.creationTime.append(string2);
                    this.creationTime.append(":");
                    if (string3.length() == 1) {
                        this.creationTime.append("0");
                    }
                    this.creationTime.append(string3);
                    this.curLine = this.curLine.substring(26);
                }
                return true;
            }
        } else if (n2 == 0) {
            if (!this.currentCreationTime.equals("")) {
                this.creationTime = new StringBuffer(this.currentCreationTime);
            } else {
                char c;
                Date date = new Date();
                date.setTime(0L);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TARGET_FORMAT);
                this.creationTime = new StringBuffer(simpleDateFormat.format(date));
                this.creationTime.replace(10, 11, "T");
                this.creationTime.append(".000000");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n4 = (calendar.get(15) + calendar.get(16)) / 60000;
                String string4 = null;
                if (n4 >= 0) {
                    c = '+';
                    string4 = String.valueOf(n4);
                } else {
                    c = '-';
                    string4 = String.valueOf(-1 * n4);
                }
                this.creationTime.append(c);
                if (string4.length() == 1) {
                    this.creationTime.append("00");
                } else if (string4.length() == 2) {
                    this.creationTime.append('0');
                }
                this.creationTime.append(string4);
            }
        }
        return false;
    }

    protected void parseRemainder() {
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        this.parseType(0);
        this.parseBody();
    }

    protected void parseType(int n) {
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        this.Type = (short)10;
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        if (this.isChar(this.curLine, n + 0, '[')) {
            if (this.isPara(this.curLine, n + 1, DEBUG_STRING) == 0) {
                bl = true;
                n2 = 5;
                n3 = 1;
                this.category = DEBUG_STRING;
            } else if (this.isPara(this.curLine, n + 1, INFO_STRING) == 0) {
                bl = true;
                n2 = 4;
                n3 = 2;
                this.category = INFO_STRING;
            } else if (this.isPara(this.curLine, n + 1, NOTICE_STRING) == 0) {
                bl = true;
                n2 = 6;
                n3 = 3;
                this.category = NOTICE_STRING;
            } else if (this.isPara(this.curLine, n + 1, WARN_STRING) == 0) {
                bl = true;
                n2 = 4;
                n3 = 4;
                this.category = WARN_STRING;
            } else if (this.isPara(this.curLine, n + 1, ERROR_STRING) == 0) {
                bl = true;
                n2 = 5;
                n3 = 5;
                this.category = ERROR_STRING;
            } else if (this.isPara(this.curLine, n + 1, CRIT_STRING) == 0) {
                bl = true;
                n2 = 4;
                n3 = 6;
                this.category = CRIT_STRING;
            } else if (this.isPara(this.curLine, n + 1, ALERT_STRING) == 0) {
                bl = true;
                n2 = 5;
                n3 = 7;
                this.category = ALERT_STRING;
            } else if (this.isPara(this.curLine, n + 1, EMERG_STRING) == 0) {
                bl = true;
                n2 = 5;
                n3 = 8;
                this.category = EMERG_STRING;
            }
        }
        if (bl && this.isChar(this.curLine, n + n2 + 1, ']')) {
            switch (n3) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.Type = (short)50;
                    break;
                }
                case 4: {
                    this.Type = (short)30;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.Type = (short)10;
                }
            }
            this.curLine = this.curLine.substring(n + n2 + 2);
        }
    }

    protected void parseBody() {
        int n = this.curLine.indexOf("[client");
        int n2 = this.curLine.indexOf(93);
        if (n != -1 && n2 != -1 && n2 > n + 7) {
            this.hostID = this.curLine.substring(this.curLine.indexOf("[client") + 7, this.curLine.indexOf(93)).trim();
            this.curLine = this.curLine.substring(this.curLine.indexOf(93) + 1);
        }
        this.body = this.curLine.trim();
        if (this.body.indexOf(": ") != -1) {
            this.file = this.body.substring(this.body.indexOf(": ") + 2).trim();
        }
        this.curLine = this.readLine();
    }

    protected int isPara(String string, int n, String string2) {
        try {
            return string.substring(n, n + string2.length()).compareTo(string2);
        }
        catch (Exception exception) {
            return 1;
        }
    }
}

