/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.util.HashMap;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.exceptions.InvalidExtendedDataElementTypeException;

public class ExtendedDataElementImpl
implements IExtendedDataElement {
    private HashMap children = new HashMap();
    private String name;
    private byte type = (byte)-1;
    private String id;
    private String stringValue = null;
    private long longValue = 0L;
    private double doubleValue = 0.0;
    private boolean booleanValue = false;
    private String[] stringArrayValue = null;
    private byte[] byteArrayValue = null;
    private short[] shortArrayValue = null;
    private int[] intArrayValue = null;
    private long[] longArrayValue = null;
    private float[] floatArrayValue = null;
    private double[] doubleArrayValue = null;
    private boolean[] booleanArrayValue = null;

    protected ExtendedDataElementImpl() {
    }

    public void addChildDataElement(IExtendedDataElement iExtendedDataElement) {
        this.children.put(iExtendedDataElement.getName(), iExtendedDataElement);
    }

    public Object[] getChildDataElements() {
        return this.children.values().toArray();
    }

    public void removeChildDataElement(String string) {
        this.children.remove(string);
    }

    public void clearChildDataElements() {
        this.children.clear();
    }

    public String[] getValues() {
        String[] stringArray = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                stringArray = new String[]{Long.toString(this.longValue)};
                break;
            }
            case 7: {
                stringArray = new String[]{new Boolean(this.booleanValue).toString()};
                break;
            }
            case 4: 
            case 5: {
                stringArray = new String[]{Double.toString(this.doubleValue)};
                break;
            }
            case 6: {
                stringArray = new String[]{this.stringValue};
                break;
            }
            case 8: {
                stringArray = new String[]{this.getDateTime()};
                break;
            }
            case 9: 
            case 28: {
                int n = this.byteArrayValue.length;
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = Byte.toString(this.byteArrayValue[n2]);
                    ++n2;
                }
                break;
            }
            case 16: {
                int n = this.booleanArrayValue.length;
                stringArray = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    stringArray[n3] = new Boolean(this.booleanArrayValue[n3]).toString();
                    ++n3;
                }
                break;
            }
            case 10: {
                int n = this.shortArrayValue.length;
                stringArray = new String[n];
                int n4 = 0;
                while (n4 < n) {
                    stringArray[n4] = Short.toString(this.shortArrayValue[n4]);
                    ++n4;
                }
                break;
            }
            case 11: {
                int n = this.intArrayValue.length;
                stringArray = new String[n];
                int n5 = 0;
                while (n5 < n) {
                    stringArray[n5] = Integer.toString(this.intArrayValue[n5]);
                    ++n5;
                }
                break;
            }
            case 12: {
                int n = this.longArrayValue.length;
                stringArray = new String[n];
                int n6 = 0;
                while (n6 < n) {
                    stringArray[n6] = Long.toString(this.longArrayValue[n6]);
                    ++n6;
                }
                break;
            }
            case 13: {
                int n = this.floatArrayValue.length;
                stringArray = new String[n];
                int n7 = 0;
                while (n7 < n) {
                    stringArray[n7] = Float.toString(this.floatArrayValue[n7]);
                    ++n7;
                }
                break;
            }
            case 14: {
                int n = this.doubleArrayValue.length;
                stringArray = new String[n];
                int n8 = 0;
                while (n8 < n) {
                    stringArray[n8] = Double.toString(this.doubleArrayValue[n8]);
                    ++n8;
                }
                break;
            }
            case 15: {
                stringArray = this.stringArrayValue;
                break;
            }
            case 17: {
                stringArray = this.getDateTimeArray();
                break;
            }
        }
        return stringArray;
    }

    public byte[] getHexValue() {
        return this.getHexBinary();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte getTypeValue() {
        return this.type;
    }

    public String getType() {
        String string = null;
        switch (this.type) {
            case 0: {
                string = "byte";
                break;
            }
            case 1: {
                string = "short";
                break;
            }
            case 2: {
                string = "int";
                break;
            }
            case 3: {
                string = "long";
                break;
            }
            case 7: {
                string = "boolean";
                break;
            }
            case 4: {
                string = "float";
                break;
            }
            case 5: {
                string = "double";
                break;
            }
            case 6: {
                string = "string";
                break;
            }
            case 8: {
                string = "dateTime";
                break;
            }
            case 9: {
                string = "byteArray";
                break;
            }
            case 10: {
                string = "shortArray";
                break;
            }
            case 11: {
                string = "intArray";
                break;
            }
            case 12: {
                string = "longArray";
                break;
            }
            case 16: {
                string = "booleanArray";
                break;
            }
            case 13: {
                string = "floatArray";
                break;
            }
            case 14: {
                string = "doubleArray";
                break;
            }
            case 15: {
                string = "stringArray";
                break;
            }
            case 17: {
                string = "dateTime";
                break;
            }
            case 28: {
                string = "hexBinary";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(byte by) {
        if (by < 0 || by > 28) {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + by);
        }
        this.type = by;
    }

    public void setType(String string) {
        if (string.equals("byte")) {
            this.type = 0;
        } else if (string.equals("boolean")) {
            this.type = (byte)7;
        } else if (string.equals("short")) {
            this.type = 1;
        } else if (string.equals("int")) {
            this.type = (byte)2;
        } else if (string.equals("long")) {
            this.type = (byte)3;
        } else if (string.equals("float")) {
            this.type = (byte)4;
        } else if (string.equals("double")) {
            this.type = (byte)5;
        } else if (string.equals("dateTime")) {
            this.type = (byte)8;
        } else if (string.equals("string")) {
            this.type = (byte)6;
        } else if (string.equals("byteArray")) {
            this.type = (byte)9;
        } else if (string.equals("booleanArray")) {
            this.type = (byte)16;
        } else if (string.equals("shortArray")) {
            this.type = (byte)10;
        } else if (string.equals("intArray")) {
            this.type = (byte)11;
        } else if (string.equals("longArray")) {
            this.type = (byte)12;
        } else if (string.equals("floatArray")) {
            this.type = (byte)13;
        } else if (string.equals("doubleArray")) {
            this.type = (byte)14;
        } else if (string.equals("dateTimeArray")) {
            this.type = (byte)17;
        } else if (string.equals("stringArray")) {
            this.type = (byte)15;
        } else if (string.equals("hexBinary")) {
            this.type = (byte)28;
        } else {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + string);
        }
    }

    public void setValues(String[] stringArray) {
        int n = stringArray.length;
        this.clearValues();
        switch (this.type) {
            case 0: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Byte.parseByte(stringArray[0]);
                break;
            }
            case 1: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Short.parseShort(stringArray[0]);
                break;
            }
            case 2: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Integer.parseInt(stringArray[0]);
                break;
            }
            case 3: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.longValue = Long.parseLong(stringArray[0]);
                break;
            }
            case 7: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.booleanValue = new Boolean(stringArray[0]);
                break;
            }
            case 4: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.doubleValue = Double.parseDouble(stringArray[0]);
                break;
            }
            case 5: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.doubleValue = Double.parseDouble(stringArray[0]);
                break;
            }
            case 6: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.stringValue = stringArray[0];
                break;
            }
            case 8: {
                if (n > 1) {
                    throw new RuntimeException("Values contains more than one element for type" + this.getType());
                }
                this.stringValue = stringArray[0];
                break;
            }
            case 9: {
                this.byteArrayValue = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    this.byteArrayValue[n2] = Byte.parseByte(stringArray[n2]);
                    ++n2;
                }
                break;
            }
            case 28: {
                this.byteArrayValue = new byte[n];
                int n3 = 0;
                while (n3 < n) {
                    this.byteArrayValue[n3] = Byte.parseByte(stringArray[n3]);
                    ++n3;
                }
                break;
            }
            case 10: {
                this.shortArrayValue = new short[n];
                int n4 = 0;
                while (n4 < n) {
                    this.shortArrayValue[n4] = Short.parseShort(stringArray[n4]);
                    ++n4;
                }
                break;
            }
            case 11: {
                this.intArrayValue = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    this.intArrayValue[n5] = Integer.parseInt(stringArray[n5]);
                    ++n5;
                }
                break;
            }
            case 12: {
                this.longArrayValue = new long[n];
                int n6 = 0;
                while (n6 < n) {
                    this.longArrayValue[n6] = Long.parseLong(stringArray[n6]);
                    ++n6;
                }
                break;
            }
            case 16: {
                this.booleanArrayValue = new boolean[n];
                int n7 = 0;
                while (n7 < n) {
                    this.booleanArrayValue[n7] = Boolean.getBoolean(stringArray[n7]);
                    ++n7;
                }
                break;
            }
            case 13: {
                this.floatArrayValue = new float[n];
                int n8 = 0;
                while (n8 < n) {
                    this.floatArrayValue[n8] = Float.parseFloat(stringArray[n8]);
                    ++n8;
                }
                break;
            }
            case 14: {
                this.doubleArrayValue = new double[n];
                int n9 = 0;
                while (n9 < n) {
                    this.doubleArrayValue[n9] = Double.parseDouble(stringArray[n9]);
                    ++n9;
                }
                break;
            }
            case 15: {
                this.stringArrayValue = stringArray;
                break;
            }
            case 17: {
                this.stringArrayValue = new String[n];
                int n10 = 0;
                while (n10 < n) {
                    this.stringArrayValue[n10] = stringArray[n10];
                    ++n10;
                }
                break;
            }
            default: {
                throw new RuntimeException("Values not set for type :" + this.getType());
            }
        }
    }

    public void setHexValue(byte[] byArray) {
        this.clearValues();
        this.byteArrayValue = byArray;
    }

    public String getString() {
        if (this.type != 6) {
            throw new InvalidExtendedDataElementTypeException("getString was called for an event property of type " + this.getType());
        }
        return this.stringValue;
    }

    public long getDateTimeAsLong() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeAsLong was called for an event property of type " + this.getType());
        }
        if (this.longValue == 0L) {
            this.longValue = CbeFormatter.convertXmlSchemaDateTimeToDate(this.stringValue);
        }
        return this.longValue;
    }

    public String getDateTime() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTime was called for an event property of type " + this.getType());
        }
        if (this.stringValue == null) {
            this.stringValue = CbeFormatter.convertDateToXmlSchemaDateTime(this.longValue);
        }
        return this.stringValue;
    }

    public boolean getBoolean() {
        if (this.type != 7) {
            throw new InvalidExtendedDataElementTypeException("getBoolean was called for an event property of type " + this.getType());
        }
        return this.booleanValue;
    }

    public byte getByte() {
        if (this.type != 0) {
            throw new InvalidExtendedDataElementTypeException("getByte was called for an event property of type " + this.getType());
        }
        return (byte)this.longValue;
    }

    public short getShort() {
        if (this.type != 1) {
            throw new InvalidExtendedDataElementTypeException("getShort was called for an event property of type " + this.getType());
        }
        return (short)this.longValue;
    }

    public int getInt() {
        if (this.type != 2) {
            throw new InvalidExtendedDataElementTypeException("getInt was called for an event property of type " + this.getType());
        }
        return (int)this.longValue;
    }

    public long getLong() {
        if (this.type != 3) {
            throw new InvalidExtendedDataElementTypeException("getLong was called for an event property of type " + this.getType());
        }
        return this.longValue;
    }

    public float getFloat() {
        if (this.type != 4) {
            throw new InvalidExtendedDataElementTypeException("getFloat was called for an event property of type " + this.getType());
        }
        return (float)this.doubleValue;
    }

    public double getDouble() {
        if (this.type != 5) {
            throw new InvalidExtendedDataElementTypeException("getDouble was called for an event property of type " + this.getType());
        }
        return this.doubleValue;
    }

    public String[] getStringArray() {
        if (this.type != 15) {
            throw new InvalidExtendedDataElementTypeException("getStringArray was called for an event property of type " + this.getType());
        }
        return this.stringArrayValue;
    }

    public long[] getDateTimeArrayAsLong() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArrayAsLong was called for an event property of type " + this.getType());
        }
        if (this.longArrayValue == null) {
            int n = 0;
            if (this.stringArrayValue != null) {
                n = this.stringArrayValue.length;
            }
            this.longArrayValue = new long[n];
            int n2 = 0;
            while (n2 < n) {
                this.longArrayValue[n2] = CbeFormatter.convertXmlSchemaDateTimeToDate(this.stringArrayValue[n2]);
                ++n2;
            }
        }
        return this.longArrayValue;
    }

    public String[] getDateTimeArray() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArray was called for an event property of type " + this.getType());
        }
        if (this.stringArrayValue == null) {
            int n = 0;
            if (this.longArrayValue != null) {
                n = this.longArrayValue.length;
            }
            this.stringArrayValue = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.stringArrayValue[n2] = CbeFormatter.convertDateToXmlSchemaDateTime(this.longArrayValue[n2]);
                ++n2;
            }
        }
        return this.stringArrayValue;
    }

    public boolean[] getBooleanArray() {
        if (this.type != 16) {
            throw new InvalidExtendedDataElementTypeException("getBooleanArray was called for an event property of type " + this.getType());
        }
        return this.booleanArrayValue;
    }

    public byte[] getByteArray() {
        if (this.type != 9) {
            throw new InvalidExtendedDataElementTypeException("getByteArray was called for an event property of type " + this.getType());
        }
        return this.byteArrayValue;
    }

    public short[] getShortArray() {
        if (this.type != 10) {
            throw new InvalidExtendedDataElementTypeException("getShortArray was called for an event property of type " + this.getType());
        }
        return this.shortArrayValue;
    }

    public int[] getIntArray() {
        if (this.type != 11) {
            throw new InvalidExtendedDataElementTypeException("getIntArray was called for an event property of type " + this.getType());
        }
        return this.intArrayValue;
    }

    public long[] getLongArray() {
        if (this.type != 12) {
            throw new InvalidExtendedDataElementTypeException("getLongArray was called for an event property of type " + this.getType());
        }
        return this.longArrayValue;
    }

    public float[] getFloatArray() {
        if (this.type != 13) {
            throw new InvalidExtendedDataElementTypeException("getFloatArray was called for an event property of type " + this.getType());
        }
        return this.floatArrayValue;
    }

    public double[] getDoubleArray() {
        if (this.type != 14) {
            throw new InvalidExtendedDataElementTypeException("getDoubleArray was called for an event property of type " + this.getType());
        }
        return this.doubleArrayValue;
    }

    public byte[] getHexBinary() {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("getHexBinary was called for an event property of type " + this.getType());
        }
        return this.byteArrayValue;
    }

    public void setString(String string) {
        if (this.type != 6) {
            throw new InvalidExtendedDataElementTypeException("setString was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringValue = string;
    }

    public void setDateTime(long l) {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("setDateTime was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = l;
    }

    public void setDateTime(String string) {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("setDateTime was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringValue = string;
    }

    public void setBoolean(boolean bl) {
        if (this.type != 7) {
            throw new InvalidExtendedDataElementTypeException("setBoolean was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.booleanValue = bl;
    }

    public void setByte(byte by) {
        if (this.type != 0) {
            throw new InvalidExtendedDataElementTypeException("setByte was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = by;
    }

    public void setShort(short s) {
        if (this.type != 1) {
            throw new InvalidExtendedDataElementTypeException("setShort was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = s;
    }

    public void setInt(int n) {
        if (this.type != 2) {
            throw new InvalidExtendedDataElementTypeException("setInt was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = n;
    }

    public void setLong(long l) {
        if (this.type != 3) {
            throw new InvalidExtendedDataElementTypeException("setLong was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longValue = l;
    }

    public void setFloat(float f) {
        if (this.type != 4) {
            throw new InvalidExtendedDataElementTypeException("setFloat was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleValue = f;
    }

    public void setDouble(double d) {
        if (this.type != 5) {
            throw new InvalidExtendedDataElementTypeException("setDouble was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleValue = d;
    }

    public void setStringArray(String[] stringArray) {
        if (this.type != 15) {
            throw new InvalidExtendedDataElementTypeException("setStringArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringArrayValue = stringArray;
    }

    public void setDateTimeArray(long[] lArray) {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("setDateTimeArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longArrayValue = lArray;
    }

    public void setDateTimeArray(String[] stringArray) {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("setDateTimeArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.stringArrayValue = stringArray;
    }

    public void setBooleanArray(boolean[] blArray) {
        if (this.type != 16) {
            throw new InvalidExtendedDataElementTypeException("setBooleanArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.booleanArrayValue = blArray;
    }

    public void setByteArray(byte[] byArray) {
        if (this.type != 9) {
            throw new InvalidExtendedDataElementTypeException("setByteArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.byteArrayValue = byArray;
    }

    public void setShortArray(short[] sArray) {
        if (this.type != 10) {
            throw new InvalidExtendedDataElementTypeException("setShortArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.shortArrayValue = sArray;
    }

    public void setIntArray(int[] nArray) {
        if (this.type != 11) {
            throw new InvalidExtendedDataElementTypeException("setIntArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.intArrayValue = nArray;
    }

    public void setLongArray(long[] lArray) {
        if (this.type != 12) {
            throw new InvalidExtendedDataElementTypeException("setLongArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.longArrayValue = lArray;
    }

    public void setFloatArray(float[] fArray) {
        if (this.type != 13) {
            throw new InvalidExtendedDataElementTypeException("setFloatArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.floatArrayValue = fArray;
    }

    public void setDoubleArray(double[] dArray) {
        if (this.type != 14) {
            throw new InvalidExtendedDataElementTypeException("setDoubleArray was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.doubleArrayValue = dArray;
    }

    public void setHexBinary(byte[] byArray) {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("setHexBinary was called for an event property of type " + this.getType());
        }
        this.clearValues();
        this.byteArrayValue = byArray;
    }

    public void clearValues() {
        this.stringValue = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.booleanValue = false;
        this.stringArrayValue = null;
        this.byteArrayValue = null;
        this.shortArrayValue = null;
        this.intArrayValue = null;
        this.longArrayValue = null;
        this.floatArrayValue = null;
        this.doubleArrayValue = null;
        this.booleanArrayValue = null;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ExtendedDataElementImpl extendedDataElementImpl = (ExtendedDataElementImpl)object;
            if ((this.getName() != null && this.getName().equals(extendedDataElementImpl.getName()) || this.getName() == null && extendedDataElementImpl.getName() == null) && this.getTypeValue() == extendedDataElementImpl.getTypeValue() && (this.children != null && this.children.equals(extendedDataElementImpl.children) || this.children == null && extendedDataElementImpl.children == null)) {
                try {
                    block1 : switch (this.getTypeValue()) {
                        case 0: {
                            if (this.getByte() == extendedDataElementImpl.getByte()) {
                                bl = true;
                            }
                            break;
                        }
                        case 1: {
                            if (this.getShort() == extendedDataElementImpl.getShort()) {
                                bl = true;
                            }
                            break;
                        }
                        case 2: {
                            if (this.getInt() == extendedDataElementImpl.getInt()) {
                                bl = true;
                            }
                            break;
                        }
                        case 3: {
                            if (this.getLong() == extendedDataElementImpl.getLong()) {
                                bl = true;
                            }
                            break;
                        }
                        case 7: {
                            if (this.getBoolean() == extendedDataElementImpl.getBoolean()) {
                                bl = true;
                            }
                            break;
                        }
                        case 4: {
                            if (this.getFloat() == extendedDataElementImpl.getFloat()) {
                                bl = true;
                            }
                            break;
                        }
                        case 5: {
                            if (this.getDouble() == extendedDataElementImpl.getDouble()) {
                                bl = true;
                            }
                            break;
                        }
                        case 6: {
                            if (this.getString().equals(extendedDataElementImpl.getString())) {
                                bl = true;
                            }
                            break;
                        }
                        case 8: {
                            if (this.getDateTimeAsLong() == extendedDataElementImpl.getDateTimeAsLong()) {
                                bl = true;
                            }
                            break;
                        }
                        case 9: 
                        case 28: {
                            if (this.getByteArray().length == extendedDataElementImpl.getByteArray().length) {
                                int n = this.getByteArray().length;
                                bl = true;
                                int n2 = 0;
                                while (n2 < n) {
                                    if (this.getByteArray()[n2] != extendedDataElementImpl.getByteArray()[n2]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n2;
                                }
                            }
                            break;
                        }
                        case 16: {
                            if (this.getBooleanArray().length == extendedDataElementImpl.getBooleanArray().length) {
                                int n = this.getBooleanArray().length;
                                bl = true;
                                int n3 = 0;
                                while (n3 < n) {
                                    if (this.getBooleanArray()[n3] != extendedDataElementImpl.getBooleanArray()[n3]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n3;
                                }
                            }
                            break;
                        }
                        case 10: {
                            if (this.getShortArray().length == extendedDataElementImpl.getShortArray().length) {
                                int n = this.getShortArray().length;
                                bl = true;
                                int n4 = 0;
                                while (n4 < n) {
                                    if (this.getShortArray()[n4] != extendedDataElementImpl.getShortArray()[n4]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n4;
                                }
                            }
                            break;
                        }
                        case 11: {
                            if (this.getIntArray().length == extendedDataElementImpl.getIntArray().length) {
                                int n = this.getIntArray().length;
                                bl = true;
                                int n5 = 0;
                                while (n5 < n) {
                                    if (this.getIntArray()[n5] != extendedDataElementImpl.getIntArray()[n5]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n5;
                                }
                            }
                            break;
                        }
                        case 12: {
                            if (this.getLongArray().length == extendedDataElementImpl.getLongArray().length) {
                                int n = this.getLongArray().length;
                                bl = true;
                                int n6 = 0;
                                while (n6 < n) {
                                    if (this.getLongArray()[n6] != extendedDataElementImpl.getLongArray()[n6]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n6;
                                }
                            }
                            break;
                        }
                        case 13: {
                            if (this.getFloatArray().length == extendedDataElementImpl.getFloatArray().length) {
                                int n = this.getFloatArray().length;
                                bl = true;
                                int n7 = 0;
                                while (n7 < n) {
                                    if (this.getFloatArray()[n7] != extendedDataElementImpl.getFloatArray()[n7]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n7;
                                }
                            }
                            break;
                        }
                        case 14: {
                            if (this.getDoubleArray().length == extendedDataElementImpl.getDoubleArray().length) {
                                int n = this.getDoubleArray().length;
                                bl = true;
                                int n8 = 0;
                                while (n8 < n) {
                                    if (this.getDoubleArray()[n8] != extendedDataElementImpl.getDoubleArray()[n8]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n8;
                                }
                            }
                            break;
                        }
                        case 15: {
                            if (this.getStringArray().length == extendedDataElementImpl.getStringArray().length) {
                                int n = this.getStringArray().length;
                                bl = true;
                                int n9 = 0;
                                while (n9 < n) {
                                    String string = this.getStringArray()[n9];
                                    if (string == null && extendedDataElementImpl.getStringArray()[n9] != null) {
                                        bl = false;
                                        break block1;
                                    }
                                    if (!string.equals(extendedDataElementImpl.getStringArray()[n9])) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n9;
                                }
                            }
                            break;
                        }
                        case 17: {
                            if (this.getDateTimeArrayAsLong().length == extendedDataElementImpl.getDateTimeArrayAsLong().length) {
                                int n = this.getDateTimeArrayAsLong().length;
                                bl = true;
                                int n10 = 0;
                                while (n10 < n) {
                                    if (this.getDateTimeArrayAsLong()[n10] != extendedDataElementImpl.getDateTimeArrayAsLong()[n10]) {
                                        bl = false;
                                        break block1;
                                    }
                                    ++n10;
                                }
                            }
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                }
                catch (InvalidExtendedDataElementTypeException invalidExtendedDataElementTypeException) {
                    bl = false;
                }
            }
        }
        return bl;
    }
}

