/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgDataElement;

public class CommonBaseEventImpl
implements ICommonBaseEvent,
ISerializableAsXml,
Serializable {
    static final long serialVersionUID = -4234730049423367771L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("extensionName", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("localInstanceId", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("globalInstanceId", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("msg", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("elapsedTime", Long.TYPE), new ObjectStreamField("severity", Short.TYPE), new ObjectStreamField("priority", Short.TYPE), new ObjectStreamField("repeatCount", Short.TYPE), new ObjectStreamField("sequenceNumber", Long.TYPE), new ObjectStreamField("msgDataElement", class$org$eclipse$hyades$logging$events$IMsgDataElement == null ? (class$org$eclipse$hyades$logging$events$IMsgDataElement = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IMsgDataElement")) : class$org$eclipse$hyades$logging$events$IMsgDataElement), new ObjectStreamField("reporterComponentId", class$org$eclipse$hyades$logging$events$IComponentIdentification == null ? (class$org$eclipse$hyades$logging$events$IComponentIdentification = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IComponentIdentification")) : class$org$eclipse$hyades$logging$events$IComponentIdentification), new ObjectStreamField("sourceComponentId", class$org$eclipse$hyades$logging$events$IComponentIdentification == null ? (class$org$eclipse$hyades$logging$events$IComponentIdentification = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IComponentIdentification")) : class$org$eclipse$hyades$logging$events$IComponentIdentification), new ObjectStreamField("contextDataElements", array$Lorg$eclipse$hyades$logging$events$IContextDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IContextDataElement = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IContextDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IContextDataElement), new ObjectStreamField("extendedDataElements", array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IExtendedDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement), new ObjectStreamField("associatedEvents", array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent == null ? (array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IAssociatedEvent;")) : array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent)};
    public static final String version = "CommonBaseEvent V1.0.0";
    protected IMsgDataElement msgDataElement;
    protected IComponentIdentification reporterComponentId;
    protected IComponentIdentification sourceComponentId;
    protected HashMap contextDataElements = new HashMap();
    protected HashMap extendedDataElements = new HashMap();
    protected HashMap associatedEvents = new HashMap();
    protected String extensionName;
    protected String localInstanceId;
    protected String globalInstanceId;
    protected String creationTime;
    protected long creationTimeValue;
    protected String situationType;
    protected String msg;
    protected long elapsedTime;
    protected short severity;
    protected short priority;
    protected short repeatCount;
    protected long sequenceNumber;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$IMsgDataElement;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$IComponentIdentification;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IContextDataElement;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent;

    protected CommonBaseEventImpl() {
        this.init();
    }

    public void addContextDataElement(IContextDataElement iContextDataElement) {
        this.contextDataElements.put(iContextDataElement.getName(), iContextDataElement);
    }

    public void addExtendedDataElement(IExtendedDataElement iExtendedDataElement) {
        this.extendedDataElements.put(iExtendedDataElement.getName(), iExtendedDataElement);
    }

    public void addAssociatedEvent(IAssociatedEvent iAssociatedEvent) {
        String string = iAssociatedEvent.getAssociationEngine().getName();
        if (string == null) {
            throw new RuntimeException("IAssociatedEvent must be assigned an AssociatineEngine to add it to an instance of ICommonBaseEvent");
        }
        this.associatedEvents.put(string, iAssociatedEvent);
    }

    public IContextDataElement[] getContextDataElements() {
        HashMap hashMap = this.contextDataElements;
        synchronized (hashMap) {
            if (this.contextDataElements.size() > 0) {
                IContextDataElement[] iContextDataElementArray = new IContextDataElement[this.contextDataElements.size()];
                Iterator iterator = this.contextDataElements.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iContextDataElementArray[n] = (IContextDataElement)iterator.next();
                    ++n;
                }
                IContextDataElement[] iContextDataElementArray2 = iContextDataElementArray;
                return iContextDataElementArray2;
            }
            IContextDataElement[] iContextDataElementArray = null;
            return iContextDataElementArray;
        }
    }

    public IExtendedDataElement[] getExtendedDataElements() {
        HashMap hashMap = this.extendedDataElements;
        synchronized (hashMap) {
            if (this.extendedDataElements.size() > 0) {
                IExtendedDataElement[] iExtendedDataElementArray = new IExtendedDataElement[this.extendedDataElements.size()];
                Iterator iterator = this.extendedDataElements.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iExtendedDataElementArray[n] = (IExtendedDataElement)iterator.next();
                    ++n;
                }
                IExtendedDataElement[] iExtendedDataElementArray2 = iExtendedDataElementArray;
                return iExtendedDataElementArray2;
            }
            IExtendedDataElement[] iExtendedDataElementArray = null;
            return iExtendedDataElementArray;
        }
    }

    public IAssociatedEvent[] getAssociatedEvents() {
        HashMap hashMap = this.associatedEvents;
        synchronized (hashMap) {
            if (this.associatedEvents.size() > 0) {
                IAssociatedEvent[] iAssociatedEventArray = new IAssociatedEvent[this.associatedEvents.size()];
                Iterator iterator = this.associatedEvents.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    iAssociatedEventArray[n] = (IAssociatedEvent)iterator.next();
                    ++n;
                }
                IAssociatedEvent[] iAssociatedEventArray2 = iAssociatedEventArray;
                return iAssociatedEventArray2;
            }
            IAssociatedEvent[] iAssociatedEventArray = null;
            return iAssociatedEventArray;
        }
    }

    public IContextDataElement getContextDataElement(String string) {
        return (IContextDataElement)this.contextDataElements.get(string);
    }

    public IExtendedDataElement getExtendedDataElement(String string) {
        return (IExtendedDataElement)this.extendedDataElements.get(string);
    }

    public void removeContextDataElement(String string) {
        this.contextDataElements.remove(string);
    }

    public void removeExtendedDataElement(String string) {
        this.extendedDataElements.remove(string);
    }

    public void clearAssociatedEvents() {
        this.associatedEvents.clear();
    }

    public void clearContextDataElements() {
        this.contextDataElements.clear();
    }

    public void clearExtendedDataElements() {
        this.extendedDataElements.clear();
    }

    public String getCreationTime() {
        if (this.creationTime == null && this.creationTimeValue > 0L) {
            this.creationTime = CbeFormatter.convertDateToXmlSchemaDateTime(this.creationTimeValue);
        }
        return this.creationTime;
    }

    public long getCreationTimeAsLong() {
        if (this.creationTimeValue == 0L && this.creationTime != null) {
            this.creationTimeValue = CbeFormatter.convertXmlSchemaDateTimeToDate(this.creationTime);
        }
        return this.creationTimeValue;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getGlobalInstanceId() {
        return this.globalInstanceId;
    }

    public String getLocalInstanceId() {
        return this.localInstanceId;
    }

    public String getMsg() {
        return this.msg;
    }

    public short getPriority() {
        return this.priority;
    }

    public short getRepeatCount() {
        return this.repeatCount;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSeverity() {
        return this.severity;
    }

    public String getSituationType() {
        return this.situationType;
    }

    public IComponentIdentification getSourceComponentId() {
        return this.sourceComponentId;
    }

    public IMsgDataElement getMsgDataElement() {
        return this.msgDataElement;
    }

    public IComponentIdentification getReporterComponentId() {
        return this.reporterComponentId;
    }

    public void setCreationTime(String string) {
        this.creationTime = string;
        this.creationTimeValue = 0L;
    }

    public void setCreationTime(long l) {
        this.creationTimeValue = l;
        this.creationTime = null;
    }

    public void setElapsedTime(long l) {
        this.elapsedTime = l;
    }

    public void setExtensionName(String string) {
        this.extensionName = string;
    }

    public void setGlobalInstanceId(String string) {
        this.globalInstanceId = string;
    }

    public void setLocalInstanceId(String string) {
        this.localInstanceId = string;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public void setPriority(short s) {
        this.priority = s;
    }

    public void setRepeatCount(short s) {
        this.repeatCount = s;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public void setSeverity(short s) {
        this.severity = s;
    }

    public void setSituationType(String string) {
        this.situationType = string;
    }

    public void setSourceComponentId(IComponentIdentification iComponentIdentification) {
        this.sourceComponentId = iComponentIdentification;
    }

    public void setMsgDataElement(IMsgDataElement iMsgDataElement) {
        this.msgDataElement = iMsgDataElement;
    }

    public void setReporterComponentId(IComponentIdentification iComponentIdentification) {
        this.reporterComponentId = iComponentIdentification;
    }

    public void init() {
        this.clearAssociatedEvents();
        this.clearExtendedDataElements();
        this.clearContextDataElements();
        this.sourceComponentId = null;
        this.reporterComponentId = null;
        this.msgDataElement = null;
        this.extensionName = null;
        this.localInstanceId = null;
        this.creationTime = null;
        this.creationTimeValue = 0L;
        this.situationType = null;
        this.msg = null;
        this.elapsedTime = 0L;
        this.severity = 0;
        this.priority = 0;
        this.repeatCount = 0;
        this.sequenceNumber = 0L;
        this.setGlobalInstanceId(new Guid().toString());
    }

    public String externalizeCanonicalXmlString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public String externalizeCanonicalXmlDocString() {
        return CbeFormatter.toCanonicalXMLDocString(this);
    }

    public void internalizeCanonicalXmlString(String string) {
        CbeFormatter.fromCanonicalXMLString(this, string);
    }

    public void internalizeCanonicalXmlDocString(String string) {
        CbeFormatter.fromCanonicalXMLDocString(this, string);
    }

    public String getCommonBaseEventImplVersion() {
        return version;
    }

    public String getEventSchemaVersion() {
        return CbeFormatter.getEventFormatterVersion();
    }

    public String toString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof CommonBaseEventImpl && this.getClass() == object.getClass()) {
            CommonBaseEventImpl commonBaseEventImpl = (CommonBaseEventImpl)object;
            Object object2 = this.getGlobalInstanceId();
            Object object3 = commonBaseEventImpl.getGlobalInstanceId();
            if ((object2 != null && object2.equals(object3) || object2 == null && object3 == null) && this.getCreationTimeAsLong() == commonBaseEventImpl.getCreationTimeAsLong() && this.getElapsedTime() == commonBaseEventImpl.getElapsedTime() && this.getSeverity() == commonBaseEventImpl.getSeverity() && this.getPriority() == commonBaseEventImpl.getPriority() && this.getRepeatCount() == commonBaseEventImpl.getRepeatCount() && this.getSequenceNumber() == commonBaseEventImpl.getSequenceNumber()) {
                object2 = this.getLocalInstanceId();
                object3 = commonBaseEventImpl.getLocalInstanceId();
                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                    object2 = this.getExtensionName();
                    object3 = commonBaseEventImpl.getExtensionName();
                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                        object2 = this.getSituationType();
                        object3 = commonBaseEventImpl.getSituationType();
                        if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                            object2 = this.getMsg();
                            object3 = commonBaseEventImpl.getMsg();
                            if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                object2 = this.getMsgDataElement();
                                object3 = commonBaseEventImpl.getMsgDataElement();
                                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                    object2 = this.getReporterComponentId();
                                    object3 = commonBaseEventImpl.getReporterComponentId();
                                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                        object2 = this.getSourceComponentId();
                                        object3 = commonBaseEventImpl.getSourceComponentId();
                                        if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                            object2 = this.contextDataElements;
                                            object3 = commonBaseEventImpl.contextDataElements;
                                            if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                object2 = this.extendedDataElements;
                                                object3 = commonBaseEventImpl.extendedDataElements;
                                                if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                    object2 = this.associatedEvents;
                                                    object3 = commonBaseEventImpl.associatedEvents;
                                                    if (object2 != null && object2.equals(object3) || object2 == null && object3 == null) {
                                                        bl = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("extensionName", this.extensionName);
        putField.put("localInstanceId", this.localInstanceId);
        putField.put("globalInstanceId", this.globalInstanceId);
        putField.put("msg", this.msg);
        putField.put("elapsedTime", this.elapsedTime);
        putField.put("severity", this.severity);
        putField.put("priority", this.priority);
        putField.put("repeatCount", this.repeatCount);
        putField.put("sequenceNumber", this.sequenceNumber);
        putField.put("sourceComponentId", this.sourceComponentId);
        if (this.msgDataElement != null) {
            putField.put("msgDataElement", this.msgDataElement);
        }
        if (this.reporterComponentId != null) {
            putField.put("reporterComponentId", this.reporterComponentId);
        }
        if (!this.contextDataElements.isEmpty()) {
            putField.put("contextDataElements", this.contextDataElements.values().toArray());
        }
        if (!this.extendedDataElements.isEmpty()) {
            putField.put("extendedDataElements", this.extendedDataElements.values().toArray());
        }
        if (!this.associatedEvents.isEmpty()) {
            putField.put("associatedEvents", this.associatedEvents.values().toArray());
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        this.contextDataElements = new HashMap();
        this.extendedDataElements = new HashMap();
        this.associatedEvents = new HashMap();
        ObjectInputStream.GetField getField = null;
        getField = objectInputStream.readFields();
        this.extensionName = (String)getField.get("extensionName", this.extensionName);
        this.localInstanceId = (String)getField.get("localInstanceId", this.localInstanceId);
        this.globalInstanceId = (String)getField.get("globalInstanceId", this.globalInstanceId);
        this.msg = (String)getField.get("msg", this.msg);
        this.elapsedTime = getField.get("elapsedTime", this.elapsedTime);
        this.severity = getField.get("severity", this.severity);
        this.priority = getField.get("priority", this.priority);
        this.repeatCount = getField.get("repeatCount", this.repeatCount);
        this.sequenceNumber = getField.get("sequenceNumber", this.sequenceNumber);
        this.msgDataElement = (IMsgDataElement)getField.get("msgDataElement", this.msgDataElement);
        this.reporterComponentId = (IComponentIdentification)getField.get("reporterComponentId", this.reporterComponentId);
        this.sourceComponentId = (IComponentIdentification)getField.get("sourceComponentId", this.sourceComponentId);
        Object[] objectArray = null;
        objectArray = (Object[])getField.get("contextDataElements", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                this.addContextDataElement((IContextDataElement)objectArray[n]);
                ++n;
            }
        }
        objectArray = null;
        objectArray = (Object[])getField.get("extendedDataElements", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IExtendedDataElement iExtendedDataElement = (IExtendedDataElement)objectArray[n];
                this.addExtendedDataElement(iExtendedDataElement);
                ++n;
            }
        }
        objectArray = null;
        objectArray = (Object[])getField.get("associatedEvents", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                this.addAssociatedEvent((IAssociatedEvent)objectArray[n]);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

