/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xmlschema.beans;

import com.ibm.etools.xmlschema.beans.BaseType;
import com.ibm.etools.xmlschema.beans.ComplexType;
import com.ibm.etools.xmlschema.beans.DOMWriter;
import com.ibm.etools.xmlschema.beans.SimpleType;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Factory
implements Serializable {
    protected String xmlFile;
    protected String packageName;
    protected Document document;
    protected String encoding;
    protected String encodingTag;
    protected String dtdFileName;
    protected String dtdPublicId;
    protected String xsdFileName;
    protected String xsdNamespaceURI;
    protected Hashtable importedFileHashtable = new Hashtable();
    protected String rootElementName;
    protected String xmlPrefix = "";
    protected boolean elementQualified = false;
    protected boolean attributeQualified = false;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setXMLFilename(String filename) {
        this.xmlFile = filename;
    }

    public String getXMLFilename() {
        return this.xmlFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncodingTag(String encodingTag) {
        this.encodingTag = encodingTag;
    }

    public String getEncodingTag() {
        return this.encodingTag;
    }

    public void setDTDFileName(String dtdFilename) {
        this.dtdFileName = dtdFilename;
    }

    public String getDTDFileName() {
        return this.dtdFileName;
    }

    public void setPublicId(String publicId) {
        this.dtdPublicId = publicId;
    }

    public String getPublicId() {
        return this.dtdPublicId;
    }

    public void setXSDFileName(String xsdFilename) {
        this.xsdFileName = xsdFilename;
    }

    public String getXSDFileName() {
        return this.xsdFileName;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.xsdNamespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this.xsdNamespaceURI;
    }

    public void setPrefix(String prefix) {
        this.xmlPrefix = prefix == null ? "" : String.valueOf(prefix) + ":";
    }

    public String getPrefix() {
        return this.xmlPrefix;
    }

    public void setElementQualified(boolean qualify) {
        this.elementQualified = qualify;
    }

    public boolean isElementQualified() {
        return this.elementQualified;
    }

    public void setAttributeQualified(boolean qualify) {
        this.attributeQualified = qualify;
    }

    public boolean isAttributeQualified() {
        return this.attributeQualified;
    }

    public void addImportedFileInfo(String filename, String nsprefix, String nsURI) {
        this.importedFileHashtable.put(nsprefix, String.valueOf(nsURI) + " " + filename);
    }

    private String getLocalName(Element el) {
        String name = el.getTagName();
        if (name.lastIndexOf(":") != -1) {
            return name.substring(name.lastIndexOf(":") + 1);
        }
        return name;
    }

    private void setRootElementName(String name) {
        if (this.rootElementName != null) {
            return;
        }
        this.rootElementName = name;
    }

    public BaseType loadDocument(String classname, String xmlFile) throws Exception {
        this.xmlFile = xmlFile;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.document = docBuilder.parse(xmlFile);
            Element rootElement = this.document.getDocumentElement();
            this.setRootElementName(this.getLocalName(rootElement));
            return this.newInstance(rootElement, classname);
        }
        catch (ParserConfigurationException ex) {
            System.out.println("JAXP Exception: Factory::loadDocument() " + ex);
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    public BaseType loadDocument(String classname, InputSource source) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.document = docBuilder.parse(source);
            Element rootElement = this.document.getDocumentElement();
            this.setRootElementName(this.getLocalName(rootElement));
            return this.newInstance(rootElement, classname);
        }
        catch (ParserConfigurationException ex) {
            System.out.println("JAXP Exception: Factory::loadDocument() " + ex);
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    public BaseType loadDocument(String classname, Element element) {
        try {
            ComplexType domElement = (ComplexType)this.newInstance(element, classname);
            this.setRootElementName(this.getLocalName(element));
            return domElement;
        }
        catch (Exception e) {
            System.out.println("Exception: Factory::loadDocument() " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void save(String filename) throws Exception {
        String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
        new DOMWriter(this.document, filename, outputEncoding, this.encodingTag, this.getDocTypeString());
    }

    public void save() throws Exception {
        if (this.xmlFile != null) {
            String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
            new DOMWriter(this.document, this.xmlFile, outputEncoding, this.encodingTag, this.getDocTypeString());
        }
    }

    public void save(OutputStream outStream) throws Exception {
        String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
        new DOMWriter(this.document, outStream, outputEncoding, this.encodingTag, this.getDocTypeString());
    }

    public ComplexType createRootDOMFromComplexType(String classname, String rootElementName) {
        return (ComplexType)this.createRootDOMHelper(classname, rootElementName);
    }

    public SimpleType createRootDOMFromSimpleType(String classname, String rootElementName) {
        return (SimpleType)this.createRootDOMHelper(classname, rootElementName);
    }

    private Object createRootDOMHelper(String classname, String rootElementName) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            System.out.println("JAXP Exception: Factory::createRootDOMHelper() " + ex);
            return null;
        }
        this.rootElementName = rootElementName;
        Element childElement = this.document.createElement(rootElementName);
        this.document.appendChild(childElement);
        if (this.xsdFileName != null && !this.xsdFileName.equals("")) {
            childElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (this.xsdNamespaceURI != null && !this.xsdNamespaceURI.equals("")) {
                int index = rootElementName.indexOf(":");
                if (index > 0) {
                    String prefix = ":" + rootElementName.substring(0, index);
                    childElement.setAttribute("xmlns" + prefix, this.xsdNamespaceURI);
                } else {
                    childElement.setAttribute("xmlns", this.xsdNamespaceURI);
                }
                Enumeration enumeration = this.importedFileHashtable.keys();
                String importedFileValidation = "";
                while (enumeration.hasMoreElements()) {
                    Object nsprefix = enumeration.nextElement();
                    String nsURI = (String)this.importedFileHashtable.get(nsprefix);
                    int blank = nsURI.indexOf(32);
                    childElement.setAttribute("xmlns:" + nsprefix, nsURI.substring(0, blank));
                    importedFileValidation = String.valueOf(importedFileValidation) + " " + nsURI;
                }
                childElement.setAttribute("xsi:schemaLocation", String.valueOf(this.xsdNamespaceURI) + " " + this.xsdFileName + importedFileValidation);
            } else {
                childElement.setAttribute("xsi:noNamespaceSchemaLocation", this.xsdFileName);
            }
        }
        return this.newInstance(childElement, classname);
    }

    public ComplexType createDOMElementFromComplexType(String classname, String elementName) {
        String prefix = "";
        if (this.isElementQualified()) {
            prefix = this.getPrefix();
        }
        Element childElement = this.document.createElement(String.valueOf(prefix) + elementName);
        return (ComplexType)this.newInstance(childElement, classname);
    }

    public SimpleType createDOMElementFromSimpleType(String classname, String elementName) {
        String prefix = "";
        if (this.isElementQualified()) {
            prefix = this.getPrefix();
        }
        Element childElement = this.document.createElement(String.valueOf(prefix) + elementName);
        return (SimpleType)this.newInstance(childElement, classname);
    }

    protected BaseType newInstance(Node node, String className) {
        try {
            String fullname = className;
            if (this.packageName != null && !this.packageName.equals("")) {
                fullname = String.valueOf(this.packageName) + "." + className;
            }
            Class<?> javaClass = Class.forName(fullname);
            BaseType object = (BaseType)javaClass.newInstance();
            if (node instanceof Element) {
                object.setXMLElement((Element)node);
            } else {
                object.setXMLAttribute((Attr)node);
            }
            object.setFactory(this);
            return object;
        }
        catch (Exception e) {
            System.out.println("Factory::newInstance() error ***" + e);
            return null;
        }
    }

    protected Element createXMLElementAndText(String elementName, String elementValue) {
        String prefix = "";
        if (this.isElementQualified()) {
            prefix = this.getPrefix();
        }
        Element item = this.document.createElement(String.valueOf(prefix) + elementName);
        Text text = this.document.createTextNode(elementValue);
        item.appendChild(text);
        return item;
    }

    protected Attr createAttribute(String name, Element parentElement) {
        String prefix = "";
        if (this.isAttributeQualified()) {
            prefix = this.getPrefix();
        }
        Attr attrNode = this.document.createAttribute(String.valueOf(prefix) + name);
        parentElement.setAttributeNode(attrNode);
        return attrNode;
    }

    protected Text createText(Element parentElement, String value) {
        Text textNode = this.document.createTextNode(value);
        parentElement.appendChild(textNode);
        return textNode;
    }

    private String getDocTypeString() {
        String docType = "";
        if (this.dtdFileName != null && !this.dtdFileName.equals("")) {
            docType = this.dtdPublicId == null || this.dtdPublicId.equals("") ? "<!DOCTYPE " + this.rootElementName + " SYSTEM \"" + this.dtdFileName + "\"" + ">" : "<!DOCTYPE " + this.rootElementName + " PUBLIC \"" + this.dtdPublicId + "\"" + " \"" + this.dtdFileName + "\"" + ">";
        }
        return docType;
    }
}

