/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.exceptions.InvalidExtendedDataElementTypeException;

public class ExtendedDataElementImpl
implements IExtendedDataElement,
Serializable,
Cloneable {
    static final long serialVersionUID = 6633427043459375461L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = ExtendedDataElementImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("value", class$java$lang$Object == null ? (class$java$lang$Object = ExtendedDataElementImpl.class$("java.lang.Object")) : class$java$lang$Object), new ObjectStreamField("children", array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement = ExtendedDataElementImpl.class$("[Lorg.eclipse.hyades.logging.events.IExtendedDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement)};
    private String name = null;
    private int type = -1;
    private Object value = null;
    private ArrayList children = new ArrayList();
    private String id = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement;

    protected ExtendedDataElementImpl() {
    }

    public void addChildDataElement(IExtendedDataElement iExtendedDataElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(iExtendedDataElement);
    }

    public IExtendedDataElement getChildDataElement(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                if (((IExtendedDataElement)this.children.get(n)).getName().equals(string)) {
                    return (IExtendedDataElement)this.children.get(n);
                }
                ++n;
            }
        }
        return null;
    }

    public List getChildDataElements() {
        return this.children;
    }

    public void removeChildDataElement(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                if (((IExtendedDataElement)this.children.get(n)).getName().equals(string)) {
                    this.children.remove(n--);
                }
                ++n;
            }
        }
    }

    public void clearChildDataElements() {
        this.children = null;
    }

    public List getValues() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String[])) {
            throw new InvalidExtendedDataElementTypeException("getValues was called for an illegal event property type");
        }
        return Arrays.asList((String[])this.value);
    }

    public String[] getValuesAsStringArray() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String[])) {
            throw new InvalidExtendedDataElementTypeException("getValues was called for an illegal event property type");
        }
        return (String[])this.value;
    }

    public char[] getHexValues() {
        return this.getHexBinarys();
    }

    public byte[] getHexValue() {
        return this.getHexBinary();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeValue() {
        return this.type;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "byte";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "long";
            }
            case 7: {
                return "boolean";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "string";
            }
            case 8: {
                return "dateTime";
            }
            case 9: {
                return "byteArray";
            }
            case 10: {
                return "shortArray";
            }
            case 11: {
                return "intArray";
            }
            case 12: {
                return "longArray";
            }
            case 16: {
                return "booleanArray";
            }
            case 13: {
                return "floatArray";
            }
            case 14: {
                return "doubleArray";
            }
            case 15: {
                return "stringArray";
            }
            case 17: {
                return "dateTimeArray";
            }
            case 28: {
                return "hexBinary";
            }
        }
        return null;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        if (n < 0 || n > 28) {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
        this.type = n;
    }

    public void setType(String string) {
        if (string.equals("byte")) {
            this.type = 0;
        } else if (string.equals("boolean")) {
            this.type = 7;
        } else if (string.equals("short")) {
            this.type = 1;
        } else if (string.equals("int")) {
            this.type = 2;
        } else if (string.equals("long")) {
            this.type = 3;
        } else if (string.equals("float")) {
            this.type = 4;
        } else if (string.equals("double")) {
            this.type = 5;
        } else if (string.equals("dateTime")) {
            this.type = 8;
        } else if (string.equals("string")) {
            this.type = 6;
        } else if (string.equals("byteArray")) {
            this.type = 9;
        } else if (string.equals("booleanArray")) {
            this.type = 16;
        } else if (string.equals("shortArray")) {
            this.type = 10;
        } else if (string.equals("intArray")) {
            this.type = 11;
        } else if (string.equals("longArray")) {
            this.type = 12;
        } else if (string.equals("floatArray")) {
            this.type = 13;
        } else if (string.equals("doubleArray")) {
            this.type = 14;
        } else if (string.equals("dateTimeArray")) {
            this.type = 17;
        } else if (string.equals("stringArray")) {
            this.type = 15;
        } else if (string.equals("hexBinary")) {
            this.type = 28;
        } else {
            throw new InvalidExtendedDataElementTypeException("setType was called with an invalid datatype value of  " + this.getType());
        }
    }

    public void setValues(String[] stringArray) {
        this.value = stringArray;
    }

    public void setHexValues(char[] cArray) {
        this.type = 28;
        this.value = cArray;
    }

    public void setHexValue(byte[] byArray) {
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                cArray[n] = (char)(byArray[n] + 128);
                ++n;
            }
        }
        this.setHexValues(cArray);
    }

    public String getString() {
        if (this.type != 6) {
            throw new InvalidExtendedDataElementTypeException("getString was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String)) {
            throw new InvalidExtendedDataElementTypeException("getString was called for an illegal event property type");
        }
        return (String)this.value;
    }

    public long getDateTimeAsLong() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeAsLong was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0L;
        }
        if (!(this.value instanceof String)) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeAsLong was called for an illegal event property type");
        }
        return CbeFormatter.convertXmlSchemaDateTimeToDate((String)this.value);
    }

    public String getDateTime() {
        if (this.type != 8) {
            throw new InvalidExtendedDataElementTypeException("getDateTime was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String)) {
            throw new InvalidExtendedDataElementTypeException("getDateTime was called for an illegal event property type");
        }
        return (String)this.value;
    }

    public boolean getBoolean() {
        if (this.type != 7) {
            throw new InvalidExtendedDataElementTypeException("getBoolean was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return true;
        }
        if (!(this.value instanceof Boolean)) {
            throw new InvalidExtendedDataElementTypeException("getBoolean was called for an illegal event property type");
        }
        return (Boolean)this.value;
    }

    public byte getByte() {
        if (this.type != 0) {
            throw new InvalidExtendedDataElementTypeException("getByte was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0;
        }
        if (!(this.value instanceof Byte)) {
            throw new InvalidExtendedDataElementTypeException("getByte was called for an illegal event property type");
        }
        return (Byte)this.value;
    }

    public short getShort() {
        if (this.type != 1) {
            throw new InvalidExtendedDataElementTypeException("getShort was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0;
        }
        if (!(this.value instanceof Short)) {
            throw new InvalidExtendedDataElementTypeException("getShort was called for an illegal event property type");
        }
        return (Short)this.value;
    }

    public int getInt() {
        if (this.type != 2) {
            throw new InvalidExtendedDataElementTypeException("getInt was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0;
        }
        if (!(this.value instanceof Integer)) {
            throw new InvalidExtendedDataElementTypeException("getInt was called for an illegal event property type");
        }
        return (Integer)this.value;
    }

    public long getLong() {
        if (this.type != 3) {
            throw new InvalidExtendedDataElementTypeException("getLong was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0L;
        }
        if (!(this.value instanceof Long)) {
            throw new InvalidExtendedDataElementTypeException("getLong was called for an illegal event property type");
        }
        return (Long)this.value;
    }

    public float getFloat() {
        if (this.type != 4) {
            throw new InvalidExtendedDataElementTypeException("getFloat was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0.0f;
        }
        if (!(this.value instanceof Float)) {
            throw new InvalidExtendedDataElementTypeException("getFloat was called for an illegal event property type");
        }
        return ((Float)this.value).floatValue();
    }

    public double getDouble() {
        if (this.type != 5) {
            throw new InvalidExtendedDataElementTypeException("getDouble was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return 0.0;
        }
        if (!(this.value instanceof Double)) {
            throw new InvalidExtendedDataElementTypeException("getDouble was called for an illegal event property type");
        }
        return (Double)this.value;
    }

    public String[] getStringArray() {
        if (this.type != 15) {
            throw new InvalidExtendedDataElementTypeException("getStringArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String[])) {
            throw new InvalidExtendedDataElementTypeException("getStringArray was called for an illegal event property type");
        }
        return (String[])this.value;
    }

    public long[] getDateTimeArrayAsLong() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArrayAsLong was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String[])) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArrayAsLong was called for an illegal event property type");
        }
        String[] stringArray = (String[])this.value;
        long[] lArray = null;
        if (stringArray != null) {
            lArray = new long[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                lArray[n] = CbeFormatter.convertXmlSchemaDateTimeToDate(stringArray[n]);
                ++n;
            }
        }
        return lArray;
    }

    public String[] getDateTimeArray() {
        if (this.type != 17) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String[])) {
            throw new InvalidExtendedDataElementTypeException("getDateTimeArray was called for an illegal event property type");
        }
        return (String[])this.value;
    }

    public boolean[] getBooleanArray() {
        if (this.type != 16) {
            throw new InvalidExtendedDataElementTypeException("getBooleanArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof boolean[])) {
            throw new InvalidExtendedDataElementTypeException("getBooleanArray was called for an illegal event property type");
        }
        return (boolean[])this.value;
    }

    public byte[] getByteArray() {
        if (this.type != 9) {
            throw new InvalidExtendedDataElementTypeException("getByteArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof byte[])) {
            throw new InvalidExtendedDataElementTypeException("getByteArray was called for an illegal event property type");
        }
        return (byte[])this.value;
    }

    public short[] getShortArray() {
        if (this.type != 10) {
            throw new InvalidExtendedDataElementTypeException("getShortArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof short[])) {
            throw new InvalidExtendedDataElementTypeException("getShortArray was called for an illegal event property type");
        }
        return (short[])this.value;
    }

    public int[] getIntArray() {
        if (this.type != 11) {
            throw new InvalidExtendedDataElementTypeException("getIntArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof int[])) {
            throw new InvalidExtendedDataElementTypeException("getIntArray was called for an illegal event property type");
        }
        return (int[])this.value;
    }

    public long[] getLongArray() {
        if (this.type != 12) {
            throw new InvalidExtendedDataElementTypeException("getLongArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof long[])) {
            throw new InvalidExtendedDataElementTypeException("getLongArray was called for an illegal event property type");
        }
        return (long[])this.value;
    }

    public float[] getFloatArray() {
        if (this.type != 13) {
            throw new InvalidExtendedDataElementTypeException("getFloatArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof float[])) {
            throw new InvalidExtendedDataElementTypeException("getFloatArray was called for an illegal event property type");
        }
        return (float[])this.value;
    }

    public double[] getDoubleArray() {
        if (this.type != 14) {
            throw new InvalidExtendedDataElementTypeException("getDoubleArray was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof double[])) {
            throw new InvalidExtendedDataElementTypeException("getDoubleArray was called for an illegal event property type");
        }
        return (double[])this.value;
    }

    public char[] getHexBinarys() {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("getHexBinarys was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof char[])) {
            throw new InvalidExtendedDataElementTypeException("getHexBinarys was called for an illegal event property type");
        }
        return (char[])this.value;
    }

    public byte[] getHexBinary() {
        if (this.type != 28) {
            throw new InvalidExtendedDataElementTypeException("getHexBinary was called for an event property of type " + this.getType());
        }
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof char[])) {
            throw new InvalidExtendedDataElementTypeException("getHexBinary was called for an illegal event property type");
        }
        byte[] byArray = null;
        char[] cArray = (char[])this.value;
        if (cArray != null) {
            byArray = new byte[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                byArray[n] = cArray[n] > '\u00ff' ? 127 : (byte)(cArray[n] - 128);
                ++n;
            }
        }
        return byArray;
    }

    public void setString(String string) {
        this.type = 6;
        this.value = string;
    }

    public void setDateTime(long l) {
        this.type = 8;
        this.value = CbeFormatter.convertDateToXmlSchemaDateTime(l);
    }

    public void setDateTime(String string) {
        this.type = 8;
        this.value = string;
    }

    public void setBoolean(boolean bl) {
        this.type = 7;
        this.value = new Boolean(bl);
    }

    public void setByte(byte by) {
        this.type = 0;
        this.value = new Byte(by);
    }

    public void setShort(short s) {
        this.type = 1;
        this.value = new Short(s);
    }

    public void setInt(int n) {
        this.type = 2;
        this.value = new Integer(n);
    }

    public void setLong(long l) {
        this.type = 3;
        this.value = new Long(l);
    }

    public void setFloat(float f) {
        this.type = 4;
        this.value = new Float(f);
    }

    public void setDouble(double d) {
        this.type = 5;
        this.value = new Double(d);
    }

    public void setStringArray(String[] stringArray) {
        this.type = 15;
        this.value = stringArray;
    }

    public void setDateTimeArray(long[] lArray) {
        this.type = 17;
        if (lArray != null) {
            String[] stringArray = new String[lArray.length];
            int n = 0;
            while (n < lArray.length) {
                stringArray[n] = CbeFormatter.convertDateToXmlSchemaDateTime(lArray[n]);
                ++n;
            }
            this.value = stringArray;
        } else {
            lArray = null;
        }
    }

    public void setDateTimeArray(String[] stringArray) {
        this.type = 17;
        this.value = stringArray;
    }

    public void setBooleanArray(boolean[] blArray) {
        this.type = 16;
        this.value = blArray;
    }

    public void setByteArray(byte[] byArray) {
        this.type = 9;
        this.value = byArray;
    }

    public void setShortArray(short[] sArray) {
        this.type = 10;
        this.value = sArray;
    }

    public void setIntArray(int[] nArray) {
        this.type = 11;
        this.value = nArray;
    }

    public void setLongArray(long[] lArray) {
        this.type = 12;
        this.value = lArray;
    }

    public void setFloatArray(float[] fArray) {
        this.type = 13;
        this.value = fArray;
    }

    public void setDoubleArray(double[] dArray) {
        this.type = 14;
        this.value = dArray;
    }

    public void setHexBinarys(char[] cArray) {
        this.type = 28;
        this.value = cArray;
    }

    public void setHexBinary(byte[] byArray) {
        this.type = 28;
        if (byArray != null) {
            char[] cArray = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                cArray[n] = (char)(byArray[n] + 128);
                ++n;
            }
            this.value = cArray;
        } else {
            byArray = null;
        }
    }

    public void clearValues() {
        this.init();
    }

    public void init() {
        this.type = -1;
        this.name = null;
        this.id = null;
        this.value = null;
        this.children = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ExtendedDataElementImpl) {
            ExtendedDataElementImpl extendedDataElementImpl = (ExtendedDataElementImpl)object;
            if ((this.getName() != null && this.getName().equals(extendedDataElementImpl.getName()) || this.getName() == null && extendedDataElementImpl.getName() == null) && this.getTypeValue() == extendedDataElementImpl.getTypeValue() && (this.children != null && ((AbstractList)this.children).equals(extendedDataElementImpl.children) || this.children == null && extendedDataElementImpl.children == null)) {
                if (this.value != null && extendedDataElementImpl.value != null) {
                    if (this.value instanceof Boolean && extendedDataElementImpl.value instanceof Boolean) {
                        return ((Boolean)this.value).equals((Boolean)extendedDataElementImpl.value);
                    }
                    if (this.value instanceof boolean[] && extendedDataElementImpl.value instanceof boolean[]) {
                        if (((boolean[])this.value).length == ((boolean[])extendedDataElementImpl.value).length) {
                            int n = 0;
                            while (n < ((boolean[])this.value).length) {
                                if (((boolean[])this.value)[n] != ((boolean[])extendedDataElementImpl.value)[n]) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                    } else {
                        if (this.value instanceof Byte && extendedDataElementImpl.value instanceof Byte) {
                            return ((Byte)this.value).equals((Byte)extendedDataElementImpl.value);
                        }
                        if (this.value instanceof byte[] && extendedDataElementImpl.value instanceof byte[]) {
                            if (((byte[])this.value).length == ((byte[])extendedDataElementImpl.value).length) {
                                int n = 0;
                                while (n < ((byte[])this.value).length) {
                                    if (((byte[])this.value)[n] != ((byte[])extendedDataElementImpl.value)[n]) {
                                        return false;
                                    }
                                    ++n;
                                }
                                return true;
                            }
                        } else {
                            if (this.value instanceof String && extendedDataElementImpl.value instanceof String) {
                                return ((String)this.value).equals((String)extendedDataElementImpl.value);
                            }
                            if (this.value instanceof String[] && extendedDataElementImpl.value instanceof String[]) {
                                if (((String[])this.value).length == ((String[])extendedDataElementImpl.value).length) {
                                    int n = 0;
                                    while (n < ((String[])this.value).length) {
                                        if (!((String[])this.value)[n].equals(((String[])extendedDataElementImpl.value)[n])) {
                                            return false;
                                        }
                                        ++n;
                                    }
                                    return true;
                                }
                            } else {
                                if (this.value instanceof Double && extendedDataElementImpl.value instanceof Double) {
                                    return ((Double)this.value).equals((Double)extendedDataElementImpl.value);
                                }
                                if (this.value instanceof double[] && extendedDataElementImpl.value instanceof double[]) {
                                    if (((double[])this.value).length == ((double[])extendedDataElementImpl.value).length) {
                                        int n = 0;
                                        while (n < ((double[])this.value).length) {
                                            if (((double[])this.value)[n] != ((double[])extendedDataElementImpl.value)[n]) {
                                                return false;
                                            }
                                            ++n;
                                        }
                                        return true;
                                    }
                                } else {
                                    if (this.value instanceof Float && extendedDataElementImpl.value instanceof Float) {
                                        return ((Float)this.value).equals((Float)extendedDataElementImpl.value);
                                    }
                                    if (this.value instanceof float[] && extendedDataElementImpl.value instanceof float[]) {
                                        if (((float[])this.value).length == ((float[])extendedDataElementImpl.value).length) {
                                            int n = 0;
                                            while (n < ((float[])this.value).length) {
                                                if (((float[])this.value)[n] != ((float[])extendedDataElementImpl.value)[n]) {
                                                    return false;
                                                }
                                                ++n;
                                            }
                                            return true;
                                        }
                                    } else if (this.value instanceof char[] && extendedDataElementImpl.value instanceof char[]) {
                                        if (((char[])this.value).length == ((char[])extendedDataElementImpl.value).length) {
                                            int n = 0;
                                            while (n < ((char[])this.value).length) {
                                                if (((char[])this.value)[n] != ((char[])extendedDataElementImpl.value)[n]) {
                                                    return false;
                                                }
                                                ++n;
                                            }
                                            return true;
                                        }
                                    } else {
                                        if (this.value instanceof Integer && extendedDataElementImpl.value instanceof Integer) {
                                            return ((Integer)this.value).equals((Integer)extendedDataElementImpl.value);
                                        }
                                        if (this.value instanceof int[] && extendedDataElementImpl.value instanceof int[]) {
                                            if (((int[])this.value).length == ((int[])extendedDataElementImpl.value).length) {
                                                int n = 0;
                                                while (n < ((int[])this.value).length) {
                                                    if (((int[])this.value)[n] != ((int[])extendedDataElementImpl.value)[n]) {
                                                        return false;
                                                    }
                                                    ++n;
                                                }
                                                return true;
                                            }
                                        } else {
                                            if (this.value instanceof Long && extendedDataElementImpl.value instanceof Long) {
                                                return ((Long)this.value).equals((Long)extendedDataElementImpl.value);
                                            }
                                            if (this.value instanceof long[] && extendedDataElementImpl.value instanceof long[]) {
                                                if (((long[])this.value).length == ((long[])extendedDataElementImpl.value).length) {
                                                    int n = 0;
                                                    while (n < ((long[])this.value).length) {
                                                        if (((long[])this.value)[n] != ((long[])extendedDataElementImpl.value)[n]) {
                                                            return false;
                                                        }
                                                        ++n;
                                                    }
                                                    return true;
                                                }
                                            } else {
                                                if (this.value instanceof Short && extendedDataElementImpl.value instanceof Short) {
                                                    return ((Short)this.value).equals((Short)extendedDataElementImpl.value);
                                                }
                                                if (this.value instanceof short[] && extendedDataElementImpl.value instanceof short[] && ((short[])this.value).length == ((short[])extendedDataElementImpl.value).length) {
                                                    int n = 0;
                                                    while (n < ((short[])this.value).length) {
                                                        if (((short[])this.value)[n] != ((short[])extendedDataElementImpl.value)[n]) {
                                                            return false;
                                                        }
                                                        ++n;
                                                    }
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (this.value == null && extendedDataElementImpl.value == null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("name", this.name);
        putField.put("type", this.type);
        putField.put("value", this.value);
        if (this.children != null && !this.children.isEmpty()) {
            putField.put("children", this.children.toArray(new IExtendedDataElement[this.children.size()]));
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = null;
        getField = objectInputStream.readFields();
        this.name = (String)getField.get("name", this.name);
        this.type = getField.get("type", this.type);
        this.value = getField.get("value", this.value);
        Object[] objectArray = null;
        objectArray = (Object[])getField.get("children", null);
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.addChildDataElement((IExtendedDataElement)objectArray[n2]);
                ++n2;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedDataElementImpl extendedDataElementImpl = (ExtendedDataElementImpl)super.clone();
        Object var2_2 = null;
        if (this.children != null) {
            extendedDataElementImpl.children = (ArrayList)this.children.clone();
            int n = 0;
            while (n < this.children.size()) {
                var2_2 = this.children.get(n);
                if (var2_2 instanceof ExtendedDataElementImpl) {
                    extendedDataElementImpl.children.set(n, (IExtendedDataElement)((ExtendedDataElementImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.value != null) {
            if (this.value instanceof Boolean) {
                extendedDataElementImpl.value = new Boolean((Boolean)this.value);
            } else if (this.value instanceof boolean[]) {
                extendedDataElementImpl.value = ((boolean[])this.value).clone();
            } else if (this.value instanceof Byte) {
                extendedDataElementImpl.value = new Byte((Byte)this.value);
            } else if (this.value instanceof byte[]) {
                extendedDataElementImpl.value = ((byte[])this.value).clone();
            } else if (this.value instanceof String) {
                extendedDataElementImpl.value = new String((String)this.value);
            } else if (this.value instanceof String[]) {
                extendedDataElementImpl.value = ((String[])this.value).clone();
            } else if (this.value instanceof Double) {
                extendedDataElementImpl.value = new Double((Double)this.value);
            } else if (this.value instanceof double[]) {
                extendedDataElementImpl.value = ((double[])this.value).clone();
            } else if (this.value instanceof Float) {
                extendedDataElementImpl.value = new Float(((Float)this.value).floatValue());
            } else if (this.value instanceof float[]) {
                extendedDataElementImpl.value = ((float[])this.value).clone();
            } else if (this.value instanceof char[]) {
                extendedDataElementImpl.value = ((char[])this.value).clone();
            } else if (this.value instanceof Integer) {
                extendedDataElementImpl.value = new Integer((Integer)this.value);
            } else if (this.value instanceof int[]) {
                extendedDataElementImpl.value = ((int[])this.value).clone();
            } else if (this.value instanceof Long) {
                extendedDataElementImpl.value = new Long((Long)this.value);
            } else if (this.value instanceof long[]) {
                extendedDataElementImpl.value = ((long[])this.value).clone();
            } else if (this.value instanceof Short) {
                extendedDataElementImpl.value = new Short((Short)this.value);
            } else if (this.value instanceof short[]) {
                extendedDataElementImpl.value = ((short[])this.value).clone();
            }
        }
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, int n, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setValues(new String[]{string2});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, int n, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(6);
        extendedDataElementImpl.setValues(new String[]{string2});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(6);
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChild(String string) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithBooleanArrayValue(String string, boolean[] blArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(16);
        String[] stringArray = new String[blArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(blArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithBooleanValue(String string, boolean bl) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(7);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(bl)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithByteArrayValue(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(9);
        String[] stringArray = new String[byArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(byArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithByteValue(String string, byte by) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(0);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(by)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateArrayValue(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(17);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = String.valueOf(stringArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray2);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateAsLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(8);
        extendedDataElementImpl.setValues(new String[]{CbeFormatter.convertDateToXmlSchemaDateTime(l)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDatesAsLongValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(17);
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = CbeFormatter.convertDateToXmlSchemaDateTime(lArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDateValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(8);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(string2)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDoubleArrayValue(String string, double[] dArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(14);
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(dArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithDoubleValue(String string, double d) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(5);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(d)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithFloatArrayValue(String string, float[] fArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(13);
        String[] stringArray = new String[fArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(fArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithFloatValue(String string, float f) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(4);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(f)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithHexValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(28);
        char[] cArray = new char[string2.length()];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = string2.charAt(n);
            ++n;
        }
        extendedDataElementImpl.setHexValues(cArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithHexValueAsByteArray(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(28);
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)(byArray[n] + 128);
            ++n;
        }
        extendedDataElementImpl.setHexValues(cArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithIntArrayValue(String string, int[] nArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(11);
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(nArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithIntValue(String string, int n) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(2);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(n)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithLongArrayValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(12);
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(lArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(3);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(l)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithShortArrayValue(String string, short[] sArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(10);
        String[] stringArray = new String[sArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(sArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addChildWithShortValue(String string, short s) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(1);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(s)});
        this.addChildDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

