/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject;
import org.eclipse.hyades.execution.core.impl.JavaTaskExecutorImpl;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

public class JavaTaskExecutorStub
extends ExecutorStub {
    private AgentImpl agent;
    private boolean isAgentActive;

    public JavaTaskExecutorStub() {
    }

    public JavaTaskExecutorStub(IExecutionComponent iExecutionComponent) {
        super(iExecutionComponent);
    }

    public void launch() throws ExecutionComponentStateException {
        if (!this.isAgentActive()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The remote agent \"");
            stringBuffer.append(this.agent.getName());
            stringBuffer.append("\" is not active");
            throw new ExecutionComponentStateException(1, stringBuffer.toString());
        }
        super.launch();
    }

    public IExecutableObject getCompatibleExecutableObject(String string) throws ClassNotFoundException {
        IExecutableObject iExecutableObject = super.getCompatibleExecutableObject(string);
        if (!(iExecutableObject instanceof IJavaTaskExecutableObject)) {
            throw new ClassCastException("Component factory returned an incorrect type; expected an IJavaTaskExecutableObject");
        }
        return iExecutableObject;
    }

    public void init() {
        super.init();
        SessionImpl sessionImpl = (SessionImpl)((Object)((SessionStub)this.getSessionContext()).getDelegate());
        this.agent = (AgentImpl)AgentFactory.createAgent(sessionImpl.getAgent().getProcess(), "Executor$" + this.getUniqueId(), "tester");
        this.agent.setAutoAttach(true);
        this.agent.addAgentListener(new AgentListener(){

            public void agentActive(Agent agent) {
                JavaTaskExecutorStub.this.setAgentActive(true);
                JavaTaskExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)JavaTaskExecutorStub.this, 2));
            }

            public void agentInactive(Agent agent) {
                JavaTaskExecutorStub.this.setAgentActive(false);
                JavaTaskExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)JavaTaskExecutorStub.this, 4));
            }

            public void error(Agent agent, String string, String string2) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ERROR: Agent \"");
                stringBuffer.append(agent.getName());
                stringBuffer.append("\"\nERROR ID: \"");
                stringBuffer.append(string);
                stringBuffer.append("\"\nERROR MESSAGE: \"");
                stringBuffer.append(string2);
                stringBuffer.append("\"\n");
                System.err.println(stringBuffer.toString());
            }

            public void handleCommand(Agent agent, CommandElement commandElement) {
                System.out.println(agent.getName() + " handleCommand() called");
            }
        });
        ((JavaTaskExecutorImpl)this.delegate).init();
    }

    public void sendMessage(IControlMessage iControlMessage) throws MessageDeliveryException {
        CustomCommand customCommand = new CustomCommand();
        customCommand.setData(iControlMessage.getMessageData());
        try {
            this.agent.invokeCustomCommand(customCommand);
        }
        catch (InactiveAgentException inactiveAgentException) {
            throw new MessageDeliveryException((Throwable)new ExecutionComponentStateException(1, "The monitoring agent is not active"));
        }
    }

    private synchronized void setAgentActive(boolean bl) {
        this.isAgentActive = bl;
    }

    private synchronized boolean isAgentActive() {
        return this.isAgentActive;
    }

    public void addChild(IExecutionComponent iExecutionComponent) {
        if (iExecutionComponent instanceof JavaTaskRemoteHyadesComponentStub) {
            ((JavaTaskRemoteHyadesComponentStub)iExecutionComponent).setAgent(this.agent);
        }
        super.addChild(iExecutionComponent);
    }

    public boolean supportsControlEvent(String string) {
        return false;
    }

    public String performControlEvent(String string) {
        return "";
    }
}

