/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import org.eclipse.hyades.execution.recorder.http.remote.TicketDispatcher;
import org.eclipse.hyades.execution.recorder.http.remote.TimeStampDispatcher;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;

public class PacketWriter {
    static final int ENCODING_TYPE_NONE = 0;
    static final int ENCODING_TYPE_BASE64 = 1;
    static final int ENCODING_TYPE_ASCIIFY = 2;
    static final String PACKET_TAG = "<TRCPacket>\r\n";
    static final String XML_IDENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<TRACE>\r\n\r\n";
    static final String DATA_TAGEND = "]]></data>\r\n";
    static final String PACKET_TAGEND = "</TRCPacket>\r\n\r\n";
    static int iTicket = 0;
    static long lTimeRef = 0L;
    Date date = new Date();
    static int encodedLength = -1;
    static boolean bStopRecording = false;
    private RecorderAgent agent;
    private static final String mappings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String filler = "=";

    public PacketWriter(RecorderAgent recorderAgent) {
        this.agent = recorderAgent;
        bStopRecording = false;
    }

    public synchronized boolean writePacket(boolean bl, boolean bl2, int n, byte[] byArray, int n2) {
        boolean bl3 = false;
        iTicket = TicketDispatcher.getTicket();
        String string = null;
        String string2 = null;
        int n3 = 0;
        boolean bl4 = false;
        String string3 = new String(byArray, 0, n2);
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        String string4 = null;
        byte[] byArray2 = null;
        try {
            encodedLength = -1;
            int n7 = this.getHTTPMessageLocation(bl2, string3);
            if (n7 < 0) {
                n5 = 0;
            } else {
                n5 = this.getContentLocation(n7, bl2, string3);
                n4 = n5 - 1;
                if (n5 >= n2) {
                    n5 = -1;
                }
            }
            if (n5 >= 0 && (n6 = this.getBinaryCount(n5, bl2, byArray, n2)) > 0) {
                if (n6 >= 5) {
                    string4 = this.getBase64EncodedString(n5, byArray, n2);
                    if (string4 != null) {
                        n3 = 1;
                    }
                    encodedLength = string4.length();
                } else {
                    byArray2 = this.getASCIIFYEncodedByteArray(n5, byArray, n2);
                    if (byArray2 != null) {
                        n3 = 2;
                    }
                }
            }
            string = bl2 ? "CLIENT\" " : "SERVER\" ";
            string2 = bl ? "HTTPS" : "HTTP";
            this.writeString("<TRCPacket ticket=\"" + Integer.toString(iTicket) + "\" connectionNumber=\"" + Integer.toString(n) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\" from=\"" + string + " type=\"" + string2 + "\">\r\n");
            if (n7 >= 0) {
                int n8 = n2;
                if (n4 >= 0) {
                    n8 = n2 - (n2 - n4);
                }
                this.writeString("<data length=\"" + Integer.toString(n8) + "\" encoding=\"" + "none\" type=\"HTTPMESSAGE\" " + "><![CDATA[");
                this.flushStreamWriter();
                this.writeBytes(byArray, 0, n8);
                this.flushOutputStream();
                this.writeString(DATA_TAGEND);
            }
            if (n5 >= 0) {
                int n9 = n2 - n5;
                StringBuffer stringBuffer = new StringBuffer("<data length=\"" + Integer.toString(n9) + "\" encoding=\"");
                switch (n3) {
                    case 1: {
                        stringBuffer.append("BASE64\"");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("ASCIIFY\"");
                        break;
                    }
                    default: {
                        stringBuffer.append("NONE\"");
                    }
                }
                if (n3 > 0) {
                    stringBuffer.append(" encodedLength=\"" + Integer.toString(encodedLength) + "\" ");
                }
                stringBuffer.append(" type=\"HTTPCONTENT\" ><![CDATA[");
                String string5 = new String(stringBuffer);
                this.writeString(string5);
                if (n3 != 1) {
                    this.flushStreamWriter();
                    if (n3 == 2) {
                        this.writeBytes(byArray2, 0, encodedLength);
                    } else {
                        this.writeBytes(byArray, n5, n9);
                    }
                    this.flushOutputStream();
                } else {
                    this.writeString(string4);
                }
                this.writeString(DATA_TAGEND);
            }
            this.writeString(PACKET_TAGEND);
            this.flushOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl3;
    }

    public synchronized boolean writeOpenConnectionInfo(boolean bl, int n, String string, int n2, Socket socket, Socket socket2, SSLSocket sSLSocket, SSLSocket sSLSocket2) {
        try {
            long l = TimeStampDispatcher.getTimeStamp();
            iTicket = TicketDispatcher.getTicket();
            this.writeString("<TRCConnection type=\"OPEN\" ticket=\"" + Integer.toString(iTicket) + "\" connectionNumber=\"" + Integer.toString(n) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\">\r\n<servername>\r\n" + string + "</servername>\r\n<port>" + Integer.toString(n2) + "</port>\r\n" + "<clientInetAddress>" + socket.getInetAddress() + "</clientInetAddress>\r\n" + "<clientPort>" + Integer.toString(socket.getPort()) + "</clientPort>\r\n" + "</TRCConnection>\r\n\r\n");
            this.flushOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean writeCloseConnectionInfo(int n) {
        try {
            long l = TimeStampDispatcher.getTimeStamp();
            iTicket = TicketDispatcher.getTicket();
            this.writeString("<TRCConnection type=\"CLOSE\" ticket=\"" + Integer.toString(iTicket) + "\" connectionNumber=\"" + Integer.toString(n) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\"/>\r\n");
            this.flushOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public synchronized boolean writeRecorderStartInfo(int n) {
        try {
            long l = TimeStampDispatcher.getTimeStamp();
            iTicket = TicketDispatcher.getTicket();
            Properties properties = System.getProperties();
            this.writeString(XML_IDENT);
            this.writeString("<TRCRecorderInfo type=\"start\" ticket=\"" + Integer.toString(iTicket) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\">\r\n<recorderport>" + Integer.toString(n) + "</recorderport>\r\n<date>" + this.date.toLocaleString() + "</date>\r\n" + "<recorderversion>1.0</recorderversion>\r\n" + "<javavmversion>" + properties.getProperty("java.vm.version") + "</javavmversion>\r\n" + "<javavmvendor>" + properties.getProperty("java.vm.vendor") + "</javavmvendor>\r\n" + "<javahome>" + properties.getProperty("java.home") + "</javahome>\r\n" + "<osname>" + properties.getProperty("os.name") + "</osname>\r\n" + "<osversion>" + properties.getProperty("os.version") + "</osversion>\r\n");
            this.writeString("</TRCRecorderInfo>\r\n\r\n");
            this.flushOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean writeRecorderStopInfo() {
        try {
            long l = TimeStampDispatcher.getTimeStamp();
            iTicket = TicketDispatcher.getTicket();
            this.writeString("<TRCRecorderInfo type=\"STOP\" ticket=\"" + Integer.toString(iTicket) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\">\r\n");
            this.writeString("</TRCRecorderInfo>\r\n\r\n</TRACE>\r\n");
            this.flushOutputStream();
            bStopRecording = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean writeRecorderMessage(int n, String string) {
        try {
            long l = TimeStampDispatcher.getTimeStamp();
            iTicket = TicketDispatcher.getTicket();
            String string2 = null;
            switch (n) {
                case 2: {
                    string2 = "ERROR";
                    break;
                }
                default: {
                    string2 = "INFORMATION";
                }
            }
            this.writeString("<TRCRecorderInfo type=\"" + string2 + "\" ticket=\"" + Integer.toString(iTicket) + "\" timestamp=\"" + Long.toString(TimeStampDispatcher.getTimeStamp()) + "\">\r\n<message>" + string + "</message>\r\n");
            this.writeString("</TRCRecorderInfo>\r\n\r\n");
            this.flushOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private int getHTTPMessageLocation(boolean bl, String string) {
        int n = -1;
        int n2 = string.indexOf("\r\n");
        if (!bl) {
            n = string.indexOf("HTTP/");
            if (n > 1) {
                n = -1;
            }
        } else {
            n = string.indexOf("HTTP/1.");
        }
        if (n > n2 || string.indexOf("\r\n\r\n") < 0) {
            n = -1;
        }
        return n;
    }

    private int getContentLocation(int n, boolean bl, String string) {
        int n2 = -1;
        n2 = string.indexOf("\r\n\r\n");
        return n2 += 4;
    }

    private int getBinaryCount(int n, boolean bl, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 50 + n;
        if (n4 > n2) {
            n4 = n2;
        }
        int n5 = n;
        while (n5 < n4) {
            if (this.isByteBinary(byArray[n5])) {
                ++n3;
            }
            if (n3 > 4) break;
            ++n5;
        }
        if (n3 == 0 && n4 < n2) {
            n5 = n4;
            while (n5 < n2) {
                if (this.isByteBinary(byArray[n5])) {
                    ++n3;
                    break;
                }
                ++n5;
            }
        }
        return n3;
    }

    private String getBase64EncodedString(int n, byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            if (stringBuffer.length() == 76) {
                stringBuffer.append("\n\r");
            }
            stringBuffer.append(mappings.charAt((byArray[n3] & 0xFC) >> 2));
            int n4 = (byArray[n3] & 3) << 4;
            if (n3 + 1 >= byArray.length) {
                stringBuffer.append(mappings.charAt(n4));
                stringBuffer.append(filler);
                stringBuffer.append(filler);
                return stringBuffer.toString();
            }
            stringBuffer.append(mappings.charAt(n4 |= (byArray[n3 + 1] & 0xF0) >> 4));
            int n5 = (byArray[n3 + 1] & 0xF) << 2;
            if (n3 + 2 >= byArray.length) {
                stringBuffer.append(mappings.charAt(n5));
                stringBuffer.append(filler);
                return stringBuffer.toString();
            }
            stringBuffer.append(mappings.charAt(n5 |= (byArray[n3 + 2] & 0xC0) >> 6));
            stringBuffer.append(mappings.charAt(byArray[n3 + 2] & 0x3F));
            n3 += 3;
        }
        return stringBuffer.toString();
    }

    private byte[] getASCIIFYEncodedByteArray(int n, byte[] byArray, int n2) {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        int n4 = n2 - n;
        byte[] byArray3 = new byte[n4 * 2 + 2];
        byte[] byArray4 = new byte[n4];
        try {
            int n5 = n;
            while (n5 < n2) {
                int n6;
                int n7 = byArray[n5];
                bl2 = this.isByteBinary((byte)n7);
                if (bl && !bl2 && n5 + 1 < n4) {
                    bl2 = this.isByteBinary(byArray[n5 + 1]);
                }
                if (bl2) {
                    if (!bl) {
                        byArray3[n3] = 96;
                        ++n3;
                    }
                    if ((n6 = n7) < 0) {
                        n6 += 256;
                    }
                    if ((n6 >>= 4) < 0 || n6 > 15) {
                        n6 = 0;
                    }
                    byArray3[n3] = byArray2[n6];
                    ++n3;
                    n6 = n7 & 0xF;
                    if (n6 < 0 || n6 > 15) {
                        n6 = 0;
                    }
                    byArray3[n3] = byArray2[n6];
                    ++n3;
                    bl = true;
                } else {
                    if (bl) {
                        byArray3[n3] = 96;
                        ++n3;
                        bl = false;
                    }
                    byArray3[n3] = byArray[n5];
                    ++n3;
                }
                if (byArray3[n3 - 1] < 0) {
                    n6 = 0;
                }
                ++n5;
            }
            if (bl) {
                byArray3[n3] = 96;
                ++n3;
            }
            encodedLength = n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private boolean isByteBinary(byte by) {
        boolean bl = false;
        if (by == 93) {
            bl = true;
        } else if ((by < 32 || by > 126 || by == 96) && by != 13 && by != 10 && by != 9 && by != 96 && by != 93) {
            bl = true;
        }
        return bl;
    }

    protected void flushOutputStream() throws IOException {
    }

    private void flushStreamWriter() throws IOException {
    }

    protected void writeString(String string) throws IOException {
        if (this.agent != null && !bStopRecording) {
            this.agent.sendByteDataToDataProcessor(string.getBytes(), 0, string.getBytes().length);
        }
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.agent != null && !bStopRecording) {
            this.agent.sendByteDataToDataProcessor(byArray, n, n2);
        }
    }

    public RecorderAgent getAgentController() {
        return this.agent;
    }
}

