/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.config.generator.Agent;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfiguration;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfigurationFactory;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.Deny;
import org.eclipse.hyades.internal.config.generator.FileError;
import org.eclipse.hyades.internal.config.generator.Hosts;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.Parameter;
import org.eclipse.hyades.internal.config.generator.Service;
import org.eclipse.hyades.internal.config.generator.Variable;

public class SetConfigCommon {
    protected static String _packageName = "org.eclipse.hyades.internal.config.generator";
    protected static String _RACDTDPath = "../dtd/serviceconfig.dtd";
    protected static String _JAVAHomeVar = "JAVA_PATH";
    protected static String _RACHomeVar = "RASERVER_HOME";
    protected static String _RACConfigVer = "5.0.0";
    protected static String _RACPort = "10002";
    protected static String _RACSecPort = "10003";
    protected static String _RACLogLevel = "WARNING";
    protected static String _RACLogDetail = "LOW";
    protected String libPath = null;
    protected String dllPath = null;
    protected String _encoding = "";
    protected String _encodingTag = "";
    protected String pgmExt = "";
    protected String dcSize = "30000K";
    protected String _platform = null;
    protected char ps;
    protected char cs;
    protected static AgentControllerConfiguration iAgentControllerConfiguration;
    protected static AgentControllerConfigurationFactory iAgentControllerConfigurationFactory;
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SetConfigCommon(String string) {
        if (string == null) {
            string = this.getPlatformName();
        }
        this.setPlatform(string);
    }

    public SetConfigCommon() {
        this.setPlatform(this.getPlatformName());
    }

    public String getStartSh() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._platform.startsWith("Windows")) {
            return null;
        }
        this.addShellSection(stringBuffer);
        this.addEnvSection(stringBuffer);
        this.addStartSection(stringBuffer);
        this.addCheckSection(stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public boolean loadExistingConfiguration(String string) throws FileError {
        if (SetConfigCommon.fileExists(string)) {
            if (!this.loadExistingInstance(string)) {
                return false;
            }
            this.fixEntityRefenences();
            return true;
        }
        return false;
    }

    public boolean loadExistingInstance(String string) throws FileError {
        iAgentControllerConfigurationFactory = new AgentControllerConfigurationFactory();
        iAgentControllerConfigurationFactory.setPackageName(_packageName);
        iAgentControllerConfigurationFactory.setDTDFileName(_RACDTDPath);
        iAgentControllerConfigurationFactory.setEncoding(this._encoding);
        iAgentControllerConfigurationFactory.setEncodingTag(this._encodingTag);
        try {
            iAgentControllerConfiguration = iAgentControllerConfigurationFactory.loadDocument(string);
        }
        catch (Exception exception) {
            throw new FileError(string, exception);
        }
        return iAgentControllerConfiguration != null;
    }

    public void createEmptyNewInstance() {
        iAgentControllerConfigurationFactory = new AgentControllerConfigurationFactory();
        iAgentControllerConfigurationFactory.setPackageName(_packageName);
        iAgentControllerConfigurationFactory.setDTDFileName(_RACDTDPath);
        iAgentControllerConfigurationFactory.setEncoding(this._encoding);
        iAgentControllerConfigurationFactory.setEncodingTag(this._encodingTag);
        iAgentControllerConfiguration = iAgentControllerConfigurationFactory.createRoot("AgentControllerConfiguration");
        this.createEmptyAgentControllerConfiguration();
    }

    public boolean createDefaultConfiguration() {
        return this.createDefaultNewInstance();
    }

    public boolean createDefaultNewInstance() {
        iAgentControllerConfigurationFactory = new AgentControllerConfigurationFactory();
        iAgentControllerConfigurationFactory.setPackageName(_packageName);
        iAgentControllerConfigurationFactory.setDTDFileName(_RACDTDPath);
        iAgentControllerConfigurationFactory.setEncoding(this._encoding);
        iAgentControllerConfigurationFactory.setEncodingTag(this._encodingTag);
        iAgentControllerConfiguration = iAgentControllerConfigurationFactory.createRoot("AgentControllerConfiguration");
        if (iAgentControllerConfiguration == null) {
            return false;
        }
        if (this.getPlatformName().startsWith("OS/400")) {
            this.createDefaultAgentControllerConfigurationForOS400();
        } else {
            this.createDefaultAgentControllerConfiguration();
        }
        return true;
    }

    public void saveInstance(String string) throws Exception {
        iAgentControllerConfigurationFactory.save(string);
    }

    public Agent createAgent() {
        Agent agent = iAgentControllerConfigurationFactory.createAgent("Agent");
        return agent;
    }

    public Agent createAgent(String string, String string2, String string3, String string4, String string5, String string6) {
        Agent agent = iAgentControllerConfigurationFactory.createAgent("Agent");
        agent.setConfiguration(string);
        agent.setName(string2);
        agent.setType(string3);
        agent.setDataChannelSize(string5);
        agent.setLogFile(string6);
        agent.setClient(string4);
        return agent;
    }

    public Agent createAgent(String string, String string2, String string3, String string4) {
        Agent agent = iAgentControllerConfigurationFactory.createAgent("Agent");
        agent.setConfiguration(string);
        agent.setName(string2);
        agent.setType(string3);
        agent.setDataChannelSize(string4);
        return agent;
    }

    public Agent createAgent(String string, String string2, String string3) {
        Agent agent = iAgentControllerConfigurationFactory.createAgent("Agent");
        agent.setConfiguration(string);
        agent.setName(string2);
        agent.setType(string3);
        return agent;
    }

    public void createDefaultAgentControllerConfiguration() {
        iAgentControllerConfiguration.setAgentControllerEnvironment(this.createAgentControllerEnvironment("default"));
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
        int n = 0;
        agentControllerEnvironment.setVariable(n++, this.createVariable(_JAVAHomeVar, "%JAVA_PATH%", "replace"));
        agentControllerEnvironment.setVariable(n++, this.createVariable(_RACHomeVar, "%RASERVER_HOME%", "replace"));
        agentControllerEnvironment.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hcframe.jar", "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "prepend"));
        int n2 = 0;
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "java.exe", "%JAVA_PATH%" + this.ps + "java" + this.pgmExt, "%JAVA_PATH%"));
        Application application = iAgentControllerConfiguration.getApplication(n2 - 1);
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "append"));
        application.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "RemoteLogParserLoader", "%JAVA_PATH%" + this.ps + "java" + this.pgmExt, "%RASERVER_HOME%" + this.ps + "config"));
        application = iAgentControllerConfiguration.getApplication(n2 - 1);
        application.setParameter(0, this.createParameter("org.eclipse.hyades.logging.parsers.RemoteLogParserLoader", "prepend"));
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "commons-logging.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlcommons.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlcore.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlevents.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hparse.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hglaconfig.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hgla.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "jakarta-oro.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xercesImpl.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xmlParserAPIs.jar", "prepend"));
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "HyadesTestingSession", "%JAVA_PATH%" + this.ps + "java" + this.pgmExt, "%JAVA_PATH%"));
        application = iAgentControllerConfiguration.getApplication(n2 - 1);
        application.setParameter(0, this.createParameter("&quot;-Dhyades.test.JVM=%JAVA_PATH%" + this.ps + "java" + this.pgmExt + "&quot;", "prepend"));
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "common.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "java.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "http.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "junit.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xerces.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xercesImpl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "manual.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexrecr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "http.hexrecr.jar", "append"));
        application.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "PerfmonAgent", "%RASERVER_HOME%" + this.ps + "bin" + this.ps + "PerfmonAgent" + this.pgmExt, "%RASERVER_HOME%"));
        application = iAgentControllerConfiguration.getApplication(n2 - 1);
        n = 0;
        application.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        iAgentControllerConfiguration.setHosts(++n2, this.createHosts("default"));
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        hosts.setAllow(0, this.createAllow("LOCAL"));
        iAgentControllerConfiguration.setAgent(++n2, this.createAgent("default", "Java Profiling Agent", "Profiler", "30000K"));
        iAgentControllerConfiguration.setActiveConfiguration("default");
        iAgentControllerConfiguration.setVersion(_RACConfigVer);
        iAgentControllerConfiguration.setPort(_RACPort);
        iAgentControllerConfiguration.setSecurePort(_RACSecPort);
        iAgentControllerConfiguration.setLoggingLevel(_RACLogLevel);
        iAgentControllerConfiguration.setLoggingDetail(_RACLogDetail);
    }

    public void createDefaultAgentControllerConfigurationForOS400() {
        iAgentControllerConfiguration.setAgentControllerEnvironment(this.createAgentControllerEnvironment("default"));
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
        int n = 0;
        agentControllerEnvironment.setVariable(n++, this.createVariable(_JAVAHomeVar, "/QSYS.LIB/Q5BVAJVM.PGM", "replace"));
        agentControllerEnvironment.setVariable(n++, this.createVariable(_RACHomeVar, "/opt/IBMRAC", "replace"));
        agentControllerEnvironment.setVariable(n++, this.createVariable(this.getLibPath(), "/QSYS.LIB/IBMRAC.LIB", "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hcframe.jar", "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "prepend"));
        agentControllerEnvironment.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "prepend"));
        int n2 = 0;
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "java.exe", "%JAVA_PATH%", "/"));
        Application application = iAgentControllerConfiguration.getApplication(n2 - 1);
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "append"));
        application.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "RemoteLogParserLoader", "%JAVA_PATH%", "%RASERVER_HOME%" + this.ps + "config"));
        application = iAgentControllerConfiguration.getApplication(n2 - 1);
        application.setParameter(0, this.createParameter("org.eclipse.hyades.logging.parsers.RemoteLogParserLoader", "prepend"));
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "commons-logging.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlcommons.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlcore.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hlevents.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hparse.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hglaconfig.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hgla.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "jakarta-oro.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xercesImpl.jar", "prepend"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xmlParserAPIs.jar", "prepend"));
        iAgentControllerConfiguration.setApplication(++n2, this.createApplication("default", "HyadesTestingSession", "%JAVA_PATH%", "/"));
        application = iAgentControllerConfiguration.getApplication(n2 - 1);
        application.setParameter(0, this.createParameter("&quot;-Dhyades.test.JVM=%JAVA_PATH%&quot;", "prepend"));
        n = 0;
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexcore.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "common.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "java.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "http.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "junit.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xerces.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "xercesImpl.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "manual.runner.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "hexrecr.jar", "append"));
        application.setVariable(n++, this.createVariable("CLASSPATH", "%RASERVER_HOME%" + this.ps + "lib" + this.ps + "http.hexrecr.jar", "append"));
        application.setVariable(n++, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.getDllPath(), "prepend"));
        iAgentControllerConfiguration.setHosts(++n2, this.createHosts("default"));
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        hosts.setAllow(0, this.createAllow("LOCAL"));
        iAgentControllerConfiguration.setAgent(++n2, this.createAgent("default", "Java Profiling Agent", "Profiler", "8M"));
        iAgentControllerConfiguration.setActiveConfiguration("default");
        iAgentControllerConfiguration.setVersion(_RACConfigVer);
        iAgentControllerConfiguration.setPort(_RACPort);
        iAgentControllerConfiguration.setSecurePort(_RACSecPort);
        iAgentControllerConfiguration.setLoggingLevel(_RACLogLevel);
        iAgentControllerConfiguration.setLoggingDetail(_RACLogDetail);
    }

    public void createEmptyAgentControllerConfiguration() {
        iAgentControllerConfiguration.setAgentControllerEnvironment(this.createAgentControllerEnvironment("default"));
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
        agentControllerEnvironment.setVariable(0, this.createVariable(_JAVAHomeVar, "%JAVA_PATH%", "replace"));
        agentControllerEnvironment.setVariable(1, this.createVariable(_RACHomeVar, "%RASERVER_HOME%", "replace"));
        agentControllerEnvironment.setVariable(2, this.createVariable(this.getLibPath(), "%RASERVER_HOME%" + this.ps + this.dllPath, "prepend"));
        iAgentControllerConfiguration.setActiveConfiguration("default");
        iAgentControllerConfiguration.setVersion(_RACConfigVer);
        iAgentControllerConfiguration.setPort(_RACPort);
        iAgentControllerConfiguration.setSecurePort(_RACSecPort);
        iAgentControllerConfiguration.setLoggingLevel(_RACLogLevel);
        iAgentControllerConfiguration.setLoggingDetail(_RACLogDetail);
    }

    public AgentControllerEnvironment createAgentControllerEnvironment(String string) {
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfigurationFactory.createAgentControllerEnvironment("AgentControllerEnvironment");
        agentControllerEnvironment.setConfiguration(string);
        return agentControllerEnvironment;
    }

    public Allow createAllow(String string) {
        Allow allow = iAgentControllerConfigurationFactory.createAllow("Allow");
        allow.setHost(string);
        return allow;
    }

    public Allow createAllow(String string, String string2) {
        Allow allow = iAgentControllerConfigurationFactory.createAllow("Allow");
        allow.setNet(string);
        if (string2 != null && !string2.equals("")) {
            allow.setMask(string2);
        }
        return allow;
    }

    public Application createApplication(String string, String string2, String string3, String string4) {
        Application application = iAgentControllerConfigurationFactory.createApplication("Application");
        application.setConfiguration(string);
        application.setExecutable(string2);
        application.setPath(string3);
        application.setLocation(string4);
        return application;
    }

    public Deny createDeny(String string) {
        Deny deny = iAgentControllerConfigurationFactory.createDeny("Deny");
        deny.setHost(string);
        return deny;
    }

    public Deny createDeny(String string, String string2) {
        Deny deny = iAgentControllerConfigurationFactory.createDeny("Deny");
        deny.setNet(string);
        if (string2 != null && !string2.equals("")) {
            deny.setMask(string2);
        }
        return deny;
    }

    public Hosts createHosts(String string) {
        Hosts hosts = iAgentControllerConfigurationFactory.createHosts("Hosts");
        hosts.setConfiguration(string);
        return hosts;
    }

    public void createNewInstance(String string) throws Exception {
        iAgentControllerConfigurationFactory = new AgentControllerConfigurationFactory();
        iAgentControllerConfigurationFactory.setPackageName(_packageName);
        iAgentControllerConfigurationFactory.setDTDFileName(_RACDTDPath);
        iAgentControllerConfigurationFactory.setEncoding("UTF8");
        iAgentControllerConfigurationFactory.setEncodingTag("UTF-8");
        iAgentControllerConfiguration = iAgentControllerConfigurationFactory.createRoot("AgentControllerConfiguration");
        this.createDefaultAgentControllerConfiguration();
        iAgentControllerConfigurationFactory.save(string);
    }

    public Option createOption(String string, String string2, String string3) {
        Option option = iAgentControllerConfigurationFactory.createOption("Option");
        option.setType(string);
        option.setName(string2);
        option.setValue(string3);
        return option;
    }

    public Parameter createParameter(String string, String string2) {
        Parameter parameter = iAgentControllerConfigurationFactory.createParameter("Parameter");
        parameter.setValue(string);
        parameter.setPosition(string2);
        return parameter;
    }

    public Service createService(String string, String string2, String string3) {
        Service service = iAgentControllerConfigurationFactory.createService("Service");
        service.setConfiguration(string);
        service.setName(string2);
        service.setPath(string3);
        return service;
    }

    public Variable createVariable(String string, String string2, String string3) {
        Variable variable = iAgentControllerConfigurationFactory.createVariable("Variable");
        variable.setName(string);
        variable.setValue(string2);
        variable.setPosition(string3);
        return variable;
    }

    public void addShellSection(StringBuffer stringBuffer) {
        if (this._platform.equals("z/OS") || this._platform.equals("OS/390")) {
            stringBuffer.append("#!/bin/ksh\n");
        } else {
            stringBuffer.append("#!/bin/sh\n");
        }
        stringBuffer.append("# Platform = ");
        stringBuffer.append(this._platform);
        stringBuffer.append("\n");
    }

    public void addEnvSection(StringBuffer stringBuffer) {
        if (this._platform.equals("z/OS") || this._platform.equals("OS/390")) {
            stringBuffer.append("export RASERVER_HOME=");
            stringBuffer.append(this.getRACHome());
            stringBuffer.append("\n");
            stringBuffer.append("export PATH=$RASERVER_HOME/bin:$PATH\n");
            stringBuffer.append("export LIBPATH=$RASERVER_HOME/lib:");
            stringBuffer.append(this.findClassicLib(this.getJAVAHome()) + "/classic:");
            stringBuffer.append(this.findClassicLib(this.getJAVAHome()) + ":");
            stringBuffer.append("$LIBPATH\n");
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("RASERVER_HOME=");
            stringBuffer.append(this.getRACHome());
            stringBuffer.append("\n");
            stringBuffer.append("PATH=$RASERVER_HOME/bin:$PATH\n");
            stringBuffer.append(this.libPath);
            stringBuffer.append("=$RASERVER_HOME/");
            stringBuffer.append(this.dllPath + ":");
            stringBuffer.append(this.findClassicLib(this.getJAVAHome()));
            if (this._platform.equals("HP-UX")) {
                stringBuffer.append("/../lib/PA_RISC/classic:");
                stringBuffer.append(this.findClassicLib(this.getJAVAHome()) + "/../lib/PA_RISC:");
            } else if (this._platform.equals("SunOS")) {
                stringBuffer.append("/../lib/sparc/server:");
                stringBuffer.append(this.findClassicLib(this.getJAVAHome()) + "/../lib/sparc:");
            } else {
                stringBuffer.append("/classic:");
                stringBuffer.append(this.findClassicLib(this.getJAVAHome()) + ":");
            }
            stringBuffer.append("$");
            stringBuffer.append(this.libPath);
            stringBuffer.append("\n");
            stringBuffer.append("export RASERVER_HOME\n");
            stringBuffer.append("export PATH\n");
            stringBuffer.append("export ");
            stringBuffer.append(this.libPath);
            stringBuffer.append("\n");
        }
    }

    public void addStartSection(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        if (this._platform.equals("z/OS") || this._platform.equals("OS/390")) {
            stringBuffer.append("ps -e -opid,comm | grep \"RAServer\" | wc -l | awk '{\n");
        } else if (this._platform.equals("SunOS")) {
            stringBuffer.append("ps -ae | grep \"RAServer\" | wc -l | nawk '{\n");
        } else {
            stringBuffer.append("ps -ae | grep \"RAServer\" | wc -l | awk '{\n");
        }
        stringBuffer.append("\tif( $1!=\"0\" ) {\n");
        stringBuffer.append("\t\tprint \"RAServer is already running\"\n");
        stringBuffer.append("\t}\n");
        stringBuffer.append("\telse {\n");
        stringBuffer.append("\t\tsystem(\"RAServer\")\n");
        stringBuffer.append("\t}\n");
        stringBuffer.append("}'\n");
    }

    public void addCheckSection(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("sleep 2\n");
        stringBuffer.append("\n");
        if (this._platform.equals("z/OS") || this._platform.equals("OS/390")) {
            stringBuffer.append("ps -e -opid,comm | grep \"RAServer\" | wc -l | awk '{\n");
        } else if (this._platform.equals("SunOS")) {
            stringBuffer.append("ps -ae | grep \"RAServer\" | wc -l | nawk '{\n");
        } else {
            stringBuffer.append("ps -ae | grep \"RAServer\" | wc -l | awk '{\n");
        }
        stringBuffer.append("\tif( $1!=\"0\" ) {\n");
        stringBuffer.append("\t\tprint \"RAServer started successfully\"\n");
        stringBuffer.append("\t}\n");
        stringBuffer.append("\telse {\n");
        stringBuffer.append("\t\tprint \"RAServer failed to start\"\n");
        stringBuffer.append("\t}\n");
        stringBuffer.append("}'\n");
    }

    public String getAllowHosts() {
        if (iAgentControllerConfiguration.getHostsCount() == 0) {
            return null;
        }
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        if (hosts.getAllowCount() == 0) {
            return null;
        }
        Allow allow = hosts.getAllow(0);
        String string = allow.getHost();
        int n = 1;
        while (n < hosts.getAllowCount()) {
            allow = hosts.getAllow(n);
            string = string + "," + allow.getHost();
            ++n;
        }
        return string;
    }

    public void removeAllowHosts() {
        if (iAgentControllerConfiguration.getHostsCount() == 0) {
            return;
        }
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        if (hosts.getAllowCount() == 0) {
            return;
        }
        int n = hosts.getAllowCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            hosts.removeAllow(n2);
            --n2;
        }
    }

    public void addAllowHost(String string) {
        if (iAgentControllerConfiguration.getHostsCount() == 0) {
            iAgentControllerConfiguration.setHosts(0, this.createHosts("default"));
        }
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        int n = 0;
        while (n < hosts.getAllowCount()) {
            Allow allow = hosts.getAllow(n);
            if (allow.getHost().equals(string)) {
                return;
            }
            ++n;
        }
        hosts.setAllow(hosts.getAllowCount(), this.createAllow(string));
    }

    public void addAllowHostList(String string) {
        if (iAgentControllerConfiguration.getHostsCount() == 0) {
            iAgentControllerConfiguration.setHosts(0, this.createHosts("default"));
        }
        Hosts hosts = iAgentControllerConfiguration.getHosts(0);
        String string2 = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            boolean bl = false;
            int n = 0;
            while (n < hosts.getAllowCount()) {
                Allow allow = hosts.getAllow(n);
                if (allow.getHost().equals(string3)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            hosts.setAllow(hosts.getAllowCount(), this.createAllow(string3));
        }
    }

    public static String removeSlashes(String string) {
        String string2 = string.trim();
        if (string2.endsWith("\\") || string2.endsWith("/")) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public String getDllPath() {
        return this.dllPath;
    }

    public void setPlatformSpecificParameters() {
        String string = this.getPlatformName();
        if (string.equals("AIX")) {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("LIBPATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else if (string.equals("HP-UX")) {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("SHLIB_PATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else if (string.equals("Linux")) {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("LD_LIBRARY_PATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else if (string.equals("SunOS")) {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("LD_LIBRARY_PATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else if (string.startsWith("Windows")) {
            this._encoding = new String("UTF8");
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("PATH");
            this.dllPath = new String("bin");
            this.pgmExt = new String(".exe");
            this.dcSize = new String("64M");
            this.ps = (char)92;
            this.cs = (char)59;
        } else if (string.equals("z/OS") || string.equals("OS/390")) {
            this._encoding = new String("IBM-1047");
            this._encodingTag = new String("IBM-1047");
            this.libPath = new String("LIBPATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else if (string.equals("OS/400")) {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("LIBPATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        } else {
            this._encoding = "UTF8";
            this._encodingTag = new String("UTF-8");
            this.libPath = new String("LIBPATH");
            this.dllPath = new String("lib");
            this.pgmExt = "";
            this.ps = (char)47;
            this.cs = (char)58;
        }
    }

    public String getLocation(String string) {
        if (string.charAt(0) == '%') {
            return string;
        }
        if (this._platform.startsWith("Windows")) {
            return string.substring(0, string.indexOf(92, 1) + 1);
        }
        return string.substring(0, string.indexOf(47, 1));
    }

    public void setPlatform(String string) {
        if (string != null && !string.equals("")) {
            this._platform = string;
            this.setPlatformSpecificParameters();
        }
    }

    public String getPlatformName() {
        if (this._platform == null) {
            return System.getProperty("os.name", "Windows");
        }
        return this._platform;
    }

    public void writeConfigFile(String string) throws FileError {
        try {
            this.saveInstance(string);
        }
        catch (Exception exception) {
            throw new FileError(string, exception);
        }
    }

    public void writeToFile(String string, String string2) throws FileError {
        if (string2 == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new FileError(string, exception);
        }
    }

    public String findClassicLib(String string) {
        if (this.getPlatformName() == null) {
            this.setPlatform(System.getProperty("os.name", "null"));
        }
        if (this.getPlatformName().startsWith("Windows")) {
            if (this.fileExists(string + "\\classic", "jvm.dll")) {
                return string;
            }
            if (this.fileExists(string + "\\..\\jre\\bin\\classic", "jvm.dll")) {
                return new String(string + "\\..\\jre\\bin");
            }
        } else if (this.getPlatformName().equals("AIX")) {
            if (this.fileExists(string + "/classic", "libjvm.a")) {
                return string;
            }
            if (this.fileExists(string + "/../jre/bin/classic", "libjvm.a")) {
                return new String(string + "/../jre/bin");
            }
        } else if (this.getPlatformName().equals("HP-UX")) {
            if (this.fileExists(string + "/../lib/PA_RISC/classic", "libjvm.sl")) {
                return string;
            }
            if (this.fileExists(string + "/../jre/lib/PA_RISC/classic", "libjvm.sl")) {
                return new String(string + "/../jre/bin");
            }
        } else if (this.getPlatformName().equals("SunOS")) {
            if (this.fileExists(string + "/../lib/sparc/server", "libjvm.so")) {
                return string;
            }
            if (this.fileExists(string + "/../jre/lib/sparc/server", "libjvm.so")) {
                return new String(string + "/../jre/bin");
            }
        } else {
            if (this.fileExists(string + "/classic", "libjvm.so")) {
                return string;
            }
            if (this.fileExists(string + "/../jre/bin/classic", "libjvm.so")) {
                return new String(string + "/../jre/bin");
            }
        }
        return string;
    }

    public boolean fileExists(String string, String string2) {
        File file = new File(string, string2);
        return file.exists();
    }

    public String getJAVAHome() {
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
        int n = 0;
        while (n < agentControllerEnvironment.getVariableCount()) {
            Variable variable = agentControllerEnvironment.getVariable(n);
            String string = variable.getName();
            if (string.equals(_JAVAHomeVar)) {
                return variable.getValue();
            }
            ++n;
        }
        return null;
    }

    public void setJAVAHome(String string) {
        if (string != null && !string.equals("")) {
            String string2 = SetConfigCommon.removeSlashes(string);
            iAgentControllerConfiguration.setJvm(this.findClassicLib(string));
            AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
            if (agentControllerEnvironment == null) {
                iAgentControllerConfiguration.setAgentControllerEnvironment(this.createAgentControllerEnvironment("default"));
                agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
            }
            int n = 0;
            while (n < agentControllerEnvironment.getVariableCount()) {
                Variable variable = agentControllerEnvironment.getVariable(n);
                String string3 = variable.getName();
                if (string3.equals(_JAVAHomeVar)) {
                    variable.setValue(string2);
                    return;
                }
                ++n;
            }
            agentControllerEnvironment.setVariable(agentControllerEnvironment.getVariableCount(), this.createVariable(_JAVAHomeVar, string2, "replace"));
        }
    }

    public String getRACHome() {
        AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
        int n = 0;
        while (n < agentControllerEnvironment.getVariableCount()) {
            Variable variable = agentControllerEnvironment.getVariable(n);
            String string = variable.getName();
            if (string.equals(_RACHomeVar)) {
                return variable.getValue();
            }
            ++n;
        }
        return null;
    }

    public void setRACHome(String string) {
        if (string != null && !string.equals("")) {
            String string2 = SetConfigCommon.removeSlashes(string);
            AgentControllerEnvironment agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
            if (agentControllerEnvironment == null) {
                iAgentControllerConfiguration.setAgentControllerEnvironment(this.createAgentControllerEnvironment("default"));
                agentControllerEnvironment = iAgentControllerConfiguration.getAgentControllerEnvironment();
            }
            int n = 0;
            while (n < agentControllerEnvironment.getVariableCount()) {
                Variable variable = agentControllerEnvironment.getVariable(n);
                String string3 = variable.getName();
                if (string3.equals(_RACHomeVar)) {
                    variable.setValue(string2);
                    return;
                }
                ++n;
            }
            agentControllerEnvironment.setVariable(agentControllerEnvironment.getVariableCount(), this.createVariable(_RACHomeVar, string2, "replace"));
        }
    }

    public char getPs() {
        return this.ps;
    }

    private void fixEntityRefenences() {
        int n = iAgentControllerConfiguration.getApplicationCount();
        int n2 = 0;
        while (n2 < n) {
            Application application = iAgentControllerConfiguration.getApplication(n2);
            int n3 = application.getParameterCount();
            int n4 = 0;
            while (n4 < n3) {
                Parameter parameter = application.getParameter(n4);
                parameter.setValue(this.removeQuotes(parameter.getValue()));
                ++n4;
            }
            ++n2;
        }
    }

    private String removeQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("&quot;");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

