/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class SecureConnectionImpl
extends ConnectionImpl {
    private boolean handshakeSuccess;

    public void connect(Node node, int n) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = n;
        int n2 = 0;
        InetAddress[] inetAddressArray = node.getAllInetAddresses();
        int n3 = 0;
        String[] stringArray = node.getSecurityParameters().getEnabledProtocols();
        if (stringArray == null) {
            stringArray = new String[]{"SSL"};
        }
        do {
            try {
                SSLContext sSLContext = SSLContext.getInstance(stringArray[n3]);
                sSLContext.init(node.getSecurityParameters().getKeystoreManager().getKeyManagers(), node.getSecurityParameters().getKeystoreManager().getTrustManagers(), null);
                if (sSLContext == null) {
                    Security.addProvider(node.getSecurityParameters().getSecurityProvider());
                    this._socket = SSLSocketFactory.getDefault().createSocket(inetAddressArray[n2], n);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                            System.out.println("handshake complete");
                        }
                    });
                    ((SSLSocket)this._socket).startHandshake();
                } else {
                    this._socket = sSLContext.getSocketFactory().createSocket(inetAddressArray[n2], n);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        }
                    });
                }
                String[] stringArray2 = node.getSecurityParameters().getEnabledCipherSuites();
                if (stringArray2 != null) {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(node.getSecurityParameters().getEnabledCipherSuites());
                } else {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(((SSLSocket)this._socket).getSupportedCipherSuites());
                }
                ((SSLSocket)this._socket).setUseClientMode(true);
                SSLSession sSLSession = ((SSLSocket)this._socket).getSession();
                if (sSLSession == null) {
                    throw new UntrustedAgentControllerException();
                }
                if (sSLSession.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
                    throw new UntrustedAgentControllerException();
                }
                break;
            }
            catch (ConnectException connectException) {
                if (++n2 == inetAddressArray.length) {
                    throw connectException;
                }
                n3 = 0;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (++n3 != stringArray.length) continue;
                throw new ConnectException("Could not get an SSLContext. All protocol specifications were tried");
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
        } while (n2 < inetAddressArray.length);
        this._node = node;
        this.init();
    }
}

