/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class BaseString {
    private static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String NUMERIC = "0123456789";

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Object[]) {
            return BaseString.arrayToString((Object[])object);
        }
        if (object instanceof List) {
            return BaseString.arrayToString(((List)object).toArray());
        }
        if (object instanceof Collection) {
            return BaseString.arrayToString(((Collection)object).toArray());
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static String arrayToString(Object[] objectArray) {
        return BaseString.arrayToString(objectArray, " ");
    }

    public static String arrayToString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        string = BaseString.toString(string);
        String string2 = "";
        int n = objectArray.length;
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(string).append(objectArray[n2].toString());
                ++n2;
            }
            string2 = stringBuffer.toString().substring(string.length());
        }
        return string2;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static byte[] encode(String string, String string2) {
        if (string2 != null) {
            if (string == null) {
                return string2.getBytes();
            }
            try {
                return string2.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] tokenizer(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        do {
            if ((n = string.indexOf(string2)) < 0) continue;
            if (n > 0) {
                vector.add(string.substring(0, n));
            }
            string = string.substring(n += string2.length());
            if (!bl) continue;
            vector.add(string2);
        } while (n >= 0);
        if (string.length() > 0) {
            vector.add(string);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static int occurrenceOf(String string, char c) {
        int n = 0;
        if (string.length() > 0) {
            int n2 = 0;
            while (n2 < string.length()) {
                if (c == string.charAt(n2)) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        if (string2.length() == 0) {
            return string;
        }
        if (string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String toProperCase(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = BaseString.tokenizer(string, " ", true);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n].substring(0, 1).toUpperCase());
            if (stringArray[n].length() > 1) {
                stringBuffer.append(stringArray[n].substring(1));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isAlphanumeric(String string) {
        return BaseString.lastIndexOfAnyBut(string, ALPHANUMERIC) == -1;
    }

    public static int lastIndexOfAnyBut(String string, String string2) {
        int n = -1;
        int n2 = string.length();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (string2.indexOf(string.charAt(n3)) == -1) {
                n = n3;
                break;
            }
            --n3;
        }
        return n;
    }

    public static boolean isDigits(String string) {
        return BaseString.lastIndexOfAnyBut(string, NUMERIC) == -1;
    }
}

