/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekServerSocket;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;

public class SSLProxyRecorder
extends RecorderAgent {
    static int iProxyRecorderPort = 0;
    static Proxy proxy = null;
    static final String ErrorStartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_ERROR_STARTING");
    static final String StartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_STARTING_SSLPROXYRECORDER");
    static final String ListeningToPort = HttpRecResourceBundle.getInstance().getString("RECORDER_LISTENING_TO_PORT");
    static PacketWriter packetWriter = null;
    private String configuration;

    public static void main(String[] stringArray) {
        new SSLProxyRecorder().run();
    }

    public Thread run() {
        try {
            this.sendDebugMessageToDataProcessor(StartingRecorder);
            proxy = new Proxy(this);
            proxy.start();
            this.sendDebugMessageToDataProcessor(ListeningToPort + iProxyRecorderPort);
        }
        catch (Exception exception) {
            this.controller.reportException(ErrorStartingRecorder + exception.getMessage(), (Throwable)exception);
            System.err.println(exception);
            System.exit(1);
        }
        this.setIsReady(true);
        return proxy;
    }

    public boolean init(String string) {
        this.configuration = string;
        int n = string.indexOf("port,");
        if (n >= 0) {
            int n2 = n + 5;
            int n3 = string.indexOf(";", n2);
            iProxyRecorderPort = n3 >= 0 ? Integer.parseInt(string.substring(n2, n3)) : Integer.parseInt(string.substring(n2));
        }
        return true;
    }

    public boolean handleCommand(int n, String string) {
        switch (n) {
            case 1: {
                if (packetWriter != null) {
                    packetWriter.writeRecorderStopInfo();
                }
                return true;
            }
        }
        return false;
    }

    public static class Proxy
    extends Thread {
        String host;
        RecorderAgent agent = null;

        public Proxy(RecorderAgent recorderAgent) {
            this.agent = recorderAgent;
            packetWriter = new PacketWriter(recorderAgent);
            packetWriter.writeRecorderStartInfo(iProxyRecorderPort);
        }

        public void run() {
            PeekServerSocket peekServerSocket = null;
            try {
                peekServerSocket = new PeekServerSocket(iProxyRecorderPort);
                peekServerSocket.setSoTimeout(600000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (true) {
                try {
                    while (true) {
                        PeekSocket peekSocket = peekServerSocket.acceptPeekSocket();
                        ClientSideReader clientSideReader = new ClientSideReader(peekSocket, packetWriter);
                        clientSideReader.start();
                    }
                }
                catch (Exception exception) {
                    packetWriter.writeRecorderMessage(2, "exception in socket accept: " + exception);
                    continue;
                }
                break;
            }
        }
    }
}

