/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.LoggingParsersPlugin;

public final class ParserUtilities {
    private static ResourceBundle resourceBundle = null;

    public static String getResourceString(String key) {
        if (resourceBundle == null) {
            try {
                resourceBundle = LoggingParsersPlugin.getResourceBundle();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", Locale.getDefault());
                }
                catch (MissingResourceException m) {
                    return key;
                }
            }
        }
        try {
            return resourceBundle.getString(key.trim()).trim();
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getResourceString(String key, String argument) {
        return ParserUtilities.getResourceString(key, new String[]{argument});
    }

    public static String getResourceString(String key, String argumentA, String argumentB) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB});
    }

    public static String getResourceString(String key, String argumentA, String argumentB, String argumentC) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB, argumentC});
    }

    public static String getResourceString(String key, String[] arguments) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(key), arguments);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static void exceptionHandler(Throwable throwable, long faultyLineNum, String faultyLine, String message) throws LogParserException {
        StringBuffer finalMsg = new StringBuffer(ParserUtilities.getResourceString("INVALID_LINE_NUMBER_ERROR_", String.valueOf(faultyLineNum)));
        String lineSep = Constants.LINE_SEPARATOR;
        finalMsg.append(':').append(lineSep).append(lineSep).append(faultyLine).append(lineSep);
        String errorMsg = null;
        if (throwable != null) {
            errorMsg = throwable.getMessage();
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            finalMsg.append(errorMsg).append(lineSep);
        }
        finalMsg.append(message);
        LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static void exceptionHandler(Throwable throwable, String message) throws LogParserException {
        String lineSep = Constants.LINE_SEPARATOR;
        StringBuffer finalMsg = new StringBuffer();
        if (throwable != null && throwable.getMessage() != null && throwable.getMessage().length() > 0) {
            finalMsg.append(throwable.getMessage()).append(lineSep);
        }
        finalMsg.append(message);
        LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static boolean isValidIPAddress(String ipAddress) {
        block3: {
            StringTokenizer tokens = new StringTokenizer(ipAddress, ".", true);
            if (tokens.countTokens() != 7) break block3;
            try {
                int number = Integer.parseInt(tokens.nextToken());
                if (number >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255) {
                    return true;
                }
            }
            catch (NumberFormatException n) {}
        }
        return false;
    }
}

