/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceImpl
extends NotifierImpl
implements Resource,
Resource.Internal {
    private static URIConverter defaultURIConverter;
    protected Map defaultSaveOptions;
    protected Map defaultLoadOptions;
    protected ResourceSet resourceSet;
    protected URI uri;
    protected ContentsEList contents;
    protected EList errors;
    protected EList warnings;
    protected boolean isModified;
    protected boolean isLoaded;
    protected Adapter modificationTrackingAdapter;

    protected static URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new URIConverterImpl();
        }
        return defaultURIConverter;
    }

    public ResourceImpl() {
    }

    public ResourceImpl(URI uri) {
        this();
        this.uri = uri;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        ResourceSet oldResourceSet = this.resourceSet;
        if (oldResourceSet != null) {
            notifications = ((InternalEList)oldResourceSet.getResources()).basicRemove(this, notifications);
        }
        this.resourceSet = resourceSet;
        if (this.eNotificationRequired()) {
            if (notifications == null) {
                notifications = new NotificationChainImpl(2);
            }
            notifications.add((Notification)new NotificationImpl(1, oldResourceSet, resourceSet){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 0;
                }
            });
        }
        return notifications;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        URI oldURI = this.uri;
        this.uri = uri;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldURI, uri){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 1;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new ContentsEList();
        }
        return this.contents;
    }

    public TreeIterator getAllContents() {
        return new AbstractTreeIterator(this, false){

            public Iterator getChildren(Object object) {
                return object == ResourceImpl.this ? ResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public EList getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 6;
                }
            };
        }
        return this.errors;
    }

    public EList getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 7;
                }
            };
        }
        return this.warnings;
    }

    protected boolean useZip() {
        return false;
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        EList contents = this.getContents();
        return contents.size() > 1 ? Integer.toString(this.getContents().indexOf((Object)eObject)) : "";
    }

    public String getURIFragment(EObject eObject) {
        String id = EcoreUtil.getID(eObject);
        if (id != null) {
            return id;
        }
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainingFeature(), eObject));
            eObject = container;
            container = eObject.eContainer();
        }
        StringBuffer result = new StringBuffer("/");
        result.append(this.getURIFragmentRootSegment(eObject));
        ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
        while (i.hasPrevious()) {
            result.append('/');
            result.append((String)i.previous());
        }
        return result.toString();
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EList contents;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new WrappedException((Exception)exception);
            }
        }
        if (position < (contents = this.getContents()).size()) {
            return (EObject)contents.get(position);
        }
        return null;
    }

    public EObject getEObject(String uriFragment) {
        if (uriFragment.startsWith("//")) {
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            uriFragmentPath.add("");
            StringTokenizer stringTokenizer = new StringTokenizer(uriFragment.substring(2), "/");
            while (stringTokenizer.hasMoreTokens()) {
                uriFragmentPath.add(stringTokenizer.nextToken());
            }
            return this.getEObject(uriFragmentPath);
        }
        if (uriFragment.startsWith("/")) {
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(uriFragment, "/");
            while (stringTokenizer.hasMoreTokens()) {
                uriFragmentPath.add(stringTokenizer.nextToken());
            }
            return this.getEObject(uriFragmentPath);
        }
        return this.getEObjectByID(uriFragment);
    }

    protected EObject getEObject(List uriFragmentPath) {
        Iterator fragments = uriFragmentPath.iterator();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(!fragments.hasNext() ? "" : (String)fragments.next());
        while (fragments.hasNext() && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)fragments.next());
        }
        return eObject;
    }

    protected EObject getEObjectByID(String id) {
        TreeIterator i = this.getAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            if (!id.equals(EcoreUtil.getID(eObject))) continue;
            return eObject;
        }
        return null;
    }

    public void attached(EObject eObject) {
        if (this.isTrackingModification()) {
            this.addModificationTrackingAdapters(eObject);
        }
    }

    protected void addModificationTrackingAdapters(EObject eObject) {
        eObject.eAdapters().add((Object)this.modificationTrackingAdapter);
        TreeIterator tree = eObject.eAllContents();
        while (tree.hasNext()) {
            EObject child = (EObject)tree.next();
            child.eAdapters().add((Object)this.modificationTrackingAdapter);
        }
    }

    public void detached(EObject eObject) {
        if (this.isTrackingModification()) {
            this.removeModificationTrackingAdapters(eObject);
        }
    }

    protected void removeModificationTrackingAdapters(EObject eObject) {
        eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        if (EcorePackage.eINSTANCE != null) {
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                EObject child = (EObject)tree.next();
                child.eAdapters().remove((Object)this.modificationTrackingAdapter);
            }
        }
    }

    protected URIConverter getURIConverter() {
        return this.getResourceSet() == null ? ResourceImpl.getDefaultURIConverter() : this.getResourceSet().getURIConverter();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Map options) throws IOException {
        URIConverter uriConverter = this.getURIConverter();
        OutputStream outputStream = uriConverter.createOutputStream(this.getURI());
        try {
            this.save(outputStream, options);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            outputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Map options) throws IOException {
        if (this.isLoaded) return;
        URIConverter uriConverter = this.getURIConverter();
        InputStream inputStream = uriConverter.createInputStream(this.getURI());
        try {
            this.load(inputStream, options);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        inputStream.close();
    }

    protected ZipEntry newContentZipEntry() {
        return new ZipEntry("ResourceContents");
    }

    public final void save(OutputStream outputStream, Map options) throws IOException {
        ZipOutputStream zipOutputStream = null;
        if (this.useZip()) {
            zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.putNextEntry(this.newContentZipEntry());
            outputStream = zipOutputStream;
        }
        if (this.defaultSaveOptions == null || this.defaultSaveOptions.isEmpty()) {
            this.doSave(outputStream, options);
        } else if (options == null) {
            this.doSave(outputStream, this.defaultSaveOptions);
        } else {
            HashMap mergedOptions = new HashMap(this.defaultSaveOptions);
            mergedOptions.putAll(options);
            this.doSave(outputStream, mergedOptions);
        }
        this.setModified(false);
        if (zipOutputStream != null) {
            zipOutputStream.finish();
        }
    }

    protected void doSave(OutputStream outputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean isContentZipEntry(ZipEntry zipEntry) {
        return true;
    }

    public final void load(InputStream inputStream, Map options) throws IOException {
        if (!this.isLoaded) {
            Notification notification = this.setLoaded(true);
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            if (this.useZip()) {
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                while (zipInputStream.available() != 0) {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    if (!this.isContentZipEntry(zipEntry)) continue;
                    inputStream = zipInputStream;
                    break;
                }
            }
            if (this.defaultLoadOptions == null || this.defaultLoadOptions.isEmpty()) {
                this.doLoad(inputStream, options);
            } else if (options == null) {
                this.doLoad(inputStream, this.defaultLoadOptions);
            } else {
                HashMap mergedOptions = new HashMap(this.defaultLoadOptions);
                mergedOptions.putAll(options);
                this.doLoad(inputStream, mergedOptions);
            }
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
        }
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(this.getURIFragment(internalEObject)));
        internalEObject.eAdapters().clear();
    }

    protected Notification setLoaded(boolean isLoaded) {
        boolean oldIsLoaded = this.isLoaded;
        this.isLoaded = isLoaded;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsLoaded, isLoaded){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 4;
                }
            };
            return notification;
        }
        return null;
    }

    protected void doUnload() {
        TreeIterator allContents = EcoreUtil.getAllContents(new ArrayList(this.getContents()));
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
    }

    public final void unload() {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload();
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    public boolean isTrackingModification() {
        return this.modificationTrackingAdapter != null;
    }

    public void setTrackingModification(boolean isTrackingModification) {
        boolean oldIsTrackingModification;
        boolean bl = oldIsTrackingModification = this.modificationTrackingAdapter != null;
        if (oldIsTrackingModification != isTrackingModification) {
            Iterator i;
            Adapter adapter = this.modificationTrackingAdapter = isTrackingModification ? this.createModificationTrackingAdapter() : null;
            if (isTrackingModification) {
                i = this.getContents().iterator();
                while (i.hasNext()) {
                    this.addModificationTrackingAdapters((EObject)i.next());
                }
            } else {
                i = this.getContents().iterator();
                while (i.hasNext()) {
                    this.removeModificationTrackingAdapters((EObject)i.next());
                }
            }
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsTrackingModification, isTrackingModification){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 5;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ModificationTrackingAdapter();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        boolean oldIsModified = this.isModified;
        this.isModified = isModified;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsModified, isModified){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 3;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    public String toKeyString() {
        StringBuffer result = new StringBuffer("Key type: ");
        result.append(this.getClass().toString());
        return result.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(this.hashCode()) + " uri='" + this.uri + "'";
    }

    protected class ContentsEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ContentsEList() {
        }

        public Object getNotifier() {
            return ResourceImpl.this;
        }

        public int getFeatureID() {
            return 2;
        }

        protected boolean isNotificationRequired() {
            return ResourceImpl.this.eNotificationRequired();
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            notifications = eObject.eSetResource(ResourceImpl.this, notifications);
            ResourceImpl.this.attached(eObject);
            return notifications;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            if (ResourceImpl.this.isLoaded) {
                ResourceImpl.this.detached(eObject);
            }
            return eObject.eSetResource(null, notifications);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public List basicList() {
            return super.basicList();
        }

        protected Object[] newData(int capacity) {
            return new EObject[capacity];
        }

        protected void didAdd(int index, Object object) {
            super.didAdd(index, object);
            this.loaded();
            this.modified();
        }

        protected void didRemove(int index, Object object) {
            super.didRemove(index, object);
            this.modified();
        }

        protected void didSet(int index, Object newObject, Object oldObject) {
            super.didSet(index, newObject, oldObject);
            this.modified();
        }

        protected void didClear(int oldSize, Object[] oldData) {
            if (oldSize == 0) {
                this.loaded();
            } else {
                super.didClear(oldSize, oldData);
            }
        }

        protected void loaded() {
            Notification notification;
            if (!ResourceImpl.this.isLoaded() && (notification = ResourceImpl.this.setLoaded(true)) != null) {
                ResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (ResourceImpl.this.isTrackingModification()) {
                ResourceImpl.this.setModified(true);
            }
        }
    }

    protected class ModificationTrackingAdapter
    extends AdapterImpl {
        protected ModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 7: {
                    if (notification.isTouch()) break;
                    ResourceImpl.this.setModified(true);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ResourceImpl.this.setModified(true);
                }
            }
        }
    }
}

