/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.loaders.util.RegistryReader;

class HyadesResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_FACTORY = "hyadesResourceFactory";
    static final String ATT_FILE_POSTFIX = "filePostfix";
    static final String ATT_CLASS = "class";

    public HyadesResourceRegistryReader() {
        super("hyades_resource_factory");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_RESOURCE_FACTORY)) {
            String filePostfix = element.getAttribute(ATT_FILE_POSTFIX);
            if (filePostfix == null) {
                this.logMissingAttribute(element, ATT_FILE_POSTFIX);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else if (HyadesResourceExtensions.getInstance().containsKey(filePostfix)) {
                this.logError(element, "A Hyades resource extension for this \"" + filePostfix + "\" already exists, this extension will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    HyadesResourceExtensions.getInstance().put(filePostfix, (IHyadesResourceFactory)classDescriptor.createInstance());
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

